/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.messaging;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.util.email.EmailBean;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.Recipient;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.commons.FenixActionForward;
import org.fenixedu.academic.ui.struts.action.messaging.MessagingApplication;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.FenixFramework;

@StrutsFunctionality(app=MessagingApplication.MessagingEmailsApp.class, path="new-email", titleKey="label.email.new")
@Mapping(path="/emails", module="messaging")
@Forwards(value={@Forward(name="new.email", path="/messaging/newEmail.jsp"), @Forward(name="cancel", path="/messaging/announcements/announcementsStartPageHandler.do?method=news")})
public class EmailsDA
extends FenixDispatchAction {
    public static final ActionForward FORWARD_TO_NEW_EMAIL = new ActionForward("emails", "/emails.do?method=forwardToNewEmail", false, "/messaging");

    public ActionForward cancel(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("cancel");
    }

    public ActionForward forwardToNewEmail(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("new.email");
    }

    @EntryPoint
    public ActionForward newEmail(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        EmailBean emailBean = (EmailBean)this.getRenderedObject("emailBean");
        if (emailBean == null) {
            emailBean = (EmailBean)request.getAttribute("emailBean");
        }
        if (emailBean == null) {
            emailBean = new EmailBean();
            String senderExternalId = request.getParameter("sender");
            if (Strings.isNullOrEmpty((String)senderExternalId)) {
                Set<Sender> availableSenders = Sender.getAvailableSenders();
                if (availableSenders.size() == 1) {
                    emailBean.setSender(availableSenders.iterator().next());
                }
            } else {
                Sender sender = (Sender)FenixFramework.getDomainObject((String)senderExternalId);
                emailBean.setSender(sender);
                String[] recipientsParameter = request.getParameterValues("recipient");
                if (recipientsParameter != null) {
                    List<Recipient> recipients = Stream.of(recipientsParameter).map(recipientExternalId -> (Recipient)FenixFramework.getDomainObject((String)recipientExternalId)).collect(Collectors.toList());
                    emailBean.setRecipients(recipients);
                }
            }
        }
        RenderUtils.invalidateViewState();
        request.setAttribute("emailBean", (Object)emailBean);
        return mapping.findForward("new.email");
    }

    public ActionForward sendEmail(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        EmailBean emailBean = (EmailBean)this.getRenderedObject("emailBean");
        RenderUtils.invalidateViewState();
        String validate = emailBean.validate();
        if (validate != null) {
            String noneSentString = BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.email.none.sent", (String[])new String[0]);
            request.setAttribute("errorMessage", (Object)(noneSentString + " " + validate));
            request.setAttribute("emailBean", (Object)emailBean);
            return mapping.findForward("new.email");
        }
        Message message = emailBean.send();
        request.setAttribute("created", (Object)Boolean.TRUE);
        return new FenixActionForward(request, new ActionForward("/viewSentEmails.do?method=viewEmail&messagesId=" + message.getExternalId(), true));
    }

    public static ActionForward sendEmail(HttpServletRequest request, Sender sender, Recipient ... recipient) {
        EmailBean emailBean = new EmailBean();
        if (recipient != null) {
            emailBean.setRecipients(Arrays.asList(recipient));
        }
        if (sender != null) {
            emailBean.setSender(sender);
        }
        request.setAttribute("emailBean", (Object)emailBean);
        return FORWARD_TO_NEW_EMAIL;
    }
}

