/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.commons.documentRequestExcel;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.IDiplomaRequest;
import org.fenixedu.academic.domain.serviceRequests.IDiplomaSupplementRequest;
import org.fenixedu.academic.domain.serviceRequests.IRegistryDiplomaRequest;
import org.fenixedu.academic.domain.serviceRequests.RegistrationAcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.RegistryCode;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IDocumentRequest;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.spreadsheet.SheetData;
import org.fenixedu.commons.spreadsheet.SpreadsheetBuilder;
import org.fenixedu.commons.spreadsheet.WorkbookExportFormat;

public class DocumentRequestExcelUtils {
    HttpServletRequest request;
    HttpServletResponse response;

    public DocumentRequestExcelUtils(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public void generateSortedExcel(Set<AcademicServiceRequest> documents, String prefix) {
        TreeSet<AcademicServiceRequest> sorted = new TreeSet<AcademicServiceRequest>(DocumentRequest.COMPARATOR_BY_REGISTRY_NUMBER);
        sorted.addAll(documents);
        this.generate(sorted, this.getCodes(sorted), prefix);
    }

    public void generateExcel(Set<AcademicServiceRequest> documents, String prefix) {
        this.generate(documents, this.getCodes(documents), prefix);
    }

    private Set<RegistryCode> getCodes(Set<AcademicServiceRequest> documents) {
        HashSet<RegistryCode> codes = new HashSet<RegistryCode>();
        for (AcademicServiceRequest document : documents) {
            codes.add(document.getRegistryCode());
        }
        return codes;
    }

    private void generate(Set<AcademicServiceRequest> documents, Set<RegistryCode> codes, String prefix) {
        SheetData<AcademicServiceRequest> data = new SheetData<AcademicServiceRequest>(documents){

            protected void makeLine(AcademicServiceRequest request) {
                IDocumentRequest document = (IDocumentRequest)((Object)request);
                this.addCell("C\u00f3digo", document.getRegistryCode().getCode());
                this.addCell("Tipo de Documento", BundleUtil.getString((String)"resources.EnumerationResources", (String)document.getDocumentRequestType().name(), (String[])new String[0]));
                ProgramConclusion programConclusion = null;
                switch (document.getDocumentRequestType()) {
                    case REGISTRY_DIPLOMA_REQUEST: {
                        programConclusion = ((IRegistryDiplomaRequest)document).getProgramConclusion();
                        break;
                    }
                    case DIPLOMA_REQUEST: {
                        programConclusion = ((IDiplomaRequest)document).getProgramConclusion();
                        break;
                    }
                    case DIPLOMA_SUPPLEMENT_REQUEST: {
                        programConclusion = ((IDiplomaSupplementRequest)document).getProgramConclusion();
                        break;
                    }
                    default: {
                        this.addCell(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.programConclusion", (String[])new String[0]));
                    }
                }
                this.addCell(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.programConclusion", (String[])new String[0]), programConclusion != null ? programConclusion.getName().getContent() : null);
                if (document.isRequestForRegistration()) {
                    this.addCell("Tipo de Curso", ((RegistrationAcademicServiceRequest)((Object)document)).getDegreeType().getName().getContent());
                } else if (document.isRequestForPhd()) {
                    this.addCell("Tipo de Estudos", "Programa doutoral");
                }
                this.addCell("N\u00ba de Aluno", document.getStudent().getNumber());
                this.addCell("Nome", document.getPerson().getName());
                if (!document.isDiploma()) {
                    this.addCell("Ficheiro", request.getLastGeneratedDocument().getFilename());
                }
            }
        };
        try {
            this.response.setContentType("application/vnd.ms-excel");
            this.response.setHeader("Content-disposition", "attachment; filename=" + prefix + "-(" + codes.size() + ").xls");
            ServletOutputStream writer = this.response.getOutputStream();
            new SpreadsheetBuilder().addSheet("lote", (SheetData)data).build(WorkbookExportFormat.EXCEL, (OutputStream)writer);
            writer.flush();
            this.response.flushBuffer();
        }
        catch (IOException e) {
            throw new DomainException("error.rectorateSubmission.errorGeneratingMetadata", e, new String[0]);
        }
    }
}

