/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.providers.candidacy;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcessWithPrecedentDegreeInformationBean;
import org.fenixedu.academic.domain.candidacyProcess.graduatedPerson.DegreeCandidacyForGraduatedPersonProcess;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.ui.struts.action.candidacy.CandidacyProcessDA;
import org.fenixedu.bennu.core.security.Authenticate;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyConverter;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class DegreeChangeIndividualCandidacyDegreesProvider
implements DataProvider {
    public Object provide(Object source, Object currentValue) {
        final Set programs = AcademicAccessRule.getProgramsAccessibleToFunction(AcademicOperationType.MANAGE_INDIVIDUAL_CANDIDACIES, Authenticate.getUser()).collect(Collectors.toSet());
        return Collections2.filter(this.getDegrees(source), (Predicate)new Predicate<Degree>(){

            public boolean apply(Degree degree) {
                return programs.contains(degree);
            }
        });
    }

    private Collection<Degree> getDegrees(Object source) {
        CandidacyProcessDA.ChooseDegreeBean bean;
        CandidacyProcess candidacyProcess;
        if (source instanceof IndividualCandidacyProcessWithPrecedentDegreeInformationBean) {
            IndividualCandidacyProcessWithPrecedentDegreeInformationBean bean2 = (IndividualCandidacyProcessWithPrecedentDegreeInformationBean)source;
            if (bean2.getCandidacyProcess() != null) {
                return bean2.getCandidacyProcess().getDegreeSet();
            }
            return bean2.getIndividualCandidacyProcess().getCandidacyProcess().getDegreeSet();
        }
        if (source instanceof CandidacyProcessDA.ChooseDegreeBean && (candidacyProcess = (bean = (CandidacyProcessDA.ChooseDegreeBean)source).getCandidacyProcess()) instanceof DegreeCandidacyForGraduatedPersonProcess) {
            DegreeCandidacyForGraduatedPersonProcess candidacyForGraduatedPersonProcess = (DegreeCandidacyForGraduatedPersonProcess)((Object)candidacyProcess);
            return candidacyForGraduatedPersonProcess.getAvailableDegrees();
        }
        return Degree.readAllMatching(DegreeType.oneOf(DegreeType::isBolonhaMasterDegree, DegreeType::isIntegratedMasterDegree));
    }

    public Converter getConverter() {
        return new DomainObjectKeyConverter();
    }
}

