/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report.thesis;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.thesis.Thesis;
import org.fenixedu.academic.domain.thesis.ThesisEvaluationParticipant;
import org.fenixedu.academic.report.FenixReport;
import org.fenixedu.bennu.core.domain.Bennu;

public abstract class ThesisDocument
extends FenixReport {
    private final Thesis thesis;

    public ThesisDocument(Thesis thesis) {
        this.thesis = thesis;
        this.fillReport();
    }

    protected Thesis getThesis() {
        return this.thesis;
    }

    @Override
    protected void fillReport() {
        this.fillGeneric();
        this.fillInstitution();
        this.fillDegree();
        this.fillStudent();
        this.fillOrientation();
        this.fillThesisInfo();
        this.fillJury();
    }

    protected void fillGeneric() {
    }

    protected void fillInstitution() {
        this.addParameter("institutionName", this.neverNull(Bennu.getInstance().getInstitutionUnit().getName()).toUpperCase());
    }

    protected void fillDegree() {
        Degree degree = this.thesis.getDegree();
        this.addParameter("studentDegreeName", this.neverNull(degree.getNameI18N(this.thesis.getExecutionYear()).toString()));
    }

    protected void fillStudent() {
        Student student = this.thesis.getStudent();
        this.addParameter("studentNumber", student.getNumber());
        Person person = student.getPerson();
        this.addParameter("studentName", person.getName());
    }

    protected void fillThesisInfo() {
        this.addParameter("thesisTitle", this.thesis.getTitle().getContent());
    }

    protected void fillOrientation() {
        List advisors = this.thesis.getOrientation().stream().map(orientator -> new OrientationInfo(orientator.getName(), this.participantCategoryName((ThesisEvaluationParticipant)((Object)orientator)), this.neverNull(orientator.getAffiliation()))).collect(Collectors.toList());
        this.addParameter("advisors", advisors);
    }

    protected void fillJury() {
        ThesisEvaluationParticipant juryPresident = this.thesis.getPresident();
        this.addParameter("juryPresidentName", juryPresident.getName());
        this.addParameter("juryPresidentCategory", this.participantCategoryName(juryPresident));
        this.addParameter("juryPresidentAffiliation", this.neverNull(juryPresident.getAffiliation()));
        TreeSet<ThesisEvaluationParticipant> vowels = new TreeSet<ThesisEvaluationParticipant>(ThesisEvaluationParticipant.COMPARATOR_BY_PERSON_NAME);
        vowels.addAll(this.thesis.getVowels());
        Iterator iterator = vowels.iterator();
        int guidanceVowel = 0;
        for (int i = 1; i <= 4; ++i) {
            String vowelPrefix = "vowel" + i;
            if (iterator.hasNext()) {
                ThesisEvaluationParticipant vowel = (ThesisEvaluationParticipant)((Object)iterator.next());
                if (guidanceVowel == 0 && this.isGuidanceVowel(vowel)) {
                    guidanceVowel = i;
                }
                this.addParameter(vowelPrefix + "Name", vowel.getName());
                this.addParameter(vowelPrefix + "Category", this.participantCategoryName(vowel));
                this.addParameter(vowelPrefix + "Affiliation", this.neverNull(vowel.getAffiliation()));
                continue;
            }
            this.addParameter(vowelPrefix + "Name", "");
            this.addParameter(vowelPrefix + "Category", "");
            this.addParameter(vowelPrefix + "Affiliation", "");
        }
        this.addParameter("guidanceVowel", guidanceVowel);
    }

    protected String neverNull(String value) {
        return value == null ? "" : value;
    }

    private boolean isGuidanceVowel(ThesisEvaluationParticipant vowel) {
        Person vowelPerson = vowel.getPerson();
        Set<Person> orientationPersons = this.thesis.getOrientationPersons();
        return vowelPerson != null && orientationPersons.contains((Object)vowelPerson);
    }

    private String participantCategoryName(ThesisEvaluationParticipant participant) {
        if (participant == null) {
            return "";
        }
        if (participant.getCategory() == null) {
            return "";
        }
        return participant.getCategory();
    }

    public static class OrientationInfo {
        private final String advisorName;
        private final String advisorCategory;
        private final String advisorAffiliation;

        public OrientationInfo(String advisorName, String advisorCategory, String advisorAffiliation) {
            this.advisorName = advisorName;
            this.advisorCategory = advisorCategory;
            this.advisorAffiliation = advisorAffiliation;
        }

        public String getAdvisorCategory() {
            return this.advisorCategory;
        }

        public String getAdvisorAffiliation() {
            return this.advisorAffiliation;
        }

        public String getAdvisorName() {
            return this.advisorName;
        }
    }
}

