/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.predicate;

import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.space.LessonInstanceSpaceOccupation;
import org.fenixedu.academic.domain.space.LessonSpaceOccupation;
import org.fenixedu.academic.domain.space.SpaceOccupation;
import org.fenixedu.academic.domain.space.WrittenEvaluationSpaceOccupation;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.AccessControlPredicate;

public class SpacePredicates {
    private static final AccessControlPredicate<SpaceOccupation> checkPermissionsToManageOccupationsWithoutCheckSpaceManager = new AccessControlPredicate<SpaceOccupation>(){

        @Override
        public boolean evaluate(SpaceOccupation spaceOccupation) {
            spaceOccupation.checkPermissionsToManageSpaceOccupationsWithoutCheckSpaceManager();
            return true;
        }
    };
    public static final AccessControlPredicate<WrittenEvaluationSpaceOccupation> checkPermissionsToManageWrittenEvaluationSpaceOccupations = new AccessControlPredicate<WrittenEvaluationSpaceOccupation>(){

        @Override
        public boolean evaluate(WrittenEvaluationSpaceOccupation spaceOccupation) {
            return checkPermissionsToManageOccupationsWithoutCheckSpaceManager.evaluate(spaceOccupation);
        }
    };
    public static final AccessControlPredicate<LessonSpaceOccupation> checkPermissionsToManageLessonSpaceOccupations = new AccessControlPredicate<LessonSpaceOccupation>(){

        @Override
        public boolean evaluate(LessonSpaceOccupation spaceOccupation) {
            return checkPermissionsToManageOccupationsWithoutCheckSpaceManager.evaluate(spaceOccupation);
        }
    };
    public static final AccessControlPredicate<LessonSpaceOccupation> checkPermissionsToDeleteLessonSpaceOccupations = new AccessControlPredicate<LessonSpaceOccupation>(){

        @Override
        public boolean evaluate(LessonSpaceOccupation spaceOccupation) {
            ExecutionCourse executionCourse;
            Person loggedPerson = AccessControl.getPerson();
            if (loggedPerson.hasProfessorshipForExecutionCourse(executionCourse = spaceOccupation.getLesson().getExecutionCourse())) {
                return true;
            }
            return checkPermissionsToManageLessonSpaceOccupations.evaluate(spaceOccupation);
        }
    };
    public static final AccessControlPredicate<LessonInstanceSpaceOccupation> checkPermissionsToManageLessonInstanceSpaceOccupations = new AccessControlPredicate<LessonInstanceSpaceOccupation>(){

        @Override
        public boolean evaluate(LessonInstanceSpaceOccupation lessonInstanceSpaceOccupation) {
            return true;
        }
    };
    public static final AccessControlPredicate<LessonInstanceSpaceOccupation> checkPermissionsToManageLessonInstanceSpaceOccupationsWithTeacherCheck = new AccessControlPredicate<LessonInstanceSpaceOccupation>(){

        @Override
        public boolean evaluate(LessonInstanceSpaceOccupation lessonInstanceSpaceOccupation) {
            Person loggedPerson = AccessControl.getPerson();
            if (loggedPerson.getProfessorshipsSet().size() > 0) {
                return true;
            }
            return true;
        }
    };
}

