/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.commons;

import java.io.Serializable;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.organizationalStructure.DepartmentUnit;
import pt.ist.fenixframework.FenixFramework;

public class CurricularCourseByExecutionSemesterBean
implements Serializable,
Comparable<CurricularCourseByExecutionSemesterBean> {
    private CurricularCourse curricularCourse;
    private ExecutionSemester executionSemester;

    public CurricularCourseByExecutionSemesterBean() {
    }

    public CurricularCourseByExecutionSemesterBean(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        this.setCurricularCourse(curricularCourse);
        this.setExecutionSemester(executionSemester);
    }

    public CurricularCourse getCurricularCourse() {
        return this.curricularCourse;
    }

    public void setCurricularCourse(CurricularCourse curricularCourse) {
        this.curricularCourse = curricularCourse;
    }

    public ExecutionSemester getExecutionSemester() {
        return this.executionSemester;
    }

    public void setExecutionSemester(ExecutionSemester executionSemester) {
        this.executionSemester = executionSemester;
    }

    public ExecutionYear getExecutionYear() {
        return this.executionSemester.getExecutionYear();
    }

    public String getCurricularCourseName() {
        return this.getCurricularCourse().getName(this.getExecutionSemester());
    }

    public String getCurricularCourseNameEn() {
        return this.getCurricularCourse().getNameEn(this.getExecutionSemester());
    }

    public Double getCurricularCourseEcts() {
        return this.getCurricularCourse().getEctsCredits(this.getExecutionSemester());
    }

    public String getDegreeName() {
        return this.getCurricularCourse().getDegree().getNameFor(this.getExecutionSemester()).getContent();
    }

    public String getKey() {
        return this.getCurricularCourse().getExternalId() + ":" + this.getExecutionSemester().getExternalId();
    }

    public String getAcronym() {
        return this.getCurricularCourse().getAcronym(this.getExecutionSemester());
    }

    public DepartmentUnit getDepartmentUnit() {
        return this.getCurricularCourse().getDepartmentUnit(this.getExecutionSemester());
    }

    public Double getWeight() {
        return this.getCurricularCourse().getWeight(this.getExecutionSemester());
    }

    public String getObjectives() {
        return this.getCurricularCourse().getObjectives(this.getExecutionSemester());
    }

    public String getObjectivesEn() {
        return this.getCurricularCourse().getObjectivesEn(this.getExecutionSemester());
    }

    public String getProgram() {
        return this.getCurricularCourse().getProgram(this.getExecutionSemester());
    }

    public String getProgramEn() {
        return this.getCurricularCourse().getProgramEn(this.getExecutionSemester());
    }

    public String getEvaluationMethod() {
        return this.getCurricularCourse().getEvaluationMethod(this.getExecutionSemester());
    }

    public String getEvaluationMethodEn() {
        return this.getCurricularCourse().getEvaluationMethodEn(this.getExecutionSemester());
    }

    public boolean equals(Object obj) {
        return obj instanceof CurricularCourseByExecutionSemesterBean ? this.equals((CurricularCourseByExecutionSemesterBean)obj) : false;
    }

    public boolean equals(CurricularCourseByExecutionSemesterBean obj) {
        return this.getCurricularCourse() == obj.getCurricularCourse();
    }

    public int hashCode() {
        return this.getCurricularCourse().hashCode();
    }

    @Override
    public int compareTo(CurricularCourseByExecutionSemesterBean other) {
        return other == null ? 1 : CurricularCourse.COMPARATOR_BY_NAME.compare(this.getCurricularCourse(), other.getCurricularCourse());
    }

    public static CurricularCourseByExecutionSemesterBean buildFrom(String key) {
        if (key == null || key.isEmpty()) {
            return null;
        }
        String[] values = key.split(":");
        CurricularCourse course = (CurricularCourse)FenixFramework.getDomainObject((String)values[0]);
        ExecutionSemester semester = (ExecutionSemester)FenixFramework.getDomainObject((String)values[1]);
        return new CurricularCourseByExecutionSemesterBean(course, semester);
    }
}

