/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.thesis;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.Coordinator;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.MarkSheet;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.ScientificCommission;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.FieldIsRequiredException;
import org.fenixedu.academic.domain.organizationalStructure.ScientificCouncilUnit;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.thesis.Thesis$callable$approveProposal;
import org.fenixedu.academic.domain.thesis.Thesis$callable$swapFilesVisibility;
import org.fenixedu.academic.domain.thesis.ThesisEvaluationParticipant;
import org.fenixedu.academic.domain.thesis.ThesisFile;
import org.fenixedu.academic.domain.thesis.ThesisLibraryState;
import org.fenixedu.academic.domain.thesis.ThesisParticipationType;
import org.fenixedu.academic.domain.thesis.ThesisState;
import org.fenixedu.academic.domain.thesis.ThesisVisibilityType;
import org.fenixedu.academic.domain.thesis.Thesis_Base;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.Recipient;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.dto.degreeAdministrativeOffice.gradeSubmission.MarkSheetEnrolmentEvaluationBean;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.ThesisPredicates;
import org.fenixedu.academic.util.EvaluationType;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.groups.UserGroup;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.signals.DomainObjectEvent;
import org.fenixedu.bennu.signals.Signal;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.atomic.AtomicContextFactory;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public class Thesis
extends Thesis_Base {
    public static final String PROPOSAL_APPROVED_SIGNAL = "academic.Thesis.proposal.approved";
    public static final Comparator<Thesis> COMPARATOR_BY_STUDENT;
    public static final Advice advice$approveProposal;
    public static final Advice advice$swapFilesVisibility;

    protected Thesis() {
        this.setRootDomainObject(Bennu.getInstance());
        this.setDeclarationAccepted(false);
        this.create();
    }

    public Thesis(Degree degree, Enrolment enrolment, MultiLanguageString title) {
        this();
        if (degree == null) {
            throw new FieldIsRequiredException("enrolment", "thesis.degree.required");
        }
        if (enrolment == null) {
            throw new FieldIsRequiredException("enrolment", "thesis.enrolment.required");
        }
        this.setDegree(degree);
        this.setEnrolment(enrolment);
        this.setTitle(title);
    }

    public boolean isDeclarationAccepted() {
        Boolean accepted = this.getDeclarationAccepted();
        return accepted == null ? false : accepted;
    }

    public void setTitle(MultiLanguageString title) {
        if (title == null || title.isEmpty()) {
            throw new FieldIsRequiredException("title", "thesis.title.required");
        }
        super.setTitle(title);
    }

    public MultiLanguageString getFinalTitle() {
        ThesisFile dissertation = this.getDissertation();
        if (dissertation == null) {
            return this.getTitle();
        }
        Locale dlanguage = dissertation.getLanguage();
        Locale language = dlanguage == null ? Locale.getDefault() : dlanguage;
        return new MultiLanguageString(language, dissertation.getTitle());
    }

    public MultiLanguageString getFinalSubtitle() {
        ThesisFile dissertation = this.getDissertation();
        if (dissertation == null) {
            return null;
        }
        String subTitle = dissertation.getSubTitle();
        if (subTitle == null) {
            return null;
        }
        return new MultiLanguageString(dissertation.getLanguage(), subTitle);
    }

    public void setFinalTitle(MultiLanguageString finalTitle) {
        this.setTitle(finalTitle);
        ThesisFile dissertation = this.getDissertation();
        if (dissertation != null) {
            Locale language = dissertation.getLanguage();
            if (language == null) {
                dissertation.setLanguage(finalTitle.getContentLocale());
                dissertation.setTitle(finalTitle.getContent());
            } else {
                String content = finalTitle.getContent(language);
                if (content == null) {
                    dissertation.setLanguage(finalTitle.getContentLocale());
                    dissertation.setTitle(finalTitle.getContent());
                } else {
                    dissertation.setTitle(content);
                }
            }
        }
    }

    public void setFinalSubtitle(MultiLanguageString finalSubtitle) {
        ThesisFile dissertation = this.getDissertation();
        if (dissertation != null) {
            Locale language = dissertation.getLanguage();
            if (language == null) {
                dissertation.setLanguage(finalSubtitle.getContentLocale());
                dissertation.setSubTitle(finalSubtitle.getContent());
            } else {
                String content = finalSubtitle.getContent(language);
                if (content == null) {
                    dissertation.setLanguage(finalSubtitle.getContentLocale());
                    dissertation.setSubTitle(finalSubtitle.getContent());
                } else {
                    dissertation.setSubTitle(content);
                }
            }
        }
    }

    public Locale getLanguage() {
        ThesisFile dissertation = this.getDissertation();
        return dissertation == null ? null : dissertation.getLanguage();
    }

    public final MultiLanguageString getFinalFullTitle() {
        ThesisFile dissertation = this.getDissertation();
        if (dissertation == null) {
            return this.getTitle();
        }
        StringBuilder result = new StringBuilder();
        result.append(dissertation.getTitle());
        result.append(StringUtils.isEmpty((String)dissertation.getSubTitle()) ? "" : ": " + dissertation.getSubTitle());
        Locale language = dissertation.getLanguage();
        return language == null ? new MultiLanguageString(result.toString()) : new MultiLanguageString(language, result.toString());
    }

    public void setDiscussed(DateTime discussed) {
        AccessControl.check(this, ThesisPredicates.studentOrAcademicAdministrativeOfficeOrScientificCouncil);
        if (discussed != null && this.getEnrolment().getCreationDateDateTime().isAfter((ReadableInstant)discussed)) {
            throw new DomainException("thesis.invalid.discussed.date.time", new String[0]);
        }
        super.setDiscussed(discussed);
    }

    public void setThesisAbstract(MultiLanguageString thesisAbstract) {
        AccessControl.check(this, ThesisPredicates.waitingConfirmation);
        super.setThesisAbstract(thesisAbstract);
    }

    public void setKeywords(MultiLanguageString keywords) {
        AccessControl.check(this, ThesisPredicates.waitingConfirmation);
        super.setKeywords(keywords);
    }

    public List<ThesisEvaluationParticipant> getOrientation() {
        return this.getParticipationsSet().stream().filter(p -> p.getType() == ThesisParticipationType.ORIENTATOR || p.getType() == ThesisParticipationType.COORIENTATOR).collect(Collectors.toList());
    }

    public ThesisEvaluationParticipant getPresident() {
        return this.getParticipant(ThesisParticipationType.PRESIDENT);
    }

    public ThesisEvaluationParticipant getCreator() {
        return this.getParticipant(ThesisParticipationType.STATE_CREATOR);
    }

    public ThesisEvaluationParticipant getSubmitter() {
        return this.getParticipant(ThesisParticipationType.STATE_SUBMITTER);
    }

    public ThesisEvaluationParticipant getProposalApprover() {
        return this.getParticipant(ThesisParticipationType.STATE_PROPOSAL_APPROVER);
    }

    public ThesisEvaluationParticipant getConfirmer() {
        return this.getParticipant(ThesisParticipationType.STATE_CONFIRMER);
    }

    public ThesisEvaluationParticipant getEvaluationApprover() {
        return this.getParticipant(ThesisParticipationType.STATE_EVALUATION_APPROVER);
    }

    public List<ThesisEvaluationParticipant> getVowels() {
        return this.getAllParticipants(ThesisParticipationType.VOWEL);
    }

    public ThesisEvaluationParticipant getParticipant(ThesisParticipationType type) {
        for (ThesisEvaluationParticipant participant : this.getParticipationsSet()) {
            if (participant.getType() != type) continue;
            return participant;
        }
        return null;
    }

    public List<ThesisEvaluationParticipant> getAllParticipants(ThesisParticipationType type) {
        return this.getAllParticipants(type, new ThesisParticipationType[0]);
    }

    public List<ThesisEvaluationParticipant> getAllParticipants(ThesisParticipationType type, ThesisParticipationType ... types) {
        List values = Lists.asList((Object)((Object)type), (Object[])types);
        return this.getParticipationsSet().stream().filter(p -> values.contains((Object)p.getType())).collect(Collectors.toList());
    }

    public void delete() {
        DomainException.throwWhenDeleteBlocked(this.getDeletionBlockers());
        this.setRootDomainObject(null);
        while (!this.getParticipationsSet().isEmpty()) {
            ((ThesisEvaluationParticipant)((Object)this.getParticipationsSet().iterator().next())).delete();
        }
        this.setDegree(null);
        this.removeEnrolment();
        this.deleteDomainObject();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (this.getState() != ThesisState.DRAFT) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"thesis.delete.notDraft", (String[])new String[0]));
        }
        if (this.getReaders() != null) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"thesis.delete.notDraft", (String[])new String[0]));
        }
    }

    public boolean isDeletable() {
        return this.getDeletionBlockers().isEmpty();
    }

    protected static Collection<Thesis> getThesisInState(Degree degree, ExecutionYear year, ThesisState state) {
        ArrayList<Thesis> theses = new ArrayList<Thesis>();
        for (Thesis thesis : Bennu.getInstance().getThesesSet()) {
            if (thesis.getState() != state || degree != null && thesis.getDegree() != degree || year != null && thesis.getEnrolment().getExecutionYear() != year) continue;
            theses.add(thesis);
        }
        return theses;
    }

    public static Collection<Thesis> getDraftThesis(Degree degree) {
        return Thesis.getThesisInState(degree, null, ThesisState.DRAFT);
    }

    public static Collection<Thesis> getSubmittedThesis() {
        return Thesis.getSubmittedThesis(null);
    }

    public static Collection<Thesis> getSubmittedThesis(Degree degree) {
        return Thesis.getSubmittedThesis(degree, null);
    }

    public static Collection<Thesis> getSubmittedThesis(Degree degree, ExecutionYear executionYear) {
        return Thesis.getThesisInState(degree, executionYear, ThesisState.SUBMITTED);
    }

    public static Collection<Thesis> getApprovedThesis() {
        return Thesis.getApprovedThesis(null);
    }

    public static Collection<Thesis> getApprovedThesis(Degree degree) {
        return Thesis.getApprovedThesis(degree, null);
    }

    public static Collection<Thesis> getApprovedThesis(Degree degree, ExecutionYear executionYear) {
        ArrayList<Thesis> result = new ArrayList<Thesis>();
        result.addAll(Thesis.getThesisInState(degree, executionYear, ThesisState.APPROVED));
        return result;
    }

    public static Collection<Thesis> getRevisionThesis() {
        return Thesis.getRevisionThesis(null);
    }

    public static Collection<Thesis> getRevisionThesis(Degree degree) {
        return Thesis.getRevisionThesis(degree, null);
    }

    public static Collection<Thesis> getRevisionThesis(Degree degree, ExecutionYear executionYear) {
        ArrayList<Thesis> result = new ArrayList<Thesis>();
        result.addAll(Thesis.getThesisInState(degree, executionYear, ThesisState.REVISION));
        return result;
    }

    public static Collection<Thesis> getConfirmedThesis() {
        return Thesis.getConfirmedThesis(null);
    }

    public static Collection<Thesis> getConfirmedThesis(Degree degree) {
        return Thesis.getConfirmedThesis(degree, null);
    }

    public static Collection<Thesis> getConfirmedThesis(Degree degree, ExecutionYear executionYear) {
        return Thesis.getThesisInState(degree, executionYear, ThesisState.CONFIRMED);
    }

    public static Collection<Thesis> getEvaluatedThesis() {
        return Thesis.getEvaluatedThesis(null);
    }

    public static Collection<Thesis> getEvaluatedThesis(Degree degree) {
        return Thesis.getEvaluatedThesis(degree, null);
    }

    public static Collection<Thesis> getEvaluatedThesis(Degree degree, ExecutionYear executionYear) {
        return Thesis.getThesisInState(degree, executionYear, ThesisState.EVALUATED);
    }

    public boolean hasCredits() {
        return this.isEvaluated() && this.hasFinalEnrolmentEvaluation();
    }

    private ExecutionDegree getExecutionDegree(Enrolment enrolment) {
        ExecutionYear executionYear = enrolment.getExecutionYear();
        DegreeCurricularPlan degreeCurricularPlan = enrolment.getDegreeCurricularPlanOfDegreeModule();
        return degreeCurricularPlan.getExecutionDegreeByYear(executionYear);
    }

    public void setEnrolment(Enrolment enrolment) {
        CurricularCourse curricularCourse;
        ExecutionDegree executionDegree = this.getExecutionDegree(enrolment);
        YearMonthDay beginThesisCreationPeriod = executionDegree.getBeginThesisCreationPeriod();
        YearMonthDay endThesisCreationPeriod = executionDegree.getEndThesisCreationPeriod();
        YearMonthDay today = new YearMonthDay();
        if (beginThesisCreationPeriod == null || beginThesisCreationPeriod.isAfter((ReadablePartial)today)) {
            throw new DomainException("thesis.creation.not.allowed.because.out.of.period", new String[0]);
        }
        if (endThesisCreationPeriod != null && endThesisCreationPeriod.isBefore((ReadablePartial)today)) {
            throw new DomainException("thesis.creation.not.allowed.because.out.of.period", new String[0]);
        }
        if (enrolment != null && !(curricularCourse = enrolment.getCurricularCourse()).isDissertation()) {
            throw new DomainException("thesis.enrolment.notDissertationEnrolment", new String[0]);
        }
        super.setEnrolment(enrolment);
    }

    public void removeEnrolment() {
        super.setEnrolment(null);
    }

    public String getDepartmentName() {
        CompetenceCourse competenceCourse = this.getEnrolment().getCurricularCourse().getCompetenceCourse();
        if (this.getEnrolment().isBolonhaDegree()) {
            return competenceCourse.getDepartmentUnit().getDepartment().getRealName();
        }
        if (!competenceCourse.getDepartmentsSet().isEmpty()) {
            return ((Department)((Object)competenceCourse.getDepartmentsSet().iterator().next())).getRealName();
        }
        return null;
    }

    public Student getStudent() {
        return this.getEnrolment().getStudentCurricularPlan().getRegistration().getStudent();
    }

    private void create() {
        this.setCreation(new DateTime());
        this.setCreator(AccessControl.getPerson());
        this.setState(ThesisState.DRAFT);
    }

    public void submit() {
        if (this.getState() != ThesisState.DRAFT) {
            throw new DomainException("thesis.submit.notDraft", new String[0]);
        }
        if (!this.isValid()) {
            throw new DomainException("thesis.submit.hasConditions", new String[0]);
        }
        Person person = AccessControl.getPerson();
        if (person.getTeacher() == null) {
            throw new DomainException("thesis.submit.needsTeacher", new String[0]);
        }
        this.setSubmission(new DateTime());
        this.setSubmitter(person);
        this.setRejectionComment(null);
        this.setState(ThesisState.SUBMITTED);
    }

    public void cancelSubmit() {
        switch (this.getState()) {
            case SUBMITTED: {
                break;
            }
            case APPROVED: {
                throw new DomainException("thesis.submit.cancel.alreadyApproved", new String[0]);
            }
            case DRAFT: {
                if (this.isRejected()) {
                    throw new DomainException("thesis.submit.cancel.alreadyRejected", new String[0]);
                }
            }
            default: {
                throw new DomainException("thesis.submit.cancel.unable", new String[0]);
            }
        }
        this.setSubmission(null);
        this.setSubmitter(null);
        this.setState(ThesisState.DRAFT);
    }

    public boolean isValid() {
        return this.getConditions().isEmpty();
    }

    public void approveProposal() {
        Object object = advice$approveProposal.perform((Callable)new Thesis$callable$approveProposal(this));
    }

    static /* synthetic */ void advised$approveProposal(Thesis this_) {
        AccessControl.check(this_, ThesisPredicates.isScientificCouncilOrCoordinatorAndNotOrientatorOrCoorientator);
        if (this_.getState() != ThesisState.APPROVED) {
            if (this_.getState() != ThesisState.SUBMITTED) {
                throw new DomainException("thesis.approve.notSubmitted", new String[0]);
            }
            this_.setApproval(new DateTime());
            this_.setProposalApprover(AccessControl.getPerson());
            this_.setState(ThesisState.APPROVED);
            Signal.emit((String)PROPOSAL_APPROVED_SIGNAL, (Object)new DomainObjectEvent((DomainObject)this_));
        }
    }

    public void rejectProposal(String rejectionComment) {
        AccessControl.check(this, ThesisPredicates.isScientificCouncilOrCoordinatorAndNotOrientatorOrCoorientator);
        if (this.getState() != ThesisState.SUBMITTED && this.getState() != ThesisState.APPROVED) {
            throw new DomainException("thesis.reject.notSubmittedNorApproved", new String[0]);
        }
        this.setSubmitter(null);
        this.setProposalApprover(null);
        this.setRejectionComment(rejectionComment);
        this.setState(ThesisState.DRAFT);
        this.sendRejectionEmail(rejectionComment);
    }

    private void sendRejectionEmail(String rejectionComment) {
        HashSet<Person> persons = new HashSet<Person>();
        ExecutionYear executionYear = this.getEnrolment().getExecutionYear();
        for (ScientificCommission member : this.getDegree().getScientificCommissionMembers(executionYear)) {
            if (!member.isContact().booleanValue()) continue;
            persons.add(member.getPerson());
        }
        Set<Person> orientationPersons = this.getOrientationPersons();
        persons.addAll(orientationPersons);
        Recipient recipient = new Recipient("Membros da tese " + this.getTitle().toString(), UserGroup.of(Person.convertToUsers(persons)));
        String studentNumber = this.getStudent().getNumber().toString();
        String title = this.getFinalFullTitle().getContent();
        String subject = this.getMessage("message.thesis.reject.submission.email.subject", studentNumber);
        String body = this.getMessage("message.thesis.reject.submission.email.body", studentNumber, title, rejectionComment);
        Sender sender = (Sender)((Object)ScientificCouncilUnit.getScientificCouncilUnit().getUnitBasedSenderSet().iterator().next());
        new Message(sender, sender.getConcreteReplyTos(), recipient.asCollection(), subject, body, "");
    }

    protected String getMessage(String key, Object ... args) {
        String message = BundleUtil.getString((String)"resources.ScientificCouncilResources", (String)key, (String[])new String[0]);
        return MessageFormat.format(message, args);
    }

    public void setConfirmmedDocuments(DateTime confirmmedDocuments) {
        if (this.getState() != ThesisState.APPROVED && this.getState() != ThesisState.REVISION) {
            throw new DomainException("thesis.confirm.notApprovedOrInRevision", new String[0]);
        }
        if (!this.isThesisAbstractInBothLanguages()) {
            throw new DomainException("thesis.confirm.noAbstract", new String[0]);
        }
        if (!this.isKeywordsInBothLanguages()) {
            throw new DomainException("thesis.confirm.noKeywords", new String[0]);
        }
        if (this.getExtendedAbstract() == null) {
            throw new DomainException("thesis.confirm.noExtendedAbstract", new String[0]);
        }
        if (this.getDissertation() == null) {
            throw new DomainException("thesis.confirm.noDissertation", new String[0]);
        }
        if (this.getDiscussed() == null) {
            throw new DomainException("thesis.confirm.noDiscussionDate", new String[0]);
        }
        this.setConfirmer(AccessControl.getPerson());
        super.setConfirmmedDocuments(confirmmedDocuments);
    }

    public void confirm(Integer mark) {
        if (this.getState() != ThesisState.APPROVED && this.getState() != ThesisState.REVISION) {
            throw new DomainException("thesis.confirm.notApprovedOrInRevision", new String[0]);
        }
        if (!this.isThesisAbstractInBothLanguages()) {
            throw new DomainException("thesis.confirm.noAbstract", new String[0]);
        }
        if (!this.isKeywordsInBothLanguages()) {
            throw new DomainException("thesis.confirm.noKeywords", new String[0]);
        }
        if (this.getExtendedAbstract() == null) {
            throw new DomainException("thesis.confirm.noExtendedAbstract", new String[0]);
        }
        if (this.getDissertation() == null) {
            throw new DomainException("thesis.confirm.noDissertation", new String[0]);
        }
        if (this.getDiscussed() == null) {
            throw new DomainException("thesis.confirm.noDiscussionDate", new String[0]);
        }
        this.setMark(mark);
        this.setConfirmation(new DateTime());
        this.setConfirmer(AccessControl.getPerson());
        this.setState(ThesisState.CONFIRMED);
    }

    public void allowRevision() {
        if (this.getState() != ThesisState.REVISION) {
            if (this.getState() != ThesisState.CONFIRMED) {
                throw new DomainException("thesis.confirm.notConfirmed", new String[0]);
            }
            this.setConfirmation(null);
            this.setConfirmer(null);
            this.setState(ThesisState.REVISION);
        }
    }

    public void approveEvaluation() {
        if (this.getState() != ThesisState.EVALUATED) {
            if (this.getState() != ThesisState.CONFIRMED) {
                throw new DomainException("thesis.confirm.notConfirmed", new String[0]);
            }
        } else {
            throw new DomainException("thesis.already.evaluated", new String[0]);
        }
        this.setEvaluation(new DateTime());
        this.setEvaluationApprover(AccessControl.getPerson());
        this.setState(ThesisState.EVALUATED);
        this.updateMarkSheet();
        this.setDocumentsAvailableAfter(new DateTime().plusMonths(9));
    }

    public ThesisLibraryState getLibraryState() {
        if (this.getLastLibraryOperation() != null) {
            return this.getLastLibraryOperation().getState();
        }
        return ThesisLibraryState.NOT_DEALT;
    }

    public void setLibraryState(ThesisLibraryState state) {
        throw new UnsupportedOperationException();
    }

    public String getLibraryReference() {
        if (this.getLastLibraryOperation() != null) {
            return this.getLastLibraryOperation().getLibraryReference();
        }
        return null;
    }

    public void setLibraryReference(String reference) {
        throw new UnsupportedOperationException();
    }

    public Person getLibraryOperationPerformer() {
        if (this.getLastLibraryOperation() != null) {
            return this.getLastLibraryOperation().getPerformer();
        }
        return null;
    }

    public void setLibraryOperationPerformer(Person performer) {
        throw new UnsupportedOperationException();
    }

    public boolean hasFinalEnrolmentEvaluation() {
        return this.getEnrolment().isApproved();
    }

    public void updateMarkSheet() {
        if (this.hasAnyEvaluations()) {
            return;
        }
        if (!this.isFinalThesis()) {
            return;
        }
        MarkSheet markSheet = this.getExistingMarkSheet();
        if (markSheet == null) {
            markSheet = this.createMarkSheet();
        } else {
            this.mergeInMarkSheet(markSheet);
        }
    }

    public boolean isFinalThesis() {
        Enrolment enrolment = this.getEnrolment();
        return enrolment.getThesesSet().size() != 1 || !this.getEvaluationMark().getValue().equals("RE");
    }

    public boolean isFinalAndApprovedThesis() {
        return !this.getEvaluationMark().getValue().equals("RE");
    }

    public boolean hasAnyEvaluations() {
        for (EnrolmentEvaluation evaluation : this.getEnrolment().getEvaluationsSet()) {
            String evaluationMarkValue;
            if (!evaluation.getEvaluationSeason().isNormal() || evaluation.getMarkSheet() == null) continue;
            String gradeValue = evaluation.getGradeValue();
            Grade evaluationMark = this.getEvaluationMark();
            String string = evaluationMarkValue = evaluationMark == null ? null : evaluationMark.getValue();
            if (gradeValue.equals(evaluationMarkValue)) {
                return true;
            }
            throw new DomainException("thesis.approve.evaluation.has.different.mark", gradeValue);
        }
        return false;
    }

    protected MarkSheet getExistingMarkSheet() {
        CurricularCourse curricularCourse = this.getEnrolment().getCurricularCourse();
        Teacher teacher = this.getResponsibleTeacher();
        for (MarkSheet markSheet : curricularCourse.getMarkSheetsSet()) {
            if (this.getEnrolment().getExecutionPeriod() != markSheet.getExecutionPeriod() || markSheet.isConfirmed() || !markSheet.getEvaluationSeason().isSpecialAuthorization() || markSheet.getResponsibleTeacher() != teacher) continue;
            return markSheet;
        }
        return null;
    }

    private Teacher getResponsibleTeacher() {
        Teacher responsible = this.getExecutionCourseTeacher();
        if (responsible == null) {
            responsible = AccessControl.getPerson().getTeacher();
        }
        return responsible;
    }

    private void mergeInMarkSheet(MarkSheet markSheet) {
        List<MarkSheetEnrolmentEvaluationBean> empty = Collections.emptyList();
        markSheet.editNormal(empty, this.getStudentEvalutionBean(), empty);
    }

    protected MarkSheet createMarkSheet() {
        CurricularCourse curricularCourse = this.getEnrolment().getCurricularCourse();
        ExecutionSemester executionSemester = this.getEnrolment().getExecutionPeriod();
        Teacher responsible = this.getExecutionCourseTeacher();
        Date evaluationDate = this.getDiscussed().toDate();
        if (responsible == null) {
            responsible = AccessControl.getPerson().getTeacher();
        }
        List<MarkSheetEnrolmentEvaluationBean> evaluations = this.getStudentEvalutionBean();
        return curricularCourse.createNormalMarkSheet(executionSemester, responsible, evaluationDate, EvaluationSeason.readSpecialAuthorization(), true, evaluations, responsible.getPerson());
    }

    private List<MarkSheetEnrolmentEvaluationBean> getStudentEvalutionBean() {
        return Arrays.asList(new MarkSheetEnrolmentEvaluationBean(this.getEnrolment(), this.getDiscussed().toDate(), this.getEvaluationMark()));
    }

    private Teacher getExecutionCourseTeacher() {
        ArrayList teachers = new ArrayList();
        ExecutionCourse executionCourse = this.getExecutionCourse();
        if (executionCourse != null) {
            for (Professorship professorship : executionCourse.getProfessorshipsSet()) {
                if (!professorship.isResponsibleFor() || !professorship.hasTeacher()) continue;
                return professorship.getTeacher();
            }
        }
        CurricularCourse curricularCourse = this.getEnrolment().getCurricularCourse();
        Degree degree = curricularCourse.getDegree();
        for (ExecutionDegree executionDegree : curricularCourse.getDegreeCurricularPlan().getExecutionDegreesSet()) {
            if (executionDegree.getExecutionYear() != this.getEnrolment().getExecutionYear()) continue;
            for (Coordinator coordinator : executionDegree.getCoordinatorsListSet()) {
                if (!coordinator.isResponsible()) continue;
                return coordinator.getPerson().getTeacher();
            }
        }
        return null;
    }

    private ExecutionCourse getExecutionCourse() {
        Enrolment enrolment = this.getEnrolment();
        CurricularCourse curricularCourse = enrolment.getCurricularCourse();
        List<ExecutionCourse> executionCourses = curricularCourse.getExecutionCoursesByExecutionPeriod(enrolment.getExecutionPeriod());
        if (!executionCourses.isEmpty()) {
            return executionCourses.iterator().next();
        }
        executionCourses = curricularCourse.getExecutionCoursesByExecutionYear(enrolment.getExecutionYear());
        if (!executionCourses.isEmpty()) {
            return executionCourses.iterator().next();
        }
        return null;
    }

    private Grade getEvaluationMark() {
        Integer mark = this.getMark();
        GradeScale scale = this.getEnrolment().getCurricularCourse().getGradeScaleChain();
        if (scale != GradeScale.TYPE20) {
            throw new DomainException("thesis.grade.type20.expected", new String[0]);
        }
        return Grade.createGrade(mark == null || mark < 10 ? "RE" : mark.toString(), scale);
    }

    public void acceptDeclaration(ThesisVisibilityType visibility, DateTime availableAfter) {
        if (visibility == null) {
            throw new DomainException("thesis.acceptDeclaration.visibility.required", new String[0]);
        }
        if (!this.isWaitingConfirmation()) {
            throw new DomainException("thesis.acceptDeclaration.notAllowed", new String[0]);
        }
        this.setDeclarationAccepted(true);
        this.setVisibility(visibility);
        this.setDocumentsAvailableAfter(availableAfter);
        this.setDeclarationAcceptedTime(new DateTime());
    }

    public void rejectDeclaration() {
        this.setDeclarationAccepted(false);
        this.setVisibility(null);
        this.setDocumentsAvailableAfter(null);
        this.setDeclarationAcceptedTime(null);
        if (!this.isWaitingConfirmation()) {
            throw new DomainException("thesis.rejectDeclaration.notAllowed", new String[0]);
        }
        if (this.getDissertation() != null) {
            this.getDissertation().delete();
        }
        if (this.getExtendedAbstract() != null) {
            this.getExtendedAbstract().delete();
        }
    }

    public void swapFilesVisibility() {
        Object object = advice$swapFilesVisibility.perform((Callable)new Thesis$callable$swapFilesVisibility(this));
    }

    static /* synthetic */ void advised$swapFilesVisibility(Thesis this_) {
        ThesisVisibilityType visibility = this_.getVisibility();
        if (visibility == null) {
            throw new DomainException("thesis.acceptDeclaration.visibility.required", new String[0]);
        }
        if (visibility.equals((Object)ThesisVisibilityType.INTRANET)) {
            this_.setVisibility(ThesisVisibilityType.PUBLIC);
        } else {
            this_.setVisibility(ThesisVisibilityType.INTRANET);
        }
    }

    public boolean isDraft() {
        return this.getState() == ThesisState.DRAFT;
    }

    public boolean isSubmitted() {
        return this.getState() == ThesisState.SUBMITTED;
    }

    public boolean isApproved() {
        ThesisState state = this.getState();
        return state == ThesisState.APPROVED;
    }

    public boolean isWaitingConfirmation() {
        ThesisState state = this.getState();
        return state == ThesisState.APPROVED || state == ThesisState.REVISION;
    }

    public boolean isSubmittedAndIsCoordinatorAndNotOrientator() {
        return this.isSubmitted() && this.isCoordinatorAndNotOrientator();
    }

    public boolean isCoordinatorAndNotOrientator() {
        Person loggedPerson = AccessControl.getPerson();
        return loggedPerson != null && this.isCoordinator(loggedPerson) && !this.isOrientatorOrCoorientator(loggedPerson);
    }

    public boolean isCoordinator() {
        Person loggedPerson = AccessControl.getPerson();
        return loggedPerson != null && this.isCoordinator(loggedPerson);
    }

    private boolean isCoordinator(Person loggedPerson) {
        for (Coordinator coordinator : loggedPerson.getCoordinatorsSet()) {
            if (!coordinator.isResponsible() || this.getDegree() != coordinator.getExecutionDegree().getDegree()) continue;
            return true;
        }
        return false;
    }

    private boolean isOrientatorOrCoorientator(Person person) {
        for (ThesisEvaluationParticipant thesisEvaluationParticipant : this.getParticipationsSet()) {
            ThesisParticipationType type = thesisEvaluationParticipant.getType();
            if (type != ThesisParticipationType.ORIENTATOR && type != ThesisParticipationType.COORIENTATOR || person != thesisEvaluationParticipant.getPerson()) continue;
            return true;
        }
        return false;
    }

    public boolean isConfirmed() {
        return this.getState() == ThesisState.CONFIRMED;
    }

    public boolean isEvaluated() {
        return this.getState() == ThesisState.EVALUATED;
    }

    public boolean isInRevision() {
        return this.getState() == ThesisState.REVISION;
    }

    public boolean isRejected() {
        return this.isDraft() && this.getSubmission() != null;
    }

    public void removeMark() {
        super.setMark(null);
    }

    public void setMark(Integer mark) {
        if (!this.isMarkValid(mark)) {
            throw new DomainException("thesis.mark.invalid", new String[0]);
        }
        super.setMark(mark);
    }

    public boolean isMarkValid(Integer mark) {
        GradeScale scale = this.getEnrolment().getCurricularCourse().getGradeScaleChain();
        if (scale == null) {
            scale = GradeScale.TYPE20;
        }
        return scale.isValid(mark.toString(), EvaluationType.EXAM_TYPE);
    }

    private Person getParticipationPerson(ThesisEvaluationParticipant participant) {
        if (participant == null) {
            return null;
        }
        return participant.getPerson();
    }

    private void removeParticipation(ThesisEvaluationParticipant participant) {
        if (participant != null) {
            participant.delete();
        }
    }

    public List<ThesisCondition> getStudentConditions() {
        ArrayList<ThesisCondition> conditions = new ArrayList<ThesisCondition>();
        if (this.getDiscussed() == null) {
            conditions.add(new ThesisCondition("thesis.student.discussionDate.missing"));
        }
        if (!this.isThesisAbstractInBothLanguages()) {
            conditions.add(new ThesisCondition("thesis.student.abstract.missing"));
        }
        if (!this.isKeywordsInBothLanguages()) {
            conditions.add(new ThesisCondition("thesis.student.keywords.missing"));
        }
        if (this.isDeclarationAccepted()) {
            if (this.getDissertation() == null) {
                conditions.add(new ThesisCondition("thesis.student.dissertation.missing"));
            }
            if (this.getExtendedAbstract() == null) {
                conditions.add(new ThesisCondition("thesis.student.extendedAbstract.missing"));
            }
        } else {
            conditions.add(new ThesisCondition("thesis.student.declaration.notAccepted"));
        }
        return conditions;
    }

    public List<ThesisCondition> getConditions() {
        ArrayList<ThesisCondition> conditions = new ArrayList<ThesisCondition>();
        conditions.addAll(this.getGeneralConditions());
        conditions.addAll(this.getOrientationConditions());
        conditions.addAll(this.getJuryConditions());
        return conditions;
    }

    public Collection<ThesisCondition> getGeneralConditions() {
        ArrayList<ThesisCondition> conditions = new ArrayList<ThesisCondition>();
        int count = this.getJuryParticipantCount();
        if (count < 3) {
            conditions.add(new ThesisCondition("thesis.condition.people.number.few"));
        }
        if (count > 5) {
            conditions.add(new ThesisCondition("thesis.condition.people.number.exceeded"));
        }
        return conditions;
    }

    public List<ThesisCondition> getOrientationConditions() {
        ArrayList<ThesisCondition> conditions = new ArrayList<ThesisCondition>();
        List<ThesisEvaluationParticipant> orientation = this.getOrientation();
        if (orientation.isEmpty()) {
            conditions.add(new ThesisCondition("thesis.condition.orientator.required"));
        } else {
            if (orientation.stream().anyMatch(o -> o.getPercentageDistribution() < 20)) {
                conditions.add(new ThesisCondition("thesis.condition.orientation.credits.low"));
            }
            if (orientation.stream().mapToInt(o -> o.getPercentageDistribution()).sum() > 100) {
                conditions.add(new ThesisCondition("thesis.condition.orientation.credits.overflow"));
            }
            if (orientation.stream().map(ThesisEvaluationParticipant::getPerson).filter(Objects::nonNull).count() != orientation.stream().map(ThesisEvaluationParticipant::getPerson).filter(Objects::nonNull).distinct().count()) {
                conditions.add(new ThesisCondition("thesis.condition.people.repeated.orientation"));
            }
        }
        return conditions;
    }

    public List<ThesisCondition> getJuryConditions() {
        ArrayList<ThesisCondition> conditions = new ArrayList<ThesisCondition>();
        Person president = this.getParticipationPerson(this.getPresident());
        if (president == null) {
            conditions.add(new ThesisCondition("thesis.condition.president.required"));
        } else if (president.getTeacher() == null || !president.getTeacher().isActiveContractedTeacher()) {
            conditions.add(new ThesisCondition("thesis.condition.president.notInternal"));
        } else {
            ExecutionYear executionYear;
            boolean isMember = false;
            Enrolment enrolment = this.getEnrolment();
            DegreeCurricularPlan degreeCurricularPlan = enrolment.getDegreeCurricularPlanOfDegreeModule();
            ExecutionDegree executionDegree = degreeCurricularPlan.getExecutionDegreeByYear(executionYear = enrolment.getExecutionYear());
            if (executionDegree != null) {
                for (ScientificCommission member : executionDegree.getScientificCommissionMembersSet()) {
                    if (!(isMember = isMember || president == member.getPerson())) continue;
                    break;
                }
            }
            if (!isMember) {
                conditions.add(new ThesisCondition("thesis.condition.president.scientificCommission.notMember"));
            }
        }
        if (this.getVowels().size() < 2) {
            conditions.add(new ThesisCondition("thesis.condition.people.vowels.two.required"));
        } else {
            HashSet<Person> juryPersons = new HashSet<Person>();
            for (ThesisEvaluationParticipant vowel : this.getVowels()) {
                if (vowel.getPerson() == null) continue;
                juryPersons.add(vowel.getPerson());
            }
            if (this.getVowels().stream().filter(v -> !v.isExternal()).collect(Collectors.toSet()).size() != juryPersons.size()) {
                conditions.add(new ThesisCondition("thesis.condition.people.repeated.vowels"));
            }
            if (president != null && juryPersons.contains((Object)president)) {
                conditions.add(new ThesisCondition("thesis.condition.people.repeated.vowels.president"));
            }
            juryPersons.add(president);
        }
        return conditions;
    }

    private int getJuryParticipantCount() {
        return this.getVowels().size() + (this.getPresident() != null ? 1 : 0);
    }

    public boolean isThesisAbstractInBothLanguages() {
        return this.getThesisAbstractPt() != null && this.getThesisAbstractEn() != null;
    }

    public boolean isKeywordsInBothLanguages() {
        return this.getKeywordsPt() != null && this.getKeywordsEn() != null;
    }

    public String getThesisAbstractPt() {
        return this.getThesisAbstractLanguage("pt");
    }

    public void setThesisAbstractPt(String text) {
        AccessControl.check(this, ThesisPredicates.waitingConfirmation);
        this.setThesisAbstractLanguage("pt", text);
    }

    public String getThesisAbstractEn() {
        return this.getThesisAbstractLanguage("en");
    }

    public void setThesisAbstractEn(String text) {
        AccessControl.check(this, ThesisPredicates.waitingConfirmation);
        this.setThesisAbstractLanguage("en", text);
    }

    public String getThesisAbstractLanguage(String language) {
        MultiLanguageString thesisAbstract = this.getThesisAbstract();
        if (thesisAbstract == null) {
            return null;
        }
        Locale realLanguage = new Locale.Builder().setLanguageTag(language).build();
        String value = thesisAbstract.getContent(realLanguage);
        if (value == null || value.length() == 0) {
            return null;
        }
        return value;
    }

    public void setThesisAbstractLanguage(String language, String text) {
        MultiLanguageString thesisAbstract = this.getThesisAbstract();
        Locale realLanguage = new Locale.Builder().setLanguageTag(language).build();
        if (thesisAbstract == null) {
            this.setThesisAbstract(new MultiLanguageString(realLanguage, text));
        } else {
            thesisAbstract = thesisAbstract.with(realLanguage, text);
            this.setThesisAbstract(thesisAbstract);
        }
    }

    public String getKeywordsPt() {
        return this.getKeywordsLanguage("pt");
    }

    public void setKeywordsPt(String text) {
        AccessControl.check(this, ThesisPredicates.waitingConfirmation);
        this.setKeywordsLanguage("pt", this.normalizeKeywords(text));
    }

    public String getKeywordsEn() {
        return this.getKeywordsLanguage("en");
    }

    public void setKeywordsEn(String text) {
        AccessControl.check(this, ThesisPredicates.waitingConfirmation);
        this.setKeywordsLanguage("en", this.normalizeKeywords(text));
    }

    private String normalizeKeywords(String keywords) {
        StringBuilder builder = new StringBuilder();
        if (keywords == null) {
            return null;
        }
        for (String part : keywords.split(",")) {
            String trimmed = part.trim();
            if (trimmed.length() == 0) continue;
            if (builder.length() != 0) {
                builder.append(", ");
            }
            builder.append(trimmed);
        }
        return builder.toString();
    }

    public String getKeywordsLanguage(String language) {
        MultiLanguageString thesisAbstract = this.getKeywords();
        if (thesisAbstract == null) {
            return null;
        }
        Locale realLanguage = new Locale.Builder().setLanguageTag(language).build();
        String value = thesisAbstract.getContent(realLanguage);
        if (value == null || value.length() == 0) {
            return null;
        }
        return value;
    }

    public void setKeywordsLanguage(String language, String text) {
        if (text != null) {
            String[] parts = text.split(",");
            if (parts.length > 6) {
                throw new DomainException("label.message.thesis.keyword.number.of.words.exceeded", new String[0]);
            }
            for (String part : parts) {
                if (part.length() <= 42) continue;
                throw new DomainException("label.message.thesis.keyword.length.limit.exceeded", new String[0]);
            }
        }
        MultiLanguageString keywords = this.getKeywords();
        Locale realLanguage = new Locale.Builder().setLanguageTag(language).build();
        if (keywords == null) {
            this.setKeywords(new MultiLanguageString(realLanguage, text));
        } else {
            keywords = keywords.with(realLanguage, text);
            this.setKeywords(keywords);
        }
    }

    public void setPresident(Person person) {
        this.setParticipation(person, ThesisParticipationType.PRESIDENT);
    }

    public void setCreator(Person person) {
        this.setParticipation(person, ThesisParticipationType.STATE_CREATOR);
    }

    public void setSubmitter(Person person) {
        this.setParticipation(person, ThesisParticipationType.STATE_SUBMITTER);
    }

    public void setProposalApprover(Person person) {
        this.setParticipation(person, ThesisParticipationType.STATE_PROPOSAL_APPROVER);
    }

    public void setConfirmer(Person person) {
        this.setParticipation(person, ThesisParticipationType.STATE_CONFIRMER);
    }

    public void setEvaluationApprover(Person person) {
        this.setParticipation(person, ThesisParticipationType.STATE_EVALUATION_APPROVER);
    }

    public void setParticipation(Person person, ThesisParticipationType type) {
        if (person == null) {
            this.removeParticipation(this.getParticipant(type));
        } else {
            new ThesisEvaluationParticipant(this, person, type);
        }
    }

    public void addParticipant(Person person, ThesisParticipationType type) {
        new ThesisEvaluationParticipant(this, person, type);
    }

    public DateTime getCurrentDiscussedDate() {
        if (this.isConfirmed() || this.isEvaluated() || this.isInRevision()) {
            return this.getDiscussed();
        }
        return this.getProposedDiscussed();
    }

    public void setState(ThesisState state) {
        if (this.hasFutureEnrolment()) {
            throw new DomainException("thesis.has.enrolment.in.future", new String[0]);
        }
        if (state == ThesisState.REVISION) {
            super.setConfirmmedDocuments(null);
        }
        super.setState(state);
    }

    protected boolean hasFutureEnrolment() {
        Enrolment enrolment = this.getEnrolment();
        if (enrolment != null) {
            ExecutionSemester executionSemester = enrolment.getExecutionPeriod();
            CurricularCourse curricularCourse = enrolment.getCurricularCourse();
            StudentCurricularPlan studentCurricularPlan = enrolment.getStudentCurricularPlan();
            for (Enrolment otherEnrolment : studentCurricularPlan.getEnrolments(curricularCourse)) {
                if (!otherEnrolment.getExecutionPeriod().isAfter(executionSemester)) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<Thesis> getThesesByParticipationType(Person person, ThesisParticipationType thesisParticipationType) {
        HashSet<Thesis> theses = new HashSet<Thesis>();
        for (ThesisEvaluationParticipant thesisEvaluationParticipant : person.getThesisEvaluationParticipantsSet()) {
            if (thesisParticipationType != thesisEvaluationParticipant.getType()) continue;
            Thesis thesis = thesisEvaluationParticipant.getThesis();
            theses.add(thesis);
        }
        return theses;
    }

    public boolean hasCurrentDiscussedDate() {
        return this.getCurrentDiscussedDate() != null;
    }

    public void checkIsScientificCommission() {
        AccessControl.check(this, ThesisPredicates.isScientificCommission);
    }

    public ExecutionYear getExecutionYear() {
        return this.getEnrolment().getExecutionYear();
    }

    public boolean isAnual() {
        Enrolment enrolment = this.getEnrolment();
        return enrolment.isAnual();
    }

    public List<Locale> getLanguages() {
        ThesisFile extendedAbstract;
        ArrayList<Locale> result = new ArrayList<Locale>();
        this.add(result, this.getKeywords());
        this.add(result, this.getThesisAbstract());
        this.add(result, this.getTitle());
        ThesisFile dissertation = this.getDissertation();
        if (dissertation != null) {
            this.add(result, dissertation.getLanguage());
        }
        if ((extendedAbstract = this.getExtendedAbstract()) != null) {
            this.add(result, extendedAbstract.getLanguage());
        }
        return result;
    }

    private void add(List<Locale> result, MultiLanguageString mls) {
        if (mls != null) {
            for (Locale language : mls.getAllLocales()) {
                this.add(result, language);
            }
        }
    }

    private void add(List<Locale> result, Locale language) {
        if (language != null && !result.contains(language)) {
            if (language == MultiLanguageString.pt) {
                result.add(0, language);
            } else if (language == MultiLanguageString.en) {
                if (result.size() > 0 && result.iterator().next() == MultiLanguageString.pt) {
                    result.add(1, language);
                } else if (result.size() > 0) {
                    result.add(0, language);
                } else {
                    result.add(language);
                }
            } else {
                result.add(language);
            }
        }
    }

    public boolean areThesisFilesReadable() {
        return this.getDissertation() != null && this.getVisibility() != null;
    }

    public Set<Person> getOrientationPersons() {
        return this.getOrientation().stream().filter(p -> p.getPerson() != null).map(p -> p.getPerson()).collect(Collectors.toSet());
    }

    private List<Person> getOrientationPersonsList() {
        return this.getOrientation().stream().filter(p -> p.getPerson() != null).map(p -> p.getPerson()).collect(Collectors.toList());
    }

    public void addExternal(ThesisParticipationType type, String name, String email) {
        new ThesisEvaluationParticipant(this, name, email, type);
    }

    static {
        advice$approveProposal = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$swapFilesVisibility = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        Thesis.getRelationThesisEnrolment().addListener((RelationListener)new RelationAdapter<Thesis, Enrolment>(){

            public void beforeAdd(Thesis thesis, Enrolment enrolment) {
                super.beforeAdd((DomainObject)thesis, (DomainObject)enrolment);
                if (thesis == null || enrolment == null) {
                    return;
                }
                Set theses = enrolment.getThesesSet();
                String number = enrolment.getStudentCurricularPlan().getRegistration().getNumber().toString();
                switch (theses.size()) {
                    case 0: {
                        return;
                    }
                    case 1: {
                        Thesis existing = (Thesis)((Object)theses.iterator().next());
                        if (!existing.isFinalThesis() && existing.isEvaluated()) break;
                        throw new DomainException("thesis.enrolment.thesis.notEvaluated", number);
                    }
                }
                throw new DomainException("thesis.enrolment.hasFinalThesis", number);
            }
        });
        COMPARATOR_BY_STUDENT = (t1, t2) -> {
            int n = Student.NUMBER_COMPARATOR.compare(t1.getStudent(), t2.getStudent());
            return n == 0 ? DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)t1, (DomainObject)t2) : n;
        };
    }

    public static class ThesisCondition {
        private final String key;

        public ThesisCondition(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

