/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.studentCurriculum;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.EnrolmentResultType;
import org.fenixedu.academic.domain.curriculum.EnrollmentCondition;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.StudentCurricularPlanEnrolment;

public class StudentCurricularPlanPropaeudeuticsEnrolmentManager
extends StudentCurricularPlanEnrolment {
    public StudentCurricularPlanPropaeudeuticsEnrolmentManager(EnrolmentContext enrolmentContext) {
        super(enrolmentContext);
    }

    @Override
    protected void assertEnrolmentPreConditions() {
        if (this.isResponsiblePersonManager()) {
            return;
        }
        if (!this.isResponsiblePersonAllowedToEnrolStudents()) {
            throw new DomainException("error.StudentCurricularPlan.cannot.enrol.in.propaeudeutics", new String[0]);
        }
        if (this.getRegistration().isRegistrationConclusionProcessed()) {
            this.checkUpdateRegistrationAfterConclusion();
        }
        this.checkEnrolingDegreeModules();
    }

    private void checkEnrolingDegreeModules() {
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : this.enrolmentContext.getDegreeModulesToEvaluate()) {
            if (!degreeModuleToEvaluate.isEnroling()) continue;
            if (!degreeModuleToEvaluate.getDegreeModule().isCurricularCourse()) {
                throw new DomainException("error.StudentCurricularPlanPropaeudeuticsEnrolmentManager.can.only.enrol.in.curricularCourses", new String[0]);
            }
            this.checkIDegreeModuleToEvaluate((CurricularCourse)((Object)degreeModuleToEvaluate.getDegreeModule()));
        }
    }

    private void checkIDegreeModuleToEvaluate(CurricularCourse curricularCourse) {
        if (this.getStudentCurricularPlan().isApproved(curricularCourse, this.getExecutionSemester())) {
            throw new DomainException("error.already.aproved", curricularCourse.getName());
        }
        if (this.getStudentCurricularPlan().isEnroledInExecutionPeriod(curricularCourse, this.getExecutionSemester())) {
            throw new DomainException("error.already.enroled.in.executionPeriod", curricularCourse.getName(), this.getExecutionSemester().getQualifiedName());
        }
    }

    @Override
    protected void addEnroled() {
    }

    @Override
    protected Map<IDegreeModuleToEvaluate, Set<ICurricularRule>> getRulesToEvaluate() {
        HashMap<IDegreeModuleToEvaluate, Set<ICurricularRule>> result = new HashMap<IDegreeModuleToEvaluate, Set<ICurricularRule>>();
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : this.enrolmentContext.getDegreeModulesToEvaluate()) {
            if (!degreeModuleToEvaluate.isEnroling() || !degreeModuleToEvaluate.getDegreeModule().isCurricularCourse()) continue;
            result.put(degreeModuleToEvaluate, Collections.emptySet());
        }
        return result;
    }

    @Override
    protected void performEnrolments(Map<EnrolmentResultType, List<IDegreeModuleToEvaluate>> degreeModulesToEnrolMap) {
        for (Map.Entry<EnrolmentResultType, List<IDegreeModuleToEvaluate>> entry : degreeModulesToEnrolMap.entrySet()) {
            for (IDegreeModuleToEvaluate degreeModuleToEvaluate : entry.getValue()) {
                if (!degreeModuleToEvaluate.isEnroling() || !degreeModuleToEvaluate.getDegreeModule().isCurricularCourse()) continue;
                CurricularCourse curricularCourse = (CurricularCourse)((Object)degreeModuleToEvaluate.getDegreeModule());
                this.checkIDegreeModuleToEvaluate(curricularCourse);
                new Enrolment(this.getStudentCurricularPlan(), degreeModuleToEvaluate.getCurriculumGroup(), curricularCourse, this.getExecutionSemester(), EnrollmentCondition.VALIDATED, this.getResponsiblePerson().getUsername());
            }
        }
    }

    @Override
    protected void unEnrol() {
        for (CurriculumModule curriculumModule : this.enrolmentContext.getToRemove()) {
            if (!curriculumModule.isLeaf()) continue;
            curriculumModule.delete();
        }
    }
}

