/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests.documentRequests;

import java.util.Set;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.SchoolRegistrationDeclarationRequest_Base;
import org.fenixedu.academic.dto.serviceRequests.DocumentRequestCreateBean;

public class SchoolRegistrationDeclarationRequest
extends SchoolRegistrationDeclarationRequest_Base {
    private static final int MAX_FREE_DECLARATIONS_PER_EXECUTION_YEAR = 4;

    protected SchoolRegistrationDeclarationRequest() {
    }

    public SchoolRegistrationDeclarationRequest(DocumentRequestCreateBean bean) {
        this();
        this.checkRulesToCreate(bean);
        bean.setExecutionYear(this.getRequestedExecutionYear(bean));
        super.init(bean);
    }

    private ExecutionYear getRequestedExecutionYear(DocumentRequestCreateBean bean) {
        return bean.getRegistration().hasIndividualCandidacyFor(bean.getExecutionYear().getNextExecutionYear()) != false ? bean.getExecutionYear().getNextExecutionYear() : bean.getExecutionYear();
    }

    protected void checkRulesToCreate(DocumentRequestCreateBean bean) {
        ExecutionYear executionYear = bean.getExecutionYear();
        if (!bean.getRegistration().isRegistered(executionYear) && !bean.getRegistration().hasIndividualCandidacyFor(executionYear.getNextExecutionYear()).booleanValue()) {
            throw new DomainException("SchoolRegistrationDeclarationRequest.registration.not.in.registered.state.in.current.executionYear", new String[0]);
        }
    }

    public final DocumentRequestType getDocumentRequestType() {
        return DocumentRequestType.SCHOOL_REGISTRATION_DECLARATION;
    }

    public final String getDocumentTemplateKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final EventType getEventType() {
        return EventType.SCHOOL_REGISTRATION_DECLARATION_REQUEST;
    }

    public boolean hasPersonalInfo() {
        return true;
    }

    protected boolean hasFreeDeclarationRequests() {
        ExecutionYear currentExecutionYear = ExecutionYear.readCurrentExecutionYear();
        Set<DocumentRequest> schoolRegistrationDeclarations = this.getRegistration().getSucessfullyFinishedDocumentRequestsBy(currentExecutionYear, DocumentRequestType.SCHOOL_REGISTRATION_DECLARATION, false);
        Set<DocumentRequest> enrolmentDeclarations = this.getRegistration().getSucessfullyFinishedDocumentRequestsBy(currentExecutionYear, DocumentRequestType.ENROLMENT_DECLARATION, false);
        return schoolRegistrationDeclarations.size() + enrolmentDeclarations.size() < 4;
    }
}

