/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests.documentRequests;

import java.util.Collection;
import java.util.HashSet;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.IEnrolment;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.ApprovementMobilityCertificateRequest_Base;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentPurposeType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.academic.domain.student.curriculum.Curriculum;
import org.fenixedu.academic.domain.student.curriculum.ICurriculum;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academic.domain.studentCurriculum.ExternalCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.StandaloneCurriculumGroup;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestBean;
import org.fenixedu.academic.dto.serviceRequests.DocumentRequestCreateBean;
import org.joda.time.DateTime;

public class ApprovementMobilityCertificateRequest
extends ApprovementMobilityCertificateRequest_Base {
    protected ApprovementMobilityCertificateRequest() {
    }

    public ApprovementMobilityCertificateRequest(DocumentRequestCreateBean bean) {
        this();
        super.init(bean);
        this.checkParameters(bean);
        if (!this.isDEARegistration()) {
            if (this.getRegistration().isConcluded()) {
                throw new DomainException("ApprovementCertificateRequest.registration.is.concluded", new String[0]);
            }
            if (this.getRegistration().isRegistrationConclusionProcessed()) {
                throw new DomainException("ApprovementCertificateRequest.registration.has.conclusion.processed", new String[0]);
            }
        }
        if (this.getEntriesToReport(this.isDEARegistration()).isEmpty()) {
            throw new DomainException("ApprovementCertificateRequest.registration.without.approvements", new String[0]);
        }
    }

    private boolean isDEARegistration() {
        return this.getRegistration().getDegreeType().isAdvancedSpecializationDiploma();
    }

    public boolean isFreeProcessed() {
        return this.getDocumentRequestType() == DocumentRequestType.APPROVEMENT_MOBILITY_CERTIFICATE && (this.getRegistration().getRegistrationProtocol().isMobilityAgreement() || this.getRegistration().getRegistrationProtocol().isExempted());
    }

    protected final void checkParameters(DocumentRequestCreateBean bean) {
        if (bean.getMobilityProgram() != null && bean.isIgnoreExternalEntries()) {
            throw new DomainException("ApprovementCertificateRequest.cannot.ignore.external.entries.within.a.mobility.program", new String[0]);
        }
    }

    protected void internalChangeState(AcademicServiceRequestBean academicServiceRequestBean) {
        super.internalChangeState(academicServiceRequestBean);
        if (academicServiceRequestBean.isToProcess()) {
            int curricularYear;
            if (!this.isDEARegistration()) {
                if (this.getRegistration().isConcluded()) {
                    throw new DomainException("ApprovementCertificateRequest.registration.is.concluded", new String[0]);
                }
                if (this.getRegistration().isRegistrationConclusionProcessed()) {
                    throw new DomainException("ApprovementCertificateRequest.registration.has.conclusion.processed", new String[0]);
                }
            }
            if (this.getEntriesToReport(this.isDEARegistration()).isEmpty()) {
                throw new DomainException("ApprovementCertificateRequest.registration.without.approvements", new String[0]);
            }
            if (this.getRegistration().getLastStudentCurricularPlan().getDegreeCurricularPlan().getDurationInYears() == 5 && this.getDocumentPurposeType() == DocumentPurposeType.PROFESSIONAL && (curricularYear = this.getRegistration().getCurricularYear()) <= 3) {
                throw new DomainException("ApprovementCertificateRequest.registration.hasnt.finished.third.year", new String[0]);
            }
        }
        if (academicServiceRequestBean.isToConclude()) {
            super.setNumberOfUnits(Integer.valueOf(this.calculateNumberOfUnits()));
        }
    }

    protected boolean isPayed() {
        return super.isPayed();
    }

    public final DocumentRequestType getDocumentRequestType() {
        return DocumentRequestType.APPROVEMENT_MOBILITY_CERTIFICATE;
    }

    public final String getDocumentTemplateKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public final EventType getEventType() {
        RegistrationProtocol protocol = this.getRegistration().getRegistrationProtocol();
        return protocol.isExempted() || protocol.isMobilityAgreement() ? null : EventType.APPROVEMENT_CERTIFICATE_REQUEST;
    }

    public final Integer getNumberOfUnits() {
        if (!this.hasConcluded()) {
            return this.calculateNumberOfUnits();
        }
        return super.getNumberOfUnits() > 0 ? super.getNumberOfUnits().intValue() : this.calculateNumberOfUnits();
    }

    private int calculateNumberOfUnits() {
        return this.getEntriesToReport(this.isDEARegistration()).size() + this.getExtraCurricularEntriesToReport().size() + this.getPropaedeuticEntriesToReport().size();
    }

    public final void setNumberOfUnits(Integer numberOfUnits) {
        throw new DomainException("error.ApprovementCertificateRequest.cannot.modify.numberOfUnits", new String[0]);
    }

    public boolean isToPrint() {
        return !this.hasConcluded() || super.getNumberOfUnits() != null && super.getNumberOfUnits().intValue() == this.calculateNumberOfUnits();
    }

    public Collection<ICurriculumEntry> getApprovedCurriculumEntries() {
        return this.getEntriesToReport(false);
    }

    private final Collection<ICurriculumEntry> getEntriesToReport(boolean useConcluded) {
        HashSet<ICurriculumEntry> result = new HashSet<ICurriculumEntry>();
        Registration registration = this.getRegistration();
        if (registration.isBolonha()) {
            StandaloneCurriculumGroup standalone;
            for (CycleCurriculumGroup cycle : registration.getLastStudentCurricularPlan().getInternalCycleCurriculumGrops()) {
                if (!cycle.hasAnyApprovedCurriculumLines() || !useConcluded && cycle.isConclusionProcessed()) continue;
                Curriculum curriculum = cycle.getCurriculum(this.getFilteringDate());
                ApprovementMobilityCertificateRequest.filterEntries(result, this, curriculum);
            }
            if (this.isMobilityStudent() && (standalone = registration.getLastStudentCurricularPlan().getStandaloneCurriculumGroup()) != null && standalone.hasAnyApprovedCurriculumLines()) {
                result.addAll(this.getStandaloneEntriesToReport());
            }
        } else {
            ICurriculum curriculum = this.getRegistration().getCurriculum(this.getFilteringDate());
            ApprovementMobilityCertificateRequest.filterEntries(result, this, curriculum);
        }
        return result;
    }

    public DateTime getFilteringDate() {
        return this.hasConcluded() ? this.getRequestConclusionDate() : new DateTime();
    }

    public static final void filterEntries(Collection<ICurriculumEntry> result, ApprovementMobilityCertificateRequest request, ICurriculum curriculum) {
        for (ICurriculumEntry entry : curriculum.getCurriculumEntries()) {
            Dismissal dismissal;
            if (entry instanceof Dismissal && ((dismissal = (Dismissal)entry).getCredits().isEquivalence() || dismissal.isCreditsDismissal() && !dismissal.getCredits().isSubstitution())) continue;
            result.add(entry);
        }
    }

    public final Collection<ICurriculumEntry> getStandaloneEntriesToReport() {
        HashSet<ICurriculumEntry> result = new HashSet<ICurriculumEntry>();
        this.reportApprovedCurriculumLines(result, this.calculateStandaloneCurriculumLines());
        return result;
    }

    public final Collection<ICurriculumEntry> getExtraCurricularEntriesToReport() {
        HashSet<ICurriculumEntry> result = new HashSet<ICurriculumEntry>();
        this.reportApprovedCurriculumLines(result, this.calculateExtraCurriculumLines());
        this.reportExternalGroups(result);
        return result;
    }

    private Collection<CurriculumLine> calculateExtraCurriculumLines() {
        HashSet<CurriculumLine> result = new HashSet<CurriculumLine>();
        for (CurriculumLine line : this.getRegistration().getExtraCurricularCurriculumLines()) {
            if (line.isEnrolment()) {
                if (((Enrolment)((Object)line)).isSourceOfAnyCreditsInCurriculum()) continue;
                result.add(line);
                continue;
            }
            result.add(line);
        }
        return result;
    }

    private Collection<CurriculumLine> calculateStandaloneCurriculumLines() {
        HashSet<CurriculumLine> result = new HashSet<CurriculumLine>();
        for (CurriculumLine line : this.getRegistration().getStandaloneCurriculumLines()) {
            if (line.isEnrolment()) {
                if (((Enrolment)((Object)line)).isSourceOfAnyCreditsInCurriculum()) continue;
                result.add(line);
                continue;
            }
            result.add(line);
        }
        return result;
    }

    private void reportApprovedCurriculumLines(Collection<ICurriculumEntry> result, Collection<CurriculumLine> lines) {
        for (CurriculumLine line : lines) {
            if (!line.isApproved()) continue;
            if (line.isEnrolment()) {
                result.add((IEnrolment)((Object)line));
                continue;
            }
            if (!line.isDismissal() || !((Dismissal)((Object)line)).getCredits().isSubstitution()) continue;
            result.addAll(((Dismissal)((Object)line)).getSourceIEnrolments());
        }
    }

    private void reportExternalGroups(Collection<ICurriculumEntry> result) {
        for (ExternalCurriculumGroup group : this.getRegistration().getLastStudentCurricularPlan().getExternalCurriculumGroups()) {
            ApprovementMobilityCertificateRequest.filterEntries(result, this, group.getCurriculumInAdvance(this.getFilteringDate()));
        }
    }

    public final Collection<ICurriculumEntry> getPropaedeuticEntriesToReport() {
        HashSet<ICurriculumEntry> result = new HashSet<ICurriculumEntry>();
        this.reportApprovedCurriculumLines(result, this.getRegistration().getPropaedeuticCurriculumLines());
        return result;
    }

    public boolean hasPersonalInfo() {
        return true;
    }

    protected boolean hasMissingPersonalInfo() {
        return false;
    }

    private boolean isMobilityStudent() {
        return this.getRegistration().getRegistrationProtocol().isMobilityAgreement();
    }
}

