/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests;

import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.EquivalencePlanRequest;
import org.fenixedu.academic.domain.serviceRequests.EquivalencePlanRevisionRequest_Base;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.AcademicServiceRequestType;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestBean;
import org.fenixedu.academic.dto.serviceRequests.RegistrationAcademicServiceRequestCreateBean;

public class EquivalencePlanRevisionRequest
extends EquivalencePlanRevisionRequest_Base {
    protected EquivalencePlanRevisionRequest() {
    }

    public EquivalencePlanRevisionRequest(RegistrationAcademicServiceRequestCreateBean bean) {
        this();
        super.init(bean);
        this.checkParameters(bean);
        super.setEquivalencePlanRequest(bean.getEquivalencePlanRequest());
    }

    public void setEquivalencePlanRequest(EquivalencePlanRequest equivalencePlanRequest) {
        throw new DomainException("error.EquivalencePlanRevisionRequest.cannot.modify.equivalencePlanRequest", new String[0]);
    }

    private void checkParameters(RegistrationAcademicServiceRequestCreateBean bean) {
        EquivalencePlanRequest equivalencePlanRequest = bean.getEquivalencePlanRequest();
        ExecutionYear executionYear = bean.getExecutionYear();
        if (equivalencePlanRequest == null) {
            throw new DomainException("error.EquivalencePlanRevisionRequest.equivalencePlanRequest.cannot.be.null", new String[0]);
        }
        if (!equivalencePlanRequest.hasConcluded()) {
            throw new DomainException("error.EquivalencePlanRevisionRequest.equivalencePlanRequest.is.not.concluded", new String[0]);
        }
        if (executionYear == null) {
            throw new DomainException("error.EquivalencePlanRevisionRequest.executionYear.cannot.be.null", new String[0]);
        }
    }

    public AcademicServiceRequestType getAcademicServiceRequestType() {
        return AcademicServiceRequestType.REVISION_EQUIVALENCE_PLAN;
    }

    public EventType getEventType() {
        return null;
    }

    protected void disconnect() {
        super.setEquivalencePlanRequest(null);
        super.disconnect();
    }

    protected void internalChangeState(AcademicServiceRequestBean academicServiceRequestBean) {
        super.internalChangeState(academicServiceRequestBean);
        if (academicServiceRequestBean.isToProcess()) {
            academicServiceRequestBean.setSituationDate(this.getActiveSituation().getSituationDate().toYearMonthDay());
        }
    }

    public boolean isToPrint() {
        return false;
    }

    public boolean isPossibleToSendToOtherEntity() {
        return true;
    }

    public boolean isManagedWithRectorateSubmissionBatch() {
        return false;
    }

    public boolean isAvailableForTransitedRegistrations() {
        return false;
    }

    public boolean isPayedUponCreation() {
        return false;
    }

    public boolean hasPersonalInfo() {
        return false;
    }
}

