/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.seminar;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.fenixedu.academic.domain.phd.PhdProcessStateType;
import org.fenixedu.academic.domain.phd.seminar.PublicPresentationSeminarProcess;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;

public enum PublicPresentationSeminarProcessStateType implements PhdProcessStateType
{
    WAITING_FOR_COMMISSION_CONSTITUTION,
    COMMISSION_WAITING_FOR_VALIDATION,
    COMMISSION_VALIDATED,
    PUBLIC_PRESENTATION_DATE_SCHEDULED,
    REPORT_WAITING_FOR_VALIDATION,
    REPORT_VALIDATED,
    EXEMPTED;


    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getLocalizedName() {
        return this.getLocalizedName(I18N.getLocale());
    }

    @Override
    public String getLocalizedName(Locale locale) {
        return BundleUtil.getString((String)"resources.PhdResources", (Locale)locale, (String)this.getQualifiedName(), (String[])new String[0]);
    }

    private String getQualifiedName() {
        return this.getClass().getSimpleName() + "." + this.name();
    }

    public static List<PublicPresentationSeminarProcessStateType> getPossibleNextStates(PublicPresentationSeminarProcess process2) {
        PublicPresentationSeminarProcessStateType activeState = process2.getActiveState();
        return PublicPresentationSeminarProcessStateType.getPossibleNextStates(activeState);
    }

    public static List<PublicPresentationSeminarProcessStateType> getPossibleNextStates(PublicPresentationSeminarProcessStateType type) {
        if (type == null) {
            return Collections.singletonList(WAITING_FOR_COMMISSION_CONSTITUTION);
        }
        switch (type) {
            case WAITING_FOR_COMMISSION_CONSTITUTION: {
                return Arrays.asList(COMMISSION_WAITING_FOR_VALIDATION, EXEMPTED);
            }
            case COMMISSION_WAITING_FOR_VALIDATION: {
                return Arrays.asList(COMMISSION_VALIDATED, WAITING_FOR_COMMISSION_CONSTITUTION);
            }
            case COMMISSION_VALIDATED: {
                return Collections.singletonList(PUBLIC_PRESENTATION_DATE_SCHEDULED);
            }
            case PUBLIC_PRESENTATION_DATE_SCHEDULED: {
                return Collections.singletonList(REPORT_WAITING_FOR_VALIDATION);
            }
            case REPORT_WAITING_FOR_VALIDATION: {
                return Collections.singletonList(REPORT_VALIDATED);
            }
            case EXEMPTED: {
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }
}

