/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.alert;

import java.util.Collections;
import java.util.Set;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.alert.PhdCandidacyRefereeAlert_Base;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyPeriod;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyReferee;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;

public class PhdCandidacyRefereeAlert
extends PhdCandidacyRefereeAlert_Base {
    private static final int INTERVAL = 7;

    private PhdCandidacyRefereeAlert() {
    }

    public PhdCandidacyRefereeAlert(PhdCandidacyReferee referee) {
        this();
        String[] args = new String[]{};
        if (referee == null) {
            throw new DomainException("error.PhdCandidacyRefereeAlert.invalid.referee", args);
        }
        this.init(referee.getIndividualProgramProcess(), this.generateSubject(referee), this.generateBody(referee));
        this.setReferee(referee);
    }

    private MultiLanguageString generateSubject(PhdCandidacyReferee referee) {
        return new MultiLanguageString(String.format(BundleUtil.getString((String)"resources.PhdResources", (String)"message.phd.email.subject.referee", (String[])new String[0]), referee.getCandidatePerson().getName(), referee.getCandidatePerson().getName()));
    }

    private MultiLanguageString generateBody(PhdCandidacyReferee referee) {
        return new MultiLanguageString(referee.getPhdProgramCandidacyProcess().getPublicPhdCandidacyPeriod().getEmailMessageBodyForRefereeForm(referee));
    }

    public String getDescription() {
        return BundleUtil.getString((String)"resources.PhdResources", (String)"message.phd.referee.alert", (String[])new String[]{Integer.toString(7)});
    }

    protected boolean isToDiscard() {
        return this.getReferee().getLetter() != null || this.candidacyPeriodIsOver();
    }

    private boolean candidacyPeriodIsOver() {
        LocalDate candidacyDate = this.getReferee().getPhdProgramCandidacyProcess().getCandidacyDate();
        PhdCandidacyPeriod period = this.getReferee().getPhdProgramCandidacyProcess().getPublicPhdCandidacyPeriod();
        return new DateTime().isAfter((ReadableInstant)period.getEnd());
    }

    protected boolean isToFire() {
        int days = Days.daysBetween((ReadableInstant)this.calculateStartDate().toDateMidnight(), (ReadableInstant)new LocalDate().toDateMidnight()).getDays();
        return days >= 7;
    }

    private LocalDate calculateStartDate() {
        return this.getFireDate() != null ? this.getFireDate().toLocalDate() : this.getReferee().getPhdProgramCandidacyProcess().getCandidacyDate();
    }

    protected void generateMessage() {
        new Message((Sender)((Object)this.getSender()), null, Collections.emptyList(), this.buildMailSubject(), this.buildMailBody(), this.getEmail());
    }

    private Set<String> getEmail() {
        return Collections.singleton(this.getReferee().getEmail());
    }

    protected void disconnect() {
        this.setReferee(null);
        super.disconnect();
    }

    public boolean isToSendMail() {
        return true;
    }

    public boolean isSystemAlert() {
        return true;
    }
}

