/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.ExternalPhdStudyPlanEntry;
import org.fenixedu.academic.domain.phd.InternalPhdStudyPlanEntry;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdStudyPlanBean;
import org.fenixedu.academic.domain.phd.PhdStudyPlanEntry;
import org.fenixedu.academic.domain.phd.PhdStudyPlanEntryBean;
import org.fenixedu.academic.domain.phd.PhdStudyPlan_Base;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public class PhdStudyPlan
extends PhdStudyPlan_Base {
    protected PhdStudyPlan() {
        this.setRootDomainObject(Bennu.getInstance());
        this.setWhenCreated(new DateTime());
        if (AccessControl.getPerson() != null) {
            this.setCreatedBy(AccessControl.getPerson().getUsername());
        }
    }

    public PhdStudyPlan(PhdStudyPlanBean bean) {
        this();
        this.init(bean.getProcess(), bean.getDegree(), bean.isExempted());
    }

    private void init(PhdIndividualProgramProcess process2, Degree degree, boolean exempted) {
        String[] args = new String[]{};
        if (process2 == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.phd.PhdStudyPlan.process.cannot.be.null", args);
        }
        super.setProcess(process2);
        this.init(degree, exempted);
    }

    private void init(Degree degree, boolean exempted) {
        super.setExempted(Boolean.valueOf(exempted));
        if (!exempted) {
            String[] args = new String[]{};
            if (degree == null) {
                throw new DomainException("error.org.fenixedu.academic.domain.phd.PhdStudyPlan.degree.cannot.be.null", args);
            }
            if (!degree.isEmpty() && !degree.isDEA()) {
                throw new DomainException("error.org.fenixedu.academic.domain.phd.PhdStudyPlan.degree.must.be.of.type.DEA", new String[0]);
            }
            super.setDegree(degree);
        }
    }

    public void edit(PhdStudyPlanBean bean) {
        this.init(bean.getDegree(), bean.isExempted());
    }

    public void setProcess(PhdIndividualProgramProcess process2) {
        throw new DomainException("error.org.fenixedu.academic.domain.phd.enclosing_type.cannot.modify.process", new String[0]);
    }

    public void addEntries(PhdStudyPlanEntry entry) {
        throw new DomainException("error.org.fenixedu.academic.domain.phd.PhdStudyPlan.cannot.add.entry", new String[0]);
    }

    public Set<PhdStudyPlanEntry> getEntriesSet() {
        return Collections.unmodifiableSet(super.getEntriesSet());
    }

    public void removeEntries(PhdStudyPlanEntry entry) {
        throw new DomainException("error.org.fenixedu.academic.domain.phd.PhdStudyPlan.cannot.remove.entry", new String[0]);
    }

    public Set<PhdStudyPlanEntry> getNormalEntries() {
        HashSet<PhdStudyPlanEntry> result = new HashSet<PhdStudyPlanEntry>();
        for (PhdStudyPlanEntry entry : this.getEntriesSet()) {
            if (!entry.isNormal()) continue;
            result.add(entry);
        }
        return result;
    }

    public Set<PhdStudyPlanEntry> getPropaedeuticEntries() {
        HashSet<PhdStudyPlanEntry> result = new HashSet<PhdStudyPlanEntry>();
        for (PhdStudyPlanEntry entry : this.getEntriesSet()) {
            if (!entry.isPropaedeutic()) continue;
            result.add(entry);
        }
        return result;
    }

    public Set<PhdStudyPlanEntry> getExtraCurricularEntries() {
        HashSet<PhdStudyPlanEntry> result = new HashSet<PhdStudyPlanEntry>();
        for (PhdStudyPlanEntry entry : this.getEntriesSet()) {
            if (!entry.isExtraCurricular()) continue;
            result.add(entry);
        }
        return result;
    }

    public boolean hasSimilarEntry(PhdStudyPlanEntry entry) {
        for (PhdStudyPlanEntry each : this.getEntriesSet()) {
            if (!each.isSimilar(entry)) continue;
            return true;
        }
        return false;
    }

    public void createEntries(PhdStudyPlanEntryBean bean) {
        if (this.getExempted().booleanValue()) {
            throw new DomainException("error.PhdStudyPlanEntry.cannot.add.entries.in.exempted.plan", new String[0]);
        }
        if (bean.getInternalEntry().booleanValue()) {
            for (CompetenceCourse each : bean.getCompetenceCourses()) {
                new InternalPhdStudyPlanEntry(bean.getEntryType(), bean.getStudyPlan(), each);
            }
        } else {
            new ExternalPhdStudyPlanEntry(bean.getEntryType(), bean.getStudyPlan(), bean.getCourseName());
        }
    }

    public void delete() {
        while (!this.getEntriesSet().isEmpty()) {
            this.getEntriesSet().iterator().next().delete();
        }
        super.setProcess(null);
        super.setDegree(null);
        super.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public boolean isToEnrolInCurricularCourses() {
        return !this.getEntriesSet().isEmpty();
    }

    public String getDescription() {
        if (this.getExempted().booleanValue()) {
            return BundleUtil.getString((String)"resources.PhdResources", (String)"label.PhdStudyPlan.description.exempted", (String[])new String[0]);
        }
        return this.getDegree().getPresentationName(this.getProcess().getExecutionYear());
    }

    public boolean isExempted() {
        return this.getExempted() != null && this.getExempted() != false;
    }

    public boolean hasAnyPropaeudeuticsOrExtraEntries() {
        for (PhdStudyPlanEntry entry : this.getEntriesSet()) {
            if (!entry.isPropaedeutic() && !entry.isExtraCurricular()) continue;
            return true;
        }
        return false;
    }

    public boolean hasPropaeudeuticsOrExtraEntriesApproved() {
        StudentCurricularPlan scp = this.getProcess().getRegistration().getLastStudentCurricularPlan();
        for (PhdStudyPlanEntry entry : this.getEntriesSet()) {
            if (!entry.isPropaedeutic() && !entry.isExtraCurricular() || !entry.isInternalEntry() || this.findEnrolment(scp, (InternalPhdStudyPlanEntry)((Object)entry)) != null) continue;
            return false;
        }
        return !this.getEntriesSet().isEmpty();
    }

    private Enrolment findEnrolment(StudentCurricularPlan scp, InternalPhdStudyPlanEntry entry) {
        for (Enrolment enrolment : scp.getRoot().getEnrolments()) {
            if (!enrolment.isApproved() || !this.isFor(enrolment, entry.getCompetenceCourse())) continue;
            return enrolment;
        }
        return null;
    }

    private boolean isFor(Enrolment enrolment, CompetenceCourse competenceCourse) {
        return enrolment.getCurricularCourse().getCompetenceCourse().equals((Object)competenceCourse);
    }

    static {
        PhdStudyPlan.getRelationPhdStudyPlanPhdIndividualProgramProcess().addListener((RelationListener)new RelationAdapter<PhdStudyPlan, PhdIndividualProgramProcess>(){

            public void beforeAdd(PhdStudyPlan studyPlan, PhdIndividualProgramProcess process2) {
                if (studyPlan != null && process2 != null && process2.getStudyPlan() != null) {
                    throw new DomainException("error.org.fenixedu.academic.domain.phd.PhdStudyPlan.process.already.has.study.play", new String[0]);
                }
            }
        });
    }
}

