/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.organizationalStructure;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.accessControl.UnitGroup;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Accountability;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityType;
import org.fenixedu.academic.domain.organizationalStructure.CompetenceCourseGroupUnit;
import org.fenixedu.academic.domain.organizationalStructure.PartyTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.ScientificAreaUnit_Base;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitClassification;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.YearMonthDay;

public class ScientificAreaUnit
extends ScientificAreaUnit_Base {
    private ScientificAreaUnit() {
        super.setType(PartyTypeEnum.SCIENTIFIC_AREA);
    }

    public static ScientificAreaUnit createNewInternalScientificArea(MultiLanguageString name, String unitNameCard, Integer costCenterCode, String acronym, YearMonthDay beginDate, YearMonthDay endDate, Unit parentUnit, AccountabilityType accountabilityType, String webAddress, UnitClassification classification, Boolean canBeResponsibleOfSpaces, Space campus) {
        ScientificAreaUnit scientificAreaUnit = new ScientificAreaUnit();
        scientificAreaUnit.init(name, unitNameCard, costCenterCode, acronym, beginDate, endDate, webAddress, classification, null, canBeResponsibleOfSpaces, campus);
        scientificAreaUnit.addParentUnit(parentUnit, accountabilityType);
        ScientificAreaUnit.checkIfAlreadyExistsOneScientificAreaUnitWithSameAcronymAndName(scientificAreaUnit);
        return scientificAreaUnit;
    }

    public void edit(MultiLanguageString unitName, String unitNameCard, Integer unitCostCenter, String acronym, YearMonthDay beginDate, YearMonthDay endDate, String webAddress, UnitClassification classification, Department department, Degree degree, AdministrativeOffice administrativeOffice, Boolean canBeResponsibleOfSpaces, Space campus) {
        super.edit(unitName, unitNameCard, unitCostCenter, acronym, beginDate, endDate, webAddress, classification, department, degree, administrativeOffice, canBeResponsibleOfSpaces, campus);
        ScientificAreaUnit.checkIfAlreadyExistsOneScientificAreaUnitWithSameAcronymAndName(this);
    }

    public void setAcronym(String acronym) {
        if (StringUtils.isEmpty((String)acronym)) {
            throw new DomainException("error.unit.empty.acronym", new String[0]);
        }
        super.setAcronym(acronym);
    }

    public void setType(PartyTypeEnum partyTypeEnum) {
        throw new DomainException("unit.impossible.set.type", new String[0]);
    }

    public Accountability addParentUnit(Unit parentUnit, AccountabilityType accountabilityType) {
        if (!(parentUnit == null || parentUnit.isInternal() && parentUnit.isDepartmentUnit())) {
            throw new DomainException("error.unit.invalid.parentUnit", new String[0]);
        }
        return super.addParentUnit(parentUnit, accountabilityType);
    }

    public boolean isScientificAreaUnit() {
        return true;
    }

    public boolean hasCompetenceCourses(CompetenceCourse competenceCourse) {
        for (Unit subUnit : this.getSubUnits()) {
            if (!subUnit.hasCompetenceCourses(competenceCourse)) continue;
            return true;
        }
        return false;
    }

    public List<CompetenceCourseGroupUnit> getCompetenceCourseGroupUnits() {
        TreeSet<CompetenceCourseGroupUnit> result = new TreeSet<CompetenceCourseGroupUnit>(CompetenceCourseGroupUnit.COMPARATOR_BY_NAME_AND_ID);
        for (Unit unit : this.getSubUnits()) {
            if (!unit.isCompetenceCourseGroupUnit()) continue;
            result.add((CompetenceCourseGroupUnit)((Object)unit));
        }
        return new ArrayList<CompetenceCourseGroupUnit>(result);
    }

    public Double getScientificAreaUnitEctsCredits() {
        double result = 0.0;
        for (CompetenceCourseGroupUnit competenceCourseGroupUnit : this.getCompetenceCourseGroupUnits()) {
            for (CompetenceCourse competenceCourse : competenceCourseGroupUnit.getCompetenceCourses()) {
                result += competenceCourse.getEctsCredits();
            }
        }
        return result;
    }

    public Double getScientificAreaUnitEctsCredits(List<Context> contexts) {
        double result = 0.0;
        for (Context context : contexts) {
            CurricularCourse curricularCourse;
            if (!context.getChildDegreeModule().isLeaf() || (curricularCourse = (CurricularCourse)((Object)context.getChildDegreeModule())).isOptional() || !curricularCourse.getCompetenceCourse().getScientificAreaUnit().equals((Object)this)) continue;
            result += curricularCourse.getCompetenceCourse().getEctsCredits();
        }
        return result;
    }

    private static void checkIfAlreadyExistsOneScientificAreaUnitWithSameAcronymAndName(ScientificAreaUnit scientificAreaUnit) {
        for (Unit parentUnit : scientificAreaUnit.getParentUnits()) {
            for (Unit unit : parentUnit.getAllSubUnits()) {
                if (unit.equals((Object)scientificAreaUnit) || !scientificAreaUnit.getName().equalsIgnoreCase(unit.getName()) && !scientificAreaUnit.getAcronym().equalsIgnoreCase(unit.getAcronym())) continue;
                throw new DomainException("error.unit.already.exists.unit.with.same.name.or.acronym", new String[0]);
            }
        }
    }

    protected List<Group> getDefaultGroups() {
        List groups = super.getDefaultGroups();
        groups.add(UnitGroup.workers((Unit)((Object)this)));
        return groups;
    }
}

