/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.organizationalStructure;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.FenixEduAcademicConfiguration;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountType;
import org.fenixedu.academic.domain.contacts.EmailAddress;
import org.fenixedu.academic.domain.contacts.MobilePhone;
import org.fenixedu.academic.domain.contacts.PartyContact;
import org.fenixedu.academic.domain.contacts.PartyContactType;
import org.fenixedu.academic.domain.contacts.Phone;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.domain.contacts.PhysicalAddressData;
import org.fenixedu.academic.domain.contacts.WebAddress;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Accountability;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.PartySocialSecurityNumber;
import org.fenixedu.academic.domain.organizationalStructure.PartyType;
import org.fenixedu.academic.domain.organizationalStructure.PartyTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.Party_Base;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.StringNormalizer;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public abstract class Party
extends Party_Base
implements Comparable<Party> {
    public static final Comparator<Party> COMPARATOR_BY_NAME = new Comparator<Party>(){

        @Override
        public int compare(Party o1, Party o2) {
            return Collator.getInstance().compare(o1.getName(), o2.getName());
        }
    };
    public static final Comparator<Party> COMPARATOR_BY_SUBPARTY = new Comparator<Party>(){

        @Override
        public int compare(Party o1, Party o2) {
            if (o1 instanceof Person && o2 instanceof Unit) {
                return 1;
            }
            if (o1 instanceof Unit && o2 instanceof Person) {
                return -1;
            }
            return 0;
        }
    };
    public static final Comparator<Party> COMPARATOR_BY_NAME_AND_ID = new Comparator<Party>(){

        @Override
        public int compare(Party o1, Party o2) {
            ComparatorChain comparatorChain = new ComparatorChain();
            comparatorChain.addComparator(COMPARATOR_BY_NAME);
            comparatorChain.addComparator(DomainObjectUtil.COMPARATOR_BY_ID);
            return comparatorChain.compare((Object)o1, (Object)o2);
        }
    };
    public static final Comparator<Party> COMPARATOR_BY_SUBPARTY_AND_NAME_AND_ID = new Comparator<Party>(){

        @Override
        public int compare(Party o1, Party o2) {
            ComparatorChain comparatorChain = new ComparatorChain();
            comparatorChain.addComparator(COMPARATOR_BY_SUBPARTY);
            comparatorChain.addComparator(COMPARATOR_BY_NAME);
            comparatorChain.addComparator(DomainObjectUtil.COMPARATOR_BY_ID);
            return comparatorChain.compare((Object)o1, (Object)o2);
        }
    };

    public abstract String getPartyPresentationName();

    public abstract MultiLanguageString getPartyName();

    public abstract String getName();

    public Party() {
        this.setRootDomainObject(Bennu.getInstance());
        this.createAccount(AccountType.INTERNAL);
        this.createAccount(AccountType.EXTERNAL);
    }

    @Deprecated
    public final Country getNationality() {
        return this.getCountry();
    }

    @Deprecated
    public void setNationality(Country country) {
        this.setCountry(country);
    }

    public Country getCountry() {
        return super.getNationality();
    }

    public void setCountry(Country country) {
        super.setNationality(country);
    }

    public Account createAccount(AccountType accountType) {
        this.checkAccountsFor(accountType);
        return new Account(accountType, this);
    }

    private void checkAccountsFor(AccountType accountType) {
        if (this.getAccountBy(accountType) != null) {
            throw new DomainException("error.party.accounts.accountType.already.exist", new String[0]);
        }
    }

    public static <T extends Party> Set<T> getPartysSet(Class<T> input) {
        HashSet<Party> partySet = new HashSet<Party>();
        for (Party party : Bennu.getInstance().getPartysSet()) {
            if (!input.isAssignableFrom(party.getClass())) continue;
            partySet.add(party);
        }
        return partySet;
    }

    public Account getAccountBy(AccountType accountType) {
        for (Account account : this.getAccountsSet()) {
            if (account.getAccountType() != accountType) continue;
            return account;
        }
        return null;
    }

    public Account getInternalAccount() {
        return this.getAccountBy(AccountType.INTERNAL);
    }

    public Account getExternalAccount() {
        return this.getAccountBy(AccountType.EXTERNAL);
    }

    public PartyTypeEnum getType() {
        return this.getPartyType() != null ? this.getPartyType().getType() : null;
    }

    public void setType(PartyTypeEnum partyTypeEnum) {
        if (partyTypeEnum != null) {
            PartyType partyType = PartyType.readPartyTypeByType(partyTypeEnum);
            if (partyType == null) {
                throw new DomainException("error.Party.unknown.partyType", new String[0]);
            }
            this.setPartyType(partyType);
        } else {
            this.setPartyType(null);
        }
    }

    public Collection<? extends Party> getCurrentParentParties(AccountabilityTypeEnum accountabilityTypeEnum, Class<? extends Party> parentPartyClass) {
        HashSet<Party> result = new HashSet<Party>();
        for (Accountability accountability : this.getParentsSet()) {
            if (!accountability.isActive() || accountability.getAccountabilityType().getType() != accountabilityTypeEnum || !parentPartyClass.isAssignableFrom(accountability.getParentParty().getClass())) continue;
            result.add(accountability.getParentParty());
        }
        return result;
    }

    public Collection<? extends Party> getParentParties(AccountabilityTypeEnum accountabilityTypeEnum, Class<? extends Party> parentPartyClass) {
        HashSet<Party> result = new HashSet<Party>();
        for (Accountability accountability : this.getParentsSet()) {
            if (accountability.getAccountabilityType().getType() != accountabilityTypeEnum || !parentPartyClass.isAssignableFrom(accountability.getParentParty().getClass())) continue;
            result.add(accountability.getParentParty());
        }
        return result;
    }

    public Collection<? extends Party> getParentParties(Class<? extends Party> parentPartyClass) {
        HashSet<Party> result = new HashSet<Party>();
        for (Accountability accountability : this.getParentsSet()) {
            if (!parentPartyClass.isAssignableFrom(accountability.getParentParty().getClass())) continue;
            result.add(accountability.getParentParty());
        }
        return result;
    }

    public Collection<? extends Party> getParentPartiesByDates(AccountabilityTypeEnum accountabilityTypeEnum, Class<? extends Party> parentPartyClass, DateTime dateTime) {
        HashSet<Party> result = new HashSet<Party>();
        for (Accountability accountability : this.getParentsSet()) {
            if (!parentPartyClass.isAssignableFrom(accountability.getParentParty().getClass()) || !accountability.getBeginDate().toDateTimeAtMidnight().isBefore((ReadableInstant)dateTime)) continue;
            if (accountability.getEndDate() == null) {
                result.add(accountability.getParentParty());
            }
            if (accountability.getEndDate() == null || !accountability.getEndDate().plusDays(1).toDateTimeAtMidnight().minusMillis(1).isAfter((ReadableInstant)dateTime)) continue;
            result.add(accountability.getParentParty());
        }
        return result;
    }

    public Collection<? extends Party> getParentParties(List<AccountabilityTypeEnum> accountabilityTypeEnums, Class<? extends Party> parentPartyClass) {
        HashSet<Party> result = new HashSet<Party>();
        for (Accountability accountability : this.getParentsSet()) {
            if (!accountabilityTypeEnums.contains((Object)accountability.getAccountabilityType().getType()) || !parentPartyClass.isAssignableFrom(accountability.getParentParty().getClass())) continue;
            result.add(accountability.getParentParty());
        }
        return result;
    }

    public Collection<Unit> getParentUnits() {
        return this.getParentParties(Unit.class);
    }

    public Collection<Unit> getParentUnits(String accountabilityTypeEnum) {
        return this.getParentParties(AccountabilityTypeEnum.valueOf(accountabilityTypeEnum), Unit.class);
    }

    public Collection<Unit> getCurrentParentUnits(AccountabilityTypeEnum accountabilityTypeEnum) {
        return this.getCurrentParentParties(accountabilityTypeEnum, Unit.class);
    }

    public Collection<Unit> getParentUnits(AccountabilityTypeEnum accountabilityTypeEnum) {
        return this.getParentParties(accountabilityTypeEnum, Unit.class);
    }

    public Collection<Unit> getParentUnits(List<AccountabilityTypeEnum> accountabilityTypeEnums) {
        return this.getParentParties(accountabilityTypeEnums, Unit.class);
    }

    public Collection<Unit> getSubUnits() {
        return this.getChildParties(Unit.class);
    }

    public Collection<? extends Party> getChildParties(Class<? extends Party> childPartyClass) {
        HashSet<Party> result = new HashSet<Party>();
        for (Accountability accountability : this.getChildsSet()) {
            if (!childPartyClass.isAssignableFrom(accountability.getChildParty().getClass())) continue;
            result.add(accountability.getChildParty());
        }
        return result;
    }

    public Collection<? extends Party> getChildParties(AccountabilityTypeEnum accountabilityTypeEnum, Class<? extends Party> childPartyClass) {
        HashSet<Party> result = new HashSet<Party>();
        for (Accountability accountability : this.getChildsSet()) {
            if (accountability.getAccountabilityType().getType() != accountabilityTypeEnum || !childPartyClass.isAssignableFrom(accountability.getChildParty().getClass())) continue;
            result.add(accountability.getChildParty());
        }
        return result;
    }

    public Collection<? extends Party> getActiveChildParties(AccountabilityTypeEnum accountabilityTypeEnum, Class<? extends Party> childPartyClass) {
        HashSet<Party> result = new HashSet<Party>();
        for (Accountability accountability : this.getChildsSet()) {
            if (!accountability.isActive() || accountability.getAccountabilityType().getType() != accountabilityTypeEnum || !childPartyClass.isAssignableFrom(accountability.getChildParty().getClass())) continue;
            result.add(accountability.getChildParty());
        }
        return result;
    }

    public Collection<? extends Party> getChildParties(List<AccountabilityTypeEnum> accountabilityTypeEnums, Class<? extends Party> childPartyClass) {
        HashSet<Party> result = new HashSet<Party>();
        for (Accountability accountability : this.getChildsSet()) {
            if (!accountabilityTypeEnums.contains((Object)accountability.getAccountabilityType().getType()) || !childPartyClass.isAssignableFrom(accountability.getChildParty().getClass())) continue;
            result.add(accountability.getChildParty());
        }
        return result;
    }

    protected Collection<? extends Party> getChildParties(PartyTypeEnum type, Class<? extends Party> childPartyClass) {
        HashSet<Party> result = new HashSet<Party>();
        for (Accountability accountability : this.getChildsSet()) {
            if (accountability.getChildParty().getType() != type || !childPartyClass.isAssignableFrom(accountability.getChildParty().getClass())) continue;
            result.add(accountability.getChildParty());
        }
        return result;
    }

    public Collection<? extends Accountability> getParentAccountabilities(AccountabilityTypeEnum accountabilityTypeEnum) {
        HashSet<Accountability> result = new HashSet<Accountability>();
        for (Accountability accountability : this.getParentsSet()) {
            if (accountability.getAccountabilityType().getType() != accountabilityTypeEnum) continue;
            result.add(accountability);
        }
        return result;
    }

    public Collection<? extends Accountability> getChildAccountabilities(AccountabilityTypeEnum accountabilityTypeEnum) {
        HashSet<Accountability> result = new HashSet<Accountability>();
        for (Accountability accountability : this.getChildsSet()) {
            if (accountability.getAccountabilityType().getType() != accountabilityTypeEnum) continue;
            result.add(accountability);
        }
        return result;
    }

    public Collection<? extends Accountability> getParentAccountabilities(AccountabilityTypeEnum accountabilityTypeEnum, Class<? extends Accountability> accountabilityClass) {
        HashSet<Accountability> result = new HashSet<Accountability>();
        for (Accountability accountability : this.getParentsSet()) {
            if (accountability.getAccountabilityType().getType() != accountabilityTypeEnum || !accountabilityClass.isAssignableFrom(((Object)((Object)accountability)).getClass())) continue;
            result.add(accountability);
        }
        return result;
    }

    public Collection<? extends Accountability> getChildAccountabilities(Class<? extends Accountability> accountabilityClass, AccountabilityTypeEnum ... types) {
        HashSet<Accountability> result = new HashSet<Accountability>();
        for (Accountability accountability : this.getChildsSet()) {
            AccountabilityTypeEnum accountabilityType = accountability.getAccountabilityType().getType();
            if (!this.isOneOfTypes(accountabilityType, types) || !accountabilityClass.isAssignableFrom(((Object)((Object)accountability)).getClass())) continue;
            result.add(accountability);
        }
        return result;
    }

    private boolean isOneOfTypes(AccountabilityTypeEnum type, AccountabilityTypeEnum[] possibilities) {
        for (AccountabilityTypeEnum t : possibilities) {
            if (t != type) continue;
            return true;
        }
        return false;
    }

    public Collection<? extends Accountability> getParentAccountabilitiesByParentClass(Class<? extends Party> parentClass) {
        HashSet<Accountability> result = new HashSet<Accountability>();
        for (Accountability accountability : this.getParentsSet()) {
            if (!parentClass.isAssignableFrom(accountability.getParentParty().getClass())) continue;
            result.add(accountability);
        }
        return result;
    }

    public Collection<? extends Accountability> getChildAccountabilitiesByChildClass(Class<? extends Party> childClass) {
        HashSet<Accountability> result = new HashSet<Accountability>();
        for (Accountability accountability : this.getChildsSet()) {
            if (!childClass.isAssignableFrom(accountability.getChildParty().getClass())) continue;
            result.add(accountability);
        }
        return result;
    }

    public Collection<? extends Accountability> getChildAccountabilitiesByAccountabilityClass(Class<? extends Accountability> accountabilityClass) {
        HashSet<Accountability> result = new HashSet<Accountability>();
        for (Accountability accountability : this.getChildsSet()) {
            if (!accountabilityClass.isAssignableFrom(((Object)((Object)accountability)).getClass())) continue;
            result.add(accountability);
        }
        return result;
    }

    protected void delete() {
        DomainException.throwWhenDeleteBlocked(this.getDeletionBlockers());
        while (!this.getAccountsSet().isEmpty()) {
            ((Account)((Object)this.getAccountsSet().iterator().next())).delete();
        }
        while (!this.getPartyContactsSet().isEmpty()) {
            ((PartyContact)((Object)this.getPartyContactsSet().iterator().next())).deleteWithoutCheckRules();
        }
        if (this.getPartySocialSecurityNumber() != null) {
            this.getPartySocialSecurityNumber().delete();
        }
        super.setNationality(null);
        this.setPartyType(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    public static Party readByContributorNumber(String contributorNumber) {
        return PartySocialSecurityNumber.readPartyBySocialSecurityNumber(contributorNumber);
    }

    public String getSocialSecurityNumber() {
        return this.getPartySocialSecurityNumber() != null ? this.getPartySocialSecurityNumber().getSocialSecurityNumber() : null;
    }

    public void setSocialSecurityNumber(String socialSecurityNumber) {
        if ((socialSecurityNumber = StringUtils.trimToNull((String)socialSecurityNumber)) != null && !StringUtils.isBlank((String)socialSecurityNumber)) {
            Party party;
            if (this.getPartySocialSecurityNumber() != null && socialSecurityNumber.equals(this.getPartySocialSecurityNumber().getSocialSecurityNumber())) {
                return;
            }
            String defaultSocialSecurityNumber = FenixEduAcademicConfiguration.getConfiguration().getDefaultSocialSecurityNumber();
            if (!(defaultSocialSecurityNumber != null && defaultSocialSecurityNumber.equals(socialSecurityNumber) || (party = PartySocialSecurityNumber.readPartyBySocialSecurityNumber(socialSecurityNumber)) == null || party == this)) {
                throw new DomainException("error.party.existing.contributor.number", new String[0]);
            }
            if (this.getPartySocialSecurityNumber() != null) {
                this.getPartySocialSecurityNumber().setSocialSecurityNumber(socialSecurityNumber);
            } else {
                new PartySocialSecurityNumber(this, socialSecurityNumber);
            }
        }
    }

    public boolean isPerson() {
        return false;
    }

    public boolean isUnit() {
        return false;
    }

    public boolean isDepartmentUnit() {
        return false;
    }

    public boolean isCompetenceCourseGroupUnit() {
        return false;
    }

    public boolean isScientificAreaUnit() {
        return false;
    }

    public boolean isAdministrativeOfficeUnit() {
        return false;
    }

    public boolean isDegreeUnit() {
        return false;
    }

    public boolean isAcademicalUnit() {
        return false;
    }

    public boolean isSchoolUnit() {
        return false;
    }

    public boolean isUniversityUnit() {
        return false;
    }

    public boolean isPlanetUnit() {
        return false;
    }

    public boolean isCountryUnit() {
        return false;
    }

    public boolean isSectionUnit() {
        return false;
    }

    public boolean isAggregateUnit() {
        return false;
    }

    public boolean hasCompetenceCourses(CompetenceCourse competenceCourse) {
        return false;
    }

    public boolean hasDepartment() {
        return false;
    }

    public boolean verifyNameEquality(String[] nameWords) {
        if (nameWords == null) {
            return true;
        }
        if (this.getName() != null) {
            int i;
            String[] personNameWords = StringNormalizer.normalize((String)this.getName()).trim().split(" ");
            for (i = 0; i < nameWords.length; ++i) {
                int j;
                if (nameWords[i].equals("")) continue;
                for (j = 0; j < personNameWords.length && !personNameWords[j].equals(nameWords[i]); ++j) {
                }
                if (j != personNameWords.length) continue;
                return false;
            }
            if (i == nameWords.length) {
                return true;
            }
        }
        return false;
    }

    public boolean hasPartyContact(Class<? extends PartyContact> clazz, PartyContactType type, String value) {
        List<? extends PartyContact> allPartyContacts = this.getPartyContacts(clazz, type);
        for (PartyContact partyContact : allPartyContacts) {
            if (!partyContact.hasValue(value)) continue;
            return true;
        }
        return false;
    }

    public List<? extends PartyContact> getAllPartyContacts(Class<? extends PartyContact> clazz, PartyContactType type) {
        ArrayList<PartyContact> result = new ArrayList<PartyContact>();
        for (PartyContact contact : this.getPartyContactsSet()) {
            if (!clazz.isAssignableFrom(((Object)((Object)contact)).getClass()) || type != null && contact.getType() != type) continue;
            result.add(contact);
        }
        return result;
    }

    public List<? extends PartyContact> getAllPartyContacts(Class<? extends PartyContact> clazz) {
        return this.getAllPartyContacts(clazz, null);
    }

    public List<? extends PartyContact> getPartyContacts(Class<? extends PartyContact> clazz, PartyContactType type) {
        ArrayList<PartyContact> result = new ArrayList<PartyContact>();
        for (PartyContact contact : this.getPartyContactsSet()) {
            if (!clazz.isAssignableFrom(((Object)((Object)contact)).getClass()) || type != null && contact.getType() != type || !contact.isActiveAndValid()) continue;
            result.add(contact);
        }
        return result;
    }

    public List<? extends PartyContact> getPendingOrValidPartyContacts(Class<? extends PartyContact> clazz, PartyContactType type) {
        ArrayList<PartyContact> result = new ArrayList<PartyContact>();
        for (PartyContact contact : this.getPartyContactsSet()) {
            if (!clazz.isAssignableFrom(((Object)((Object)contact)).getClass()) || type != null && contact.getType() != type || !contact.isActiveAndValid() && !contact.waitsValidation()) continue;
            result.add(contact);
        }
        return result;
    }

    public List<? extends PartyContact> getPendingOrValidPartyContacts(Class<? extends PartyContact> clazz) {
        return this.getPendingOrValidPartyContacts(clazz, null);
    }

    public List<? extends PartyContact> getPendingPartyContacts(Class<? extends PartyContact> clazz, PartyContactType type) {
        ArrayList<PartyContact> result = new ArrayList<PartyContact>();
        for (PartyContact contact : this.getPartyContactsSet()) {
            if (!clazz.isAssignableFrom(((Object)((Object)contact)).getClass()) || type != null && contact.getType() != type || !contact.waitsValidation()) continue;
            result.add(contact);
        }
        return result;
    }

    public List<? extends PartyContact> getAllPendingPartyContacts() {
        ArrayList<PartyContact> result = new ArrayList<PartyContact>();
        for (PartyContact contact : this.getPartyContactsSet()) {
            if (!contact.waitsValidation()) continue;
            result.add(contact);
        }
        return result;
    }

    public List<? extends PartyContact> getPartyContacts(Class<? extends PartyContact> clazz) {
        return this.getPartyContacts(clazz, null);
    }

    public List<? extends PartyContact> getPendingPartyContacts(Class<? extends PartyContact> clazz) {
        return this.getPendingPartyContacts(clazz, null);
    }

    public boolean hasPendingPartyContacts(Class<? extends PartyContact> clazz) {
        return this.getPendingPartyContacts(clazz, null).size() > 0;
    }

    public boolean hasPendingPartyContacts() {
        return this.getAllPendingPartyContacts().size() > 0;
    }

    public boolean hasAnyPartyContact(Class<? extends PartyContact> clazz, PartyContactType type) {
        for (PartyContact contact : this.getPartyContactsSet()) {
            if (!clazz.isAssignableFrom(((Object)((Object)contact)).getClass()) || type != null && contact.getType() != type || !contact.isActiveAndValid()) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyPartyContact(Class<? extends PartyContact> clazz) {
        return this.hasAnyPartyContact(clazz, null);
    }

    public PartyContact getDefaultPartyContact(Class<? extends PartyContact> clazz) {
        for (PartyContact contact : this.getPartyContactsSet()) {
            if (!clazz.isAssignableFrom(((Object)((Object)contact)).getClass()) || !contact.isDefault() || !contact.isActiveAndValid()) continue;
            return contact;
        }
        return null;
    }

    public boolean hasDefaultPartyContact(Class<? extends PartyContact> clazz) {
        return this.getDefaultPartyContact(clazz) != null;
    }

    public PartyContact getInstitutionalPartyContact(Class<? extends PartyContact> clazz) {
        List<? extends PartyContact> institutionals = this.getPartyContacts(EmailAddress.class, PartyContactType.INSTITUTIONAL);
        return institutionals.isEmpty() ? null : institutionals.iterator().next();
    }

    public boolean hasInstitutionalPartyContact(Class<? extends PartyContact> clazz) {
        return this.getInstitutionalPartyContact(clazz) != null;
    }

    public List<WebAddress> getWebAddresses() {
        return this.getPartyContacts(WebAddress.class);
    }

    public List<WebAddress> getPendingWebAddresses() {
        return this.getPendingPartyContacts(WebAddress.class);
    }

    public boolean hasDefaultWebAddress() {
        return this.hasDefaultPartyContact(WebAddress.class);
    }

    public WebAddress getDefaultWebAddress() {
        return (WebAddress)((Object)this.getDefaultPartyContact(WebAddress.class));
    }

    public String getDefaultWebAddressUrl() {
        return this.hasDefaultWebAddress() ? this.getDefaultWebAddress().getUrl() : "";
    }

    public void setDefaultWebAddressUrl(String url) {
        if (this.hasDefaultWebAddress()) {
            this.getDefaultWebAddress().edit(url);
        } else {
            WebAddress.createWebAddress(this, url, PartyContactType.PERSONAL, true);
        }
    }

    @Deprecated
    public String getWebAddress() {
        return this.getDefaultWebAddressUrl();
    }

    @Deprecated
    public void setWebAddress(String webAddress) {
        this.setDefaultWebAddressUrl(webAddress);
    }

    public List<Phone> getPhones() {
        return this.getPartyContacts(Phone.class);
    }

    public List<Phone> getPendingPhones() {
        return this.getPendingPartyContacts(Phone.class);
    }

    public List<Phone> getPendingOrValidPhones() {
        return this.getPendingOrValidPartyContacts(Phone.class);
    }

    public boolean hasDefaultPhone() {
        return this.hasDefaultPartyContact(Phone.class);
    }

    public Phone getDefaultPhone() {
        return (Phone)((Object)this.getDefaultPartyContact(Phone.class));
    }

    public String getDefaultPhoneNumber() {
        return this.hasDefaultPhone() ? this.getDefaultPhone().getNumber() : "";
    }

    public void setDefaultPhoneNumber(String number) {
        this.setDefaultPhoneNumber(number, false);
    }

    public void setDefaultPhoneNumber(String number, boolean valid) {
        Phone defaultPhone;
        if (this.hasDefaultPhone()) {
            defaultPhone = this.getDefaultPhone();
            defaultPhone.edit(number);
        } else {
            defaultPhone = Phone.createPhone(this, number, PartyContactType.PERSONAL, true);
        }
        if (valid) {
            defaultPhone.setValid();
        }
    }

    @Deprecated
    public void setWorkPhoneNumber(String number) {
        if (this.hasAnyPartyContact(Phone.class, PartyContactType.WORK)) {
            ((Phone)((Object)this.getPartyContacts(Phone.class, PartyContactType.WORK).iterator().next())).edit(number);
        } else {
            Phone.createPhone(this, number, PartyContactType.WORK, false);
        }
    }

    @Deprecated
    public String getPhone() {
        return this.getDefaultPhoneNumber();
    }

    @Deprecated
    public void setPhone(String phone) {
        this.setDefaultPhoneNumber(phone);
    }

    public Phone getPersonWorkPhone() {
        List<? extends PartyContact> partyContacts = this.getPartyContacts(Phone.class, PartyContactType.WORK);
        return partyContacts.isEmpty() ? null : (Phone)((Object)partyContacts.iterator().next());
    }

    @Deprecated
    public String getWorkPhone() {
        Phone workPhone = this.getPersonWorkPhone();
        return workPhone != null ? workPhone.getNumber() : null;
    }

    @Deprecated
    public void setWorkPhone(String workPhone) {
        this.setWorkPhoneNumber(workPhone);
    }

    public List<MobilePhone> getMobilePhones() {
        return this.getPartyContacts(MobilePhone.class);
    }

    public List<MobilePhone> getPendingMobilePhones() {
        return this.getPendingPartyContacts(MobilePhone.class);
    }

    public List<MobilePhone> getPendingOrValidMobilePhones() {
        return this.getPendingOrValidPartyContacts(MobilePhone.class);
    }

    public boolean hasDefaultMobilePhone() {
        return this.hasDefaultPartyContact(MobilePhone.class);
    }

    public MobilePhone getDefaultMobilePhone() {
        return (MobilePhone)((Object)this.getDefaultPartyContact(MobilePhone.class));
    }

    public String getDefaultMobilePhoneNumber() {
        return this.hasDefaultMobilePhone() ? this.getDefaultMobilePhone().getNumber() : "";
    }

    public void setDefaultMobilePhoneNumber(String number) {
        this.setDefaultMobilePhoneNumber(number, false);
    }

    public void setDefaultMobilePhoneNumber(String number, boolean valid) {
        MobilePhone mobilePhone;
        if (this.hasDefaultMobilePhone()) {
            mobilePhone = this.getDefaultMobilePhone();
            mobilePhone.edit(number);
        } else {
            mobilePhone = MobilePhone.createMobilePhone(this, number, PartyContactType.PERSONAL, true);
        }
        if (valid) {
            mobilePhone.setValid();
        }
    }

    @Deprecated
    public String getMobile() {
        return this.getDefaultMobilePhoneNumber();
    }

    @Deprecated
    public void setMobile(String mobile) {
        this.setDefaultMobilePhoneNumber(mobile);
    }

    public List<EmailAddress> getEmailAddresses() {
        return this.getPartyContacts(EmailAddress.class);
    }

    public List<EmailAddress> getPendingEmailAddresses() {
        return this.getPendingPartyContacts(EmailAddress.class);
    }

    public List<EmailAddress> getPendingOrValidEmailAddresses() {
        return this.getPendingOrValidPartyContacts(EmailAddress.class);
    }

    public boolean hasDefaultEmailAddress() {
        return this.hasDefaultPartyContact(EmailAddress.class);
    }

    public EmailAddress getDefaultEmailAddress() {
        return (EmailAddress)((Object)this.getDefaultPartyContact(EmailAddress.class));
    }

    public boolean hasInstitutionalEmailAddress() {
        return this.hasInstitutionalPartyContact(EmailAddress.class);
    }

    public EmailAddress getInstitutionalEmailAddress() {
        return (EmailAddress)((Object)this.getInstitutionalPartyContact(EmailAddress.class));
    }

    public EmailAddress getInstitutionalOrDefaultEmailAddress() {
        return this.hasInstitutionalEmailAddress() ? this.getInstitutionalEmailAddress() : this.getDefaultEmailAddress();
    }

    public String getDefaultEmailAddressValue() {
        return this.hasDefaultEmailAddress() ? this.getDefaultEmailAddress().getValue() : "";
    }

    public void setDefaultEmailAddressValue(String email) {
        this.setDefaultEmailAddressValue(email, false, false);
    }

    public void setDefaultEmailAddressValue(String email, boolean valid) {
        this.setDefaultEmailAddressValue(email, valid, false);
    }

    public void setDefaultEmailAddressValue(String email, boolean valid, boolean visibleToPublic) {
        if (!StringUtils.isEmpty((String)email)) {
            EmailAddress emailAddress;
            if (this.hasDefaultEmailAddress()) {
                emailAddress = this.getDefaultEmailAddress();
                emailAddress.edit(email);
            } else {
                emailAddress = EmailAddress.createEmailAddress(this, email, PartyContactType.PERSONAL, true);
            }
            emailAddress.setVisibleToPublic(visibleToPublic);
            if (valid) {
                emailAddress.setValid();
            }
        }
    }

    public String getInstitutionalEmailAddressValue() {
        return this.hasInstitutionalEmailAddress() ? this.getInstitutionalEmailAddress().getValue() : "";
    }

    public void setInstitutionalEmailAddressValue(String email) {
        if (this.hasInstitutionalEmailAddress()) {
            this.getInstitutionalEmailAddress().setValue(email);
        } else {
            EmailAddress emailAddress = EmailAddress.createEmailAddress(this, email, PartyContactType.INSTITUTIONAL, false);
            emailAddress.setValid();
        }
    }

    public String getInstitutionalOrDefaultEmailAddressValue() {
        EmailAddress email = this.getInstitutionalOrDefaultEmailAddress();
        return email != null ? email.getValue() : "";
    }

    @Deprecated
    public String getEmail() {
        return this.getDefaultEmailAddressValue();
    }

    @Deprecated
    public void setEmail(String email) {
        this.setDefaultEmailAddressValue(email);
    }

    public List<PhysicalAddress> getPhysicalAddresses() {
        return this.getPartyContacts(PhysicalAddress.class);
    }

    public List<PhysicalAddress> getPendingPhysicalAddresses() {
        return this.getPendingPartyContacts(PhysicalAddress.class);
    }

    public List<PhysicalAddress> getPendingOrValidPhysicalAddresses() {
        return this.getPendingOrValidPartyContacts(PhysicalAddress.class);
    }

    public boolean hasDefaultPhysicalAddress() {
        return this.hasDefaultPartyContact(PhysicalAddress.class);
    }

    public PhysicalAddress getDefaultPhysicalAddress() {
        return (PhysicalAddress)((Object)this.getDefaultPartyContact(PhysicalAddress.class));
    }

    public void setDefaultPhysicalAddressData(PhysicalAddressData data) {
        this.setDefaultPhysicalAddressData(data, false);
    }

    public void setDefaultPhysicalAddressData(PhysicalAddressData data, boolean valid) {
        PhysicalAddress defaultPhysicalAddress;
        if (this.hasDefaultPhysicalAddress()) {
            defaultPhysicalAddress = this.getDefaultPhysicalAddress();
            defaultPhysicalAddress.edit(data);
        } else {
            defaultPhysicalAddress = PhysicalAddress.createPhysicalAddress(this, data, PartyContactType.PERSONAL, true);
        }
        if (valid) {
            defaultPhysicalAddress.setValid();
        }
    }

    private PhysicalAddress getOrCreateDefaultPhysicalAddress() {
        PhysicalAddress physicalAdress = this.getDefaultPhysicalAddress();
        return physicalAdress != null ? physicalAdress : PhysicalAddress.createPhysicalAddress(this, null, PartyContactType.PERSONAL, true);
    }

    public String getAddress() {
        return this.hasDefaultPhysicalAddress() ? this.getDefaultPhysicalAddress().getAddress() : "";
    }

    public void setAddress(String address) {
        this.getOrCreateDefaultPhysicalAddress().setAddress(address);
    }

    public String getAreaCode() {
        return this.hasDefaultPhysicalAddress() ? this.getDefaultPhysicalAddress().getAreaCode() : "";
    }

    public void setAreaCode(String areaCode) {
        this.getOrCreateDefaultPhysicalAddress().setAreaCode(areaCode);
    }

    public String getAreaOfAreaCode() {
        return this.hasDefaultPhysicalAddress() ? this.getDefaultPhysicalAddress().getAreaOfAreaCode() : "";
    }

    public void setAreaOfAreaCode(String areaOfAreaCode) {
        this.getOrCreateDefaultPhysicalAddress().setAreaOfAreaCode(areaOfAreaCode);
    }

    public String getPostalCode() {
        return this.hasDefaultPhysicalAddress() ? this.getDefaultPhysicalAddress().getPostalCode() : "";
    }

    public String getArea() {
        return this.hasDefaultPhysicalAddress() ? this.getDefaultPhysicalAddress().getArea() : "";
    }

    public void setArea(String area) {
        this.getOrCreateDefaultPhysicalAddress().setArea(area);
    }

    public String getParishOfResidence() {
        return this.hasDefaultPhysicalAddress() ? this.getDefaultPhysicalAddress().getParishOfResidence() : "";
    }

    public void setParishOfResidence(String parishOfResidence) {
        this.getOrCreateDefaultPhysicalAddress().setParishOfResidence(parishOfResidence);
    }

    public String getDistrictSubdivisionOfResidence() {
        return this.hasDefaultPhysicalAddress() ? this.getDefaultPhysicalAddress().getDistrictSubdivisionOfResidence() : "";
    }

    public void setDistrictSubdivisionOfResidence(String districtSubdivisionOfResidence) {
        this.getOrCreateDefaultPhysicalAddress().setDistrictSubdivisionOfResidence(districtSubdivisionOfResidence);
    }

    public String getDistrictOfResidence() {
        return this.hasDefaultPhysicalAddress() ? this.getDefaultPhysicalAddress().getDistrictOfResidence() : "";
    }

    public void setDistrictOfResidence(String districtOfResidence) {
        this.getOrCreateDefaultPhysicalAddress().setDistrictOfResidence(districtOfResidence);
    }

    public Country getCountryOfResidence() {
        return this.hasDefaultPhysicalAddress() ? this.getDefaultPhysicalAddress().getCountryOfResidence() : null;
    }

    public void setCountryOfResidence(Country countryOfResidence) {
        this.getOrCreateDefaultPhysicalAddress().setCountryOfResidence(countryOfResidence);
    }

    @Override
    public int compareTo(Party party) {
        return COMPARATOR_BY_NAME.compare(this, party);
    }

    public void logCreateContact(PartyContact contact) {
    }

    public void logEditContact(PartyContact contact, boolean propertiesChanged, boolean valueChanged, boolean createdNewContact, String newValue) {
    }

    public void logDeleteContact(PartyContact contact) {
    }

    public void logValidContact(PartyContact contact) {
    }

    public void logRefuseContact(PartyContact contact) {
    }
}

