/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.mobility;

import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ErasmusCoordinatorBean;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityApplicationProcess;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityCoordinator_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.domain.Bennu;

public class MobilityCoordinator
extends MobilityCoordinator_Base {
    private MobilityCoordinator() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public MobilityCoordinator(MobilityApplicationProcess applicationProcess, ErasmusCoordinatorBean bean) {
        this(applicationProcess, bean.getTeacher(), bean.getDegree());
    }

    public MobilityCoordinator(MobilityApplicationProcess applicationProcess, Teacher teacher, Degree degree) {
        this();
        this.check(applicationProcess, teacher, degree);
        this.setMobilityApplicationProcess(applicationProcess);
        this.setTeacher(teacher);
        this.setDegree(degree);
    }

    private void check(MobilityApplicationProcess applicationProcess, Teacher teacher, Degree degree) {
        if (applicationProcess == null) {
            throw new DomainException("error.erasmus.coordinator.candidacyProcess.must.not.be.null", new String[0]);
        }
        if (teacher == null) {
            throw new DomainException("error.erasmus.coordinator.teacher.must.not.be.null", new String[0]);
        }
        if (degree == null) {
            throw new DomainException("error.erasmus.coordinator.degree.must.not.be.null", new String[0]);
        }
        if (applicationProcess.isTeacherErasmusCoordinatorForDegree(teacher, degree)) {
            throw new DomainException("error.erasmus.coordinator.teacher.is.assigned.for.process.and.degree", new String[0]);
        }
    }

    public void delete() {
        this.setDegree(null);
        this.setMobilityApplicationProcess(null);
        this.setTeacher(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }
}

