/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.erasmus;

import java.io.Serializable;
import java.util.List;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ErasmusVacancy;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityAgreement;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityProgram;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityQuota;
import org.fenixedu.academic.domain.organizationalStructure.UniversityUnit;

public class ErasmusVacancyBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private UniversityUnit university;
    private Country country;
    private List<Degree> degrees;
    private Integer numberOfVacancies;
    private ErasmusVacancy vacancy;
    private MobilityQuota quota;
    private MobilityProgram mobilityProgram;

    public ErasmusVacancyBean() {
    }

    public ErasmusVacancyBean(MobilityQuota quota) {
        this.quota = quota;
    }

    public ErasmusVacancyBean(MobilityProgram program) {
        this.mobilityProgram = program;
    }

    public UniversityUnit getUniversity() {
        return this.university;
    }

    public void setUniversity(UniversityUnit university) {
        this.university = university;
    }

    public Country getCountry() {
        return this.country;
    }

    public void setCountry(Country country) {
        this.country = country;
    }

    public List<Degree> getDegrees() {
        return this.degrees;
    }

    public void setDegrees(List<Degree> degrees) {
        this.degrees = degrees;
    }

    public Integer getNumberOfVacancies() {
        return this.numberOfVacancies;
    }

    public void setNumberOfVacancies(Integer numberOfVacancies) {
        this.numberOfVacancies = numberOfVacancies;
    }

    public MobilityQuota getQuota() {
        return this.quota;
    }

    public void setQuota(MobilityQuota quota) {
        this.quota = quota;
    }

    public ErasmusVacancy getVacancy() {
        return this.vacancy;
    }

    public void setVacancy(ErasmusVacancy vacancy) {
        this.vacancy = vacancy;
    }

    public MobilityProgram getMobilityProgram() {
        return this.mobilityProgram;
    }

    public void setMobilityProgram(MobilityProgram mobilityProgram) {
        this.mobilityProgram = mobilityProgram;
    }

    public MobilityAgreement getMobilityAgreement() {
        if (this.mobilityProgram == null || this.university == null) {
            return null;
        }
        return this.mobilityProgram.getMobilityAgreementByUniversityUnit(this.university);
    }
}

