/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacy.workflow.form;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.util.workflow.Form;
import org.fenixedu.academic.util.LabelFormatter;
import org.joda.time.YearMonthDay;

public class FiliationForm
extends Form {
    private static final long serialVersionUID = 1L;
    private YearMonthDay dateOfBirth;
    private Country nationality;
    private String parishOfBirth;
    private String districtSubdivisionOfBirth;
    private String districtOfBirth;
    private String fatherName;
    private String motherName;
    private Country countryOfBirth;

    public FiliationForm() {
    }

    public static FiliationForm createFromPerson(Person person) {
        Country nationality = person.getCountry() != null ? person.getCountry() : Country.readDefault();
        Country countryOfBirth = person.getCountryOfBirth() != null ? person.getCountryOfBirth() : Country.readDefault();
        return new FiliationForm(person.getDateOfBirthYearMonthDay(), person.getDistrictOfBirth(), person.getDistrictSubdivisionOfBirth(), person.getNameOfFather(), person.getNameOfMother(), nationality, person.getParishOfBirth(), countryOfBirth);
    }

    private FiliationForm(YearMonthDay dateOfBirth, String districtOfBirth, String districtSubdivisionOfBirth, String fatherName, String motherName, Country nationality, String parishOfBirth, Country countryOfBirth) {
        this();
        this.dateOfBirth = dateOfBirth;
        this.districtOfBirth = districtOfBirth;
        this.districtSubdivisionOfBirth = districtSubdivisionOfBirth;
        this.fatherName = fatherName;
        this.motherName = motherName;
        this.setNationality(nationality);
        this.parishOfBirth = parishOfBirth;
        this.setCountryOfBirth(countryOfBirth);
    }

    public YearMonthDay getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(YearMonthDay dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public String getDistrictOfBirth() {
        return this.districtOfBirth;
    }

    public void setDistrictOfBirth(String districtOfBirth) {
        this.districtOfBirth = districtOfBirth;
    }

    public String getDistrictSubdivisionOfBirth() {
        return this.districtSubdivisionOfBirth;
    }

    public void setDistrictSubdivisionOfBirth(String districtSubdivisionOfBirth) {
        this.districtSubdivisionOfBirth = districtSubdivisionOfBirth;
    }

    public String getFatherName() {
        return this.fatherName;
    }

    public void setFatherName(String fatherName) {
        this.fatherName = fatherName;
    }

    public String getMotherName() {
        return this.motherName;
    }

    public void setMotherName(String motherName) {
        this.motherName = motherName;
    }

    public Country getNationality() {
        return this.nationality;
    }

    public void setNationality(Country nationality) {
        this.nationality = nationality;
    }

    public String getParishOfBirth() {
        return this.parishOfBirth;
    }

    public void setParishOfBirth(String parishOfBirth) {
        this.parishOfBirth = parishOfBirth;
    }

    public Country getCountryOfBirth() {
        return this.countryOfBirth;
    }

    public void setCountryOfBirth(Country countryOfBirth) {
        this.countryOfBirth = countryOfBirth;
    }

    @Override
    public List<LabelFormatter> validate() {
        if (this.getCountryOfBirth().isDefaultCountry() && (StringUtils.isEmpty((String)this.getDistrictOfBirth()) || StringUtils.isEmpty((String)this.getDistrictSubdivisionOfBirth()) || StringUtils.isEmpty((String)this.getParishOfBirth()))) {
            return Collections.singletonList(new LabelFormatter("error.candidacy.workflow.FiliationForm.zone.information.is.required.for.national.students", "resources.ApplicationResources"));
        }
        return Collections.emptyList();
    }

    @Override
    public String getFormName() {
        return "label.candidacy.workflow.filiationForm";
    }
}

