/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.administrativeOffice;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOfficeType;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice_Base;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdProgram;
import org.fenixedu.academic.domain.serviceRequests.RectorateSubmissionBatch;
import org.fenixedu.academic.domain.serviceRequests.RectorateSubmissionState;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class AdministrativeOffice
extends AdministrativeOffice_Base {
    public AdministrativeOffice() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    @Deprecated
    public static AdministrativeOffice readByAdministrativeOfficeType(AdministrativeOfficeType administrativeOfficeType) {
        for (AdministrativeOffice administrativeOffice : Bennu.getInstance().getAdministrativeOfficesSet()) {
            if (administrativeOffice.getAdministrativeOfficeType() != administrativeOfficeType) continue;
            return administrativeOffice;
        }
        return null;
    }

    @Deprecated
    public static AdministrativeOffice readDegreeAdministrativeOffice() {
        return AdministrativeOffice.readByAdministrativeOfficeType(AdministrativeOfficeType.DEGREE);
    }

    @Deprecated
    public static AdministrativeOffice readMasterDegreeAdministrativeOffice() {
        return AdministrativeOffice.readByAdministrativeOfficeType(AdministrativeOfficeType.MASTER_DEGREE);
    }

    public Set<DegreeType> getAdministratedDegreeTypes() {
        HashSet<DegreeType> result = new HashSet<DegreeType>();
        for (AcademicProgram program : this.getManagedAcademicProgramSet()) {
            result.add(program.getDegreeType());
        }
        return result;
    }

    public Set<CycleType> getAdministratedCycleTypes() {
        HashSet<CycleType> result = new HashSet<CycleType>();
        for (AcademicProgram program : this.getManagedAcademicProgramSet()) {
            result.addAll(program.getCycleTypes());
        }
        return result;
    }

    public Set<Degree> getAdministratedDegrees() {
        TreeSet<Degree> result = new TreeSet<Degree>(Degree.COMPARATOR_BY_DEGREE_TYPE_AND_NAME_AND_ID);
        for (AcademicProgram program : this.getManagedAcademicProgramSet()) {
            if (!(program instanceof Degree)) continue;
            result.add((Degree)((Object)program));
        }
        return result;
    }

    public Set<Degree> getAdministratedDegreesForStudentCreationWithoutCandidacy() {
        TreeSet<Degree> result = new TreeSet<Degree>(Degree.COMPARATOR_BY_DEGREE_TYPE_AND_NAME_AND_ID);
        result.addAll(this.getAdministratedDegrees());
        return result;
    }

    public void delete() {
        DomainException.throwWhenDeleteBlocked(this.getDeletionBlockers());
        this.setUnit(null);
        this.setServiceAgreementTemplate(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (!this.getAcademicServiceRequestsSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.AdministrativeOffice.cannot.delete", (String[])new String[0]));
        }
        if (!this.getManagedAcademicProgramSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.AdministrativeOffice.cannot.delete", (String[])new String[0]));
        }
        if (!this.getRectorateSubmissionBatchSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.AdministrativeOffice.cannot.delete", (String[])new String[0]));
        }
        if (!this.getEventsSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.AdministrativeOffice.cannot.delete", (String[])new String[0]));
        }
        if (!this.getEventReportQueueJobSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.AdministrativeOffice.cannot.delete", (String[])new String[0]));
        }
        if (!this.getAcademicAuthorizationGroupSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.administrativeOffice.cannotDeleteAdministrativeOfficeUsedInAccessControl", (String[])new String[0]));
        }
    }

    @Deprecated
    public boolean isDegree() {
        return this.getAdministrativeOfficeType().equals((Object)AdministrativeOfficeType.DEGREE);
    }

    @Deprecated
    public boolean isMasterDegree() {
        return this.getAdministrativeOfficeType() == AdministrativeOfficeType.MASTER_DEGREE;
    }

    public RectorateSubmissionBatch getCurrentRectorateSubmissionBatch() {
        DateTime last = null;
        RectorateSubmissionBatch current = null;
        for (RectorateSubmissionBatch bag : this.getRectorateSubmissionBatchSet()) {
            if (!RectorateSubmissionState.UNSENT.equals((Object)bag.getState()) || last != null && !bag.getCreation().isAfter((ReadableInstant)last)) continue;
            last = bag.getCreation();
            current = bag;
        }
        return current;
    }

    public boolean getHasAnyPhdProgram() {
        for (AcademicProgram program : this.getManagedAcademicProgramSet()) {
            if (!(program instanceof PhdProgram)) continue;
            return true;
        }
        return false;
    }
}

