/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.serviceRequests;

import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.PhdRegistryDiplomaRequestEvent_Base;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.serviceRequests.documentRequests.PhdRegistryDiplomaRequest;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.util.LabelFormatter;

public class PhdRegistryDiplomaRequestEvent
extends PhdRegistryDiplomaRequestEvent_Base {
    protected PhdRegistryDiplomaRequestEvent() {
    }

    protected PhdRegistryDiplomaRequestEvent(AdministrativeOffice administrativeOffice, EventType eventType, Person person, AcademicServiceRequest academicServiceRequest) {
        this();
        if (!academicServiceRequest.isRegistryDiploma()) {
            throw new DomainException("error.PhdRegistryDiplomaRequestEvent.request.is.not.registry.diploma", new String[0]);
        }
        if (!EventType.BOLONHA_PHD_REGISTRY_DIPLOMA_REQUEST.equals((Object)eventType)) {
            throw new DomainException("error.PhdRegistryDiplomaRequestEvent.eventType.is.not.phd.registry.diploma", new String[0]);
        }
        super.init(administrativeOffice, eventType, person, academicServiceRequest);
    }

    public static final PhdRegistryDiplomaRequestEvent create(AdministrativeOffice administrativeOffice, Person person, PhdRegistryDiplomaRequest phdRegistryDiplomaRequest) {
        return new PhdRegistryDiplomaRequestEvent(administrativeOffice, phdRegistryDiplomaRequest.getEventType(), person, (AcademicServiceRequest)((Object)phdRegistryDiplomaRequest));
    }

    public LabelFormatter getDescription() {
        LabelFormatter result = super.getDescription();
        this.fillDescription(result);
        return result;
    }

    public final LabelFormatter getDescriptionForEntryType(EntryType entryType) {
        LabelFormatter labelFormatter = new LabelFormatter();
        labelFormatter.appendLabel(entryType.name(), "resources.EnumerationResources");
        this.fillDescription(labelFormatter);
        return labelFormatter;
    }

    private void fillDescription(LabelFormatter labelFormatter) {
        labelFormatter.appendLabel(" (");
        PhdRegistryDiplomaRequest request = (PhdRegistryDiplomaRequest)((Object)this.getAcademicServiceRequest());
        labelFormatter.appendLabel(request.getPhdIndividualProgramProcess().getPhdProgram().getName().getPreferedContent());
        labelFormatter.appendLabel(")");
    }
}

