/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.gratuity;

import java.math.BigDecimal;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.EventState;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEvent;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityExemptionJustificationType;
import org.fenixedu.academic.domain.accounting.events.gratuity.PercentageGratuityExemption_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.RolePredicates;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;
import org.joda.time.YearMonthDay;

public class PercentageGratuityExemption
extends PercentageGratuityExemption_Base {
    public PercentageGratuityExemption(Person responsible, GratuityEvent gratuityEvent, GratuityExemptionJustificationType gratuityExemptionJustificationType, String reason, YearMonthDay dispatchDate, BigDecimal percentage) {
        this.init(responsible, gratuityExemptionJustificationType, reason, dispatchDate, gratuityEvent, percentage);
    }

    public PercentageGratuityExemption(GratuityEvent gratuityEvent, GratuityExemptionJustificationType gratuityExemptionJustificationType, String reason, YearMonthDay dispatchDate, BigDecimal percentage) {
        this(null, gratuityEvent, gratuityExemptionJustificationType, reason, dispatchDate, percentage);
    }

    protected void init(Person responsible, GratuityExemptionJustificationType exemptionType, String reason, YearMonthDay dispatchDate, GratuityEvent gratuityEvent, BigDecimal percentage) {
        this.checkParameters(percentage);
        super.setPercentage(percentage);
        super.init(responsible, gratuityEvent, exemptionType, reason, dispatchDate);
    }

    private void checkParameters(BigDecimal percentage) {
        if (percentage == null) {
            throw new DomainException("error.accounting.events.gratuity.PercentageGratuityExemption.percentage.cannot.be.null", new String[0]);
        }
    }

    public void setPercentage(BigDecimal percentage) {
        AccessControl.check(this, RolePredicates.MANAGER_PREDICATE);
        super.setPercentage(percentage);
        DateTime now = new DateTime();
        this.getGratuityEvent().forceChangeState(EventState.OPEN, now);
        this.getGratuityEvent().recalculateState(now);
    }

    public BigDecimal calculateDiscountPercentage(Money amount) {
        return this.getPercentage();
    }

    public String getFormattedPercentage() {
        return this.getPercentage().multiply(BigDecimal.valueOf(100L)).toPlainString();
    }

    public boolean isPercentageExemption() {
        return true;
    }
}

