/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.FenixEduAcademicConfiguration;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.CreditNote;
import org.fenixedu.academic.domain.accounting.Entry;
import org.fenixedu.academic.domain.accounting.PaymentMode;
import org.fenixedu.academic.domain.accounting.ReceiptPrintVersion;
import org.fenixedu.academic.domain.accounting.ReceiptState;
import org.fenixedu.academic.domain.accounting.Receipt_Base;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.dto.accounting.CreditNoteEntryDTO;
import org.fenixedu.academic.predicate.AcademicPredicates;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.RolePredicates;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.YearMonthDay;

public class Receipt
extends Receipt_Base {
    public static final String GENERIC_CONTRIBUTOR_PARTY_NUMBER = " ";
    private static final Map<Integer, String> NUMBER_SERIES_BY_YEAR;
    public static Comparator<Receipt> COMPARATOR_BY_NUMBER;

    protected Receipt() {
    }

    public static Receipt create(Person responsible, Person person, String contributorName, String contributorNumber, String contributorAddress, Integer year, List<Entry> entries) {
        Receipt result = new Receipt();
        result.init(responsible, person, contributorName, contributorNumber, contributorAddress, year, entries, NUMBER_SERIES_BY_YEAR.get(year));
        return result;
    }

    private void init(Person responsible, Person person, String contributorName, String contributorNumber, String contributorAddress, Integer year, List<Entry> entries, String numberSeries) {
        if (person == null) {
            throw new DomainException("error.accouting.Receipt.person.cannot.be.null", new String[0]);
        }
        if (StringUtils.isEmpty((String)contributorName)) {
            throw new DomainException("error.accounting.Receipt.contributor.or.contributorName.must.be.not.null", new String[0]);
        }
        if (year == null) {
            throw new DomainException("error.accounting.Receipt.year.cannot.be.null", new String[0]);
        }
        if (entries == null) {
            throw new DomainException("error.accounting.Receipt.entries.cannot.be.null", new String[0]);
        }
        if (entries.isEmpty()) {
            throw new DomainException("error.accounting.Receipt.entries.cannot.be.empty", new String[0]);
        }
        this.checkRulesToCreate(person, year, entries);
        super.setNumber(this.generateReceiptNumber(year));
        super.setRootDomainObject(Bennu.getInstance());
        super.setYear(year);
        super.setNumberSeries(numberSeries);
        super.setPerson(person);
        this.setContributorName(contributorName);
        this.setContributorNumber(contributorNumber);
        this.setContributorAddress(contributorAddress);
        super.setWhenCreated(new DateTime());
        this.changeState(responsible, ReceiptState.ACTIVE);
        super.setReceiptDate(new YearMonthDay().getYear() != year.intValue() ? this.getLastDayOfYear(year) : new YearMonthDay());
        for (Entry entry : entries) {
            entry.setActiveReceipt(this);
        }
    }

    private YearMonthDay getLastDayOfYear(Integer year) {
        return new YearMonthDay(year.intValue(), 12, 31);
    }

    private void checkRulesToCreate(Person person, Integer year, List<Entry> entries) {
        YearMonthDay today = new YearMonthDay();
        if (year < FenixEduAcademicConfiguration.getConfiguration().getReceiptMinYearToCreate()) {
            throw new DomainException("error.accounting.Receipt.invalid.receipt.year", FenixEduAcademicConfiguration.getConfiguration().getReceiptMinYearToCreate().toString());
        }
        for (Entry entry : entries) {
            if (entry.getWhenRegistered().getYear() != year.intValue()) {
                throw new DomainException("error.accounting.Receipt.entries.must.belong.to.receipt.civil.year", new String[0]);
            }
            if (entry.getAccountingTransaction().isSourceAccountFromParty((Party)((Object)person))) continue;
            throw new DomainException("error.accounting.Receipt.entries.must.belong.to.person", new String[0]);
        }
    }

    private void changeState(Person responsible, ReceiptState state) {
        this.markChange(responsible);
        super.setState(state);
    }

    private void markChange(Person responsible) {
        super.setWhenUpdated(new DateTime());
        super.setResponsible(responsible);
    }

    public void addEntries(Entry entries) {
        throw new DomainException("error.accounting.Receipt.cannot.add.new.entries", new String[0]);
    }

    public Set<Entry> getEntriesSet() {
        return Collections.unmodifiableSet(super.getEntriesSet());
    }

    public void removeEntries(Entry entries) {
        throw new DomainException("error.accounting.Receipt.cannot.remove.entries", new String[0]);
    }

    public void setNumber(Integer number) {
        throw new DomainException("error.accounting.Receipt.cannot.modify.number", new String[0]);
    }

    public void removeReceiptsVersions(ReceiptPrintVersion receiptsVersions) {
        throw new DomainException("error.accounting.Receipt.cannot.remove.receiptVersions", new String[0]);
    }

    public void setPerson(Person person) {
        throw new DomainException("error.accounting.Receipt.cannot.modify.person", new String[0]);
    }

    public void setYear(Integer year) {
        throw new DomainException("error.accounting.Receipt.cannot.modify.year", new String[0]);
    }

    public void setWhenCreated(DateTime whenCreated) {
        throw new DomainException("error.accounting.Receipt.cannot.modify.creation.date", new String[0]);
    }

    public void addCreditNotes(CreditNote creditNote) {
        throw new DomainException("error.accounting.Receipt.cannot.add.creditNote", new String[0]);
    }

    public void setResponsible(Person responsible) {
        throw new DomainException("error.accounting.Receipt.cannot.modify.responsible", new String[0]);
    }

    public Set<CreditNote> getCreditNotesSet() {
        return Collections.unmodifiableSet(super.getCreditNotesSet());
    }

    public void removeCreditNotes(CreditNote creditNote) {
        throw new DomainException("error.accounting.Receipt.cannot.remove.creditNote", new String[0]);
    }

    public void setState(ReceiptState state) {
        throw new DomainException("error.accounting.Receipt.cannot.modify.state", new String[0]);
    }

    public void setOwnerUnit(Unit ownerUnit) {
        throw new UnsupportedOperationException();
    }

    private Integer generateReceiptNumber(int year) {
        List<Receipt> receipts = Receipt.getReceiptsFor(year);
        return receipts.isEmpty() ? 1 : Collections.max(receipts, COMPARATOR_BY_NUMBER).getReceiptNumber() + 1;
    }

    public static List<Receipt> getReceiptsFor(int year) {
        ArrayList<Receipt> result = new ArrayList<Receipt>();
        for (Receipt receipt : Bennu.getInstance().getReceiptsSet()) {
            if (receipt.getYear() != year) continue;
            result.add(receipt);
        }
        return result;
    }

    public void registerReceiptPrint(Person person) {
        if (this.getState().isToRegisterPrint()) {
            new ReceiptPrintVersion(this, person);
        }
    }

    public ReceiptPrintVersion getMostRecentReceiptPrintVersion() {
        ReceiptPrintVersion result = null;
        for (ReceiptPrintVersion receiptVersion : this.getReceiptsVersionsSet()) {
            if (result != null && !receiptVersion.getWhenCreated().isAfter((ReadableInstant)result.getWhenCreated())) continue;
            result = receiptVersion;
        }
        return result;
    }

    public Money getTotalAmount() {
        Money result = Money.ZERO;
        for (Entry entry : this.getEntriesSet()) {
            result = result.add(entry.getOriginalAmount());
        }
        return result;
    }

    public boolean isFromAdministrativeOffice(AdministrativeOffice administrativeOffice) {
        for (Entry entry : this.getEntriesSet()) {
            if (entry.getAccountingTransaction().getEvent().isPayableOnAdministrativeOffice(administrativeOffice)) continue;
            return false;
        }
        return true;
    }

    public CreditNote createCreditNote(Person responsible, PaymentMode paymentMode, List<CreditNoteEntryDTO> creditNoteEntryDTOs) {
        return CreditNote.create(this, responsible, creditNoteEntryDTOs);
    }

    public void annul(Person responsible) {
        this.checkRulesToAnnul();
        this.changeState(responsible, ReceiptState.ANNULLED);
    }

    private void checkRulesToAnnul() {
        if (this.hasAnyActiveCreditNotes()) {
            throw new DomainException("error.accounting.Receipt.cannot.annul.receipts.with.credit.notes", new String[0]);
        }
    }

    private boolean hasAnyActiveCreditNotes() {
        Set<CreditNote> creditNotes = this.getCreditNotesSet();
        for (CreditNote creditNote : creditNotes) {
            if (creditNote.isAnnulled()) continue;
            return true;
        }
        return false;
    }

    public boolean isActive() {
        return this.getState() == ReceiptState.ACTIVE;
    }

    public boolean isAnnulled() {
        return this.getState() == ReceiptState.ANNULLED;
    }

    public Set<Entry> getReimbursableEntries() {
        HashSet<Entry> result = new HashSet<Entry>();
        for (Entry entry : this.getEntriesSet()) {
            if (!entry.isReimbursementAppliable()) continue;
            result.add(entry);
        }
        return result;
    }

    public void deleteReceiptPrintVersions() {
        AccessControl.check(this, RolePredicates.MANAGER_PREDICATE);
        while (!this.getReceiptsVersionsSet().isEmpty()) {
            ((ReceiptPrintVersion)((Object)this.getReceiptsVersionsSet().iterator().next())).delete();
        }
    }

    public void delete() {
        AccessControl.check(this, RolePredicates.MANAGER_PREDICATE);
        DomainException.throwWhenDeleteBlocked(this.getDeletionBlockers());
        this.deleteReceiptPrintVersions();
        super.setResponsible(null);
        super.getEntriesSet().clear();
        super.setPerson(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (!this.getCreditNotesSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.accounting.Receipt.cannot.be.deleted", (String[])new String[0]));
        }
    }

    public boolean isNumberSeriesDefined() {
        return !StringUtils.isEmpty((String)this.getNumberSeries());
    }

    public String getNumberWithSeries() {
        return !this.isNumberSeriesDefined() ? String.valueOf(super.getNumber()) : super.getNumber() + this.getNumberSeries();
    }

    @Deprecated
    public Integer getNumber() {
        throw new DomainException("error.org.fenixedu.academic.domain.accounting.Receipt.use.getNumberWithSeries.instead", new String[0]);
    }

    private Integer getReceiptNumber() {
        return super.getNumber();
    }

    public List<CreditNote> getEmittedCreditNotes() {
        ArrayList<CreditNote> result = new ArrayList<CreditNote>();
        for (CreditNote creditNote : super.getCreditNotesSet()) {
            if (!creditNote.isEmitted()) continue;
            result.add(creditNote);
        }
        return result;
    }

    public void edit(Person responsible, String contributorName, String contributorNumber, String contributorAddress) {
        AccessControl.check(this, AcademicPredicates.MANAGE_STUDENT_PAYMENTS);
        this.markChange(responsible);
        if (StringUtils.isEmpty((String)contributorName)) {
            throw new DomainException("error.accounting.Receipt.contributor.or.contributorName.must.be.not.null", new String[0]);
        }
        this.setContributorName(contributorName);
        this.setContributorNumber(contributorNumber);
        this.setContributorAddress(contributorAddress);
    }

    public void changeStateAndEntries(ReceiptState state, Set<Entry> newEntries) {
        AccessControl.check(this, RolePredicates.MANAGER_PREDICATE);
        super.setState(state);
        super.getEntriesSet().clear();
        for (Entry entry : newEntries) {
            entry.setActiveReceipt(this);
        }
    }

    public boolean isSecondPrintVersion() {
        return this.getReceiptsVersionsSet().size() >= 1;
    }

    public static Receipt readByYearAndNumber(Integer year, Integer number, String series) {
        for (Receipt receipt : Receipt.getReceiptsFor(year)) {
            if (!receipt.getReceiptNumber().equals(number)) continue;
            if (series == null && receipt.getNumberSeries() == null) {
                return receipt;
            }
            if (series == null || receipt.getNumberSeries() == null || !series.equals(receipt.getNumberSeries())) continue;
            return receipt;
        }
        return null;
    }

    static {
        String[] parts;
        NUMBER_SERIES_BY_YEAR = new HashMap<Integer, String>();
        for (String part : parts = FenixEduAcademicConfiguration.getConfiguration().getReceiptNumberSeriesForYears().split(",")) {
            if (StringUtils.isEmpty((String)part)) continue;
            String[] yearAndSeries = part.split(":");
            NUMBER_SERIES_BY_YEAR.put(Integer.valueOf(yearAndSeries[0]), yearAndSeries[1]);
        }
        COMPARATOR_BY_NUMBER = new Comparator<Receipt>(){

            @Override
            public int compare(Receipt leftReceipt, Receipt rightReceipt) {
                int comparationResult = leftReceipt.getReceiptNumber().compareTo(rightReceipt.getReceiptNumber());
                return comparationResult == 0 ? leftReceipt.getExternalId().compareTo(rightReceipt.getExternalId()) : comparationResult;
            }
        };
    }
}

