/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accessControl;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.CurricularYear;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accessControl.FenixGroup;
import org.fenixedu.academic.domain.accessControl.PersistentStudentGroup;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.bennu.core.annotation.GroupArgument;
import org.fenixedu.bennu.core.annotation.GroupOperator;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.groups.PersistentGroup;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.DateTime;

@GroupOperator(value="student")
public class StudentGroup
extends FenixGroup {
    private static final long serialVersionUID = -3059659317143315425L;
    @GroupArgument
    private DegreeType degreeType;
    @GroupArgument
    private Degree degree;
    @GroupArgument
    private CycleType cycle;
    @GroupArgument
    private Space campus;
    @GroupArgument
    private ExecutionCourse executionCourse;
    @GroupArgument
    private CurricularYear curricularYear;
    @GroupArgument
    private ExecutionYear executionYear;

    private StudentGroup() {
    }

    private StudentGroup(DegreeType degreeType, Degree degree, CycleType cycle, Space campus, ExecutionCourse executionCourse, CurricularYear curricularYear, ExecutionYear executionYear) {
        this.degreeType = degreeType;
        this.degree = degree;
        this.cycle = cycle;
        this.campus = campus;
        this.executionCourse = executionCourse;
        this.curricularYear = curricularYear;
        this.executionYear = executionYear;
    }

    public static StudentGroup get() {
        return new StudentGroup(null, null, null, null, null, null, null);
    }

    public static StudentGroup get(DegreeType degreeType) {
        return new StudentGroup(degreeType, null, null, null, null, null, null);
    }

    public static StudentGroup get(Degree degree, CycleType cycle) {
        return new StudentGroup(null, degree, cycle, null, null, null, null);
    }

    public static StudentGroup get(CycleType cycle) {
        return new StudentGroup(null, null, cycle, null, null, null, null);
    }

    public static StudentGroup get(CycleType cycle, ExecutionYear executionYear) {
        return new StudentGroup(null, null, cycle, null, null, null, executionYear);
    }

    public static StudentGroup get(Space campus) {
        return new StudentGroup(null, null, null, campus, null, null, null);
    }

    public static StudentGroup get(ExecutionCourse executionCourse) {
        return new StudentGroup(null, null, null, null, executionCourse, null, null);
    }

    public static StudentGroup get(Degree degree, CurricularYear curricularYear, ExecutionYear executionYear) {
        return new StudentGroup(null, degree, null, null, null, curricularYear, executionYear);
    }

    public static StudentGroup get(DegreeType degreeType, Degree degree, CycleType cycle, Space campus, ExecutionCourse executionCourse, CurricularYear curricularYear, ExecutionYear executionYear) {
        return new StudentGroup(degreeType, degree, cycle, campus, executionCourse, curricularYear, executionYear);
    }

    @Override
    public String[] getPresentationNameKeyArgs() {
        ArrayList<String> parts = new ArrayList<String>();
        String connector = "";
        if (this.degreeType != null) {
            parts.add(this.degreeType.getName().getContent());
        }
        if (this.degree != null) {
            parts.add(this.degree.getPresentationName());
        }
        if (this.executionCourse != null) {
            parts.add(this.executionCourse.getName() + " (" + this.executionCourse.getSigla() + ") " + this.executionCourse.getAcademicInterval().getPathName());
        }
        if (this.cycle != null) {
            parts.add(this.cycle.getDescription());
        }
        if (this.curricularYear != null) {
            parts.add(this.curricularYear.getYear().toString());
        }
        if (this.executionYear != null) {
            parts.add(this.executionYear.getName());
        }
        if (this.campus != null) {
            parts.add(this.campus.getName());
        }
        if (!parts.isEmpty()) {
            connector = parts.size() == 1 && this.campus != null ? BundleUtil.getString((String)"resources.GroupNameResources", (String)"label.name.connector.campus", (String[])new String[0]) : BundleUtil.getString((String)"resources.GroupNameResources", (String)"label.name.connector.default", (String[])new String[0]);
        }
        return new String[]{connector, Joiner.on((String)", ").join(parts)};
    }

    private ExecutionYear getExecutionYear() {
        return this.executionYear != null ? this.executionYear : ExecutionYear.readCurrentExecutionYear();
    }

    public Set<User> getMembers() {
        if (this.executionCourse != null) {
            if (this.degree == null && this.degreeType == null && this.campus == null) {
                return StudentGroup.registrationsToUsers(StudentGroup.getCourseBasedRegistrations(this.executionCourse));
            }
            return StudentGroup.registrationsToUsers((Set<Registration>)Sets.intersection(StudentGroup.getCourseBasedRegistrations(this.executionCourse), this.getDegreeBasedRegistrations()));
        }
        if (this.campus != null) {
            return StudentGroup.registrationsToUsers(this.getCampusBasedRegistrations());
        }
        return StudentGroup.registrationsToUsers(this.getDegreeBasedRegistrations());
    }

    private Set<Registration> getDegreeBasedRegistrations() {
        FluentIterable<Registration> registrations = this.degreeType != null ? StudentGroup.getRegistrations(this.degreeType) : (this.degree != null ? StudentGroup.getRegistrations(this.degree) : StudentGroup.getRegistrations());
        registrations = this.filterDegreeType(registrations, this.degreeType);
        registrations = this.filterDegree(registrations, this.degree);
        registrations = StudentGroup.filterCycle(registrations, this.cycle, this.getExecutionYear());
        registrations = StudentGroup.filterCurricularYear(registrations, this.curricularYear, this.getExecutionYear());
        return registrations.toSet();
    }

    private FluentIterable<Registration> filterDegreeType(FluentIterable<Registration> registrations, final DegreeType degreeType) {
        if (degreeType == null) {
            return registrations;
        }
        return registrations.filter((Predicate)new Predicate<Registration>(){

            public boolean apply(Registration registration) {
                return registration.getDegreeType().equals(degreeType);
            }
        });
    }

    private FluentIterable<Registration> filterDegree(FluentIterable<Registration> registrations, final Degree degree) {
        if (degree == null) {
            return registrations;
        }
        return registrations.filter((Predicate)new Predicate<Registration>(){

            public boolean apply(Registration registration) {
                if (registration.getActiveStudentCurricularPlan() != null) {
                    return registration.getActiveStudentCurricularPlan().getDegree().equals(degree);
                }
                return false;
            }
        });
    }

    private static FluentIterable<Registration> filterCycle(FluentIterable<Registration> registrations, CycleType cycleType, ExecutionYear executionYear) {
        if (cycleType == null) {
            return registrations;
        }
        return registrations.filter(StudentGroup.getPredicateForActiveRegistrationsThatHaveAtLeastOneEnrolment(cycleType, executionYear));
    }

    private static Predicate<Registration> getPredicateForActiveRegistrationsThatHaveAtLeastOneEnrolment(final CycleType cycleType, final ExecutionYear executionYear) {
        return new Predicate<Registration>(){

            public boolean apply(Registration registration) {
                CycleCurriculumGroup cycleCurriculumGroup;
                StudentCurricularPlan studentCurricularPlan = registration.getStudentCurricularPlan(executionYear);
                return studentCurricularPlan != null && !studentCurricularPlan.hasConcludedCycle(cycleType, executionYear) && (cycleCurriculumGroup = studentCurricularPlan.getCycle(cycleType)) != null && cycleCurriculumGroup.isConcluded(executionYear).equals((Object)CurriculumModule.ConclusionValue.NOT_CONCLUDED) && cycleCurriculumGroup.hasAnyEnrolments();
            }
        };
    }

    private static FluentIterable<Registration> filterCurricularYear(FluentIterable<Registration> registrations, final CurricularYear curricularYear, final ExecutionYear executionYear) {
        if (curricularYear == null) {
            return registrations;
        }
        return registrations.filter((Predicate)new Predicate<Registration>(){

            public boolean apply(Registration registration) {
                return registration.getCurricularYear(executionYear) == curricularYear.getYear().intValue();
            }
        });
    }

    private static FluentIterable<Registration> getRegistrations(DegreeType type) {
        HashSet registrations = new HashSet();
        for (User user : RoleType.STUDENT.actualGroup().getMembers()) {
            user.getPerson().getStudentsSet().forEach(reg -> {
                if (reg.getDegreeType() == type && reg.isActive()) {
                    registrations.add(reg);
                }
            });
        }
        return FluentIterable.from(registrations);
    }

    private static FluentIterable<Registration> getRegistrations(Degree degree) {
        HashSet<Registration> registrations = new HashSet<Registration>();
        for (DegreeCurricularPlan degreeCurricularPlan : degree.getActiveDegreeCurricularPlans()) {
            for (StudentCurricularPlan studentCurricularPlan : degreeCurricularPlan.getStudentCurricularPlansSet()) {
                if (!studentCurricularPlan.isActive()) continue;
                registrations.add(studentCurricularPlan.getRegistration());
            }
        }
        return FluentIterable.from(registrations);
    }

    private static FluentIterable<Registration> getRegistrations() {
        HashSet<Registration> registrations = new HashSet<Registration>();
        for (User user : RoleType.STUDENT.actualGroup().getMembers()) {
            registrations.addAll(user.getPerson().getStudent().getActiveRegistrations());
        }
        return FluentIterable.from(registrations);
    }

    private static Set<User> registrationsToUsers(Set<Registration> registrations) {
        HashSet<User> users = new HashSet<User>();
        for (Registration registration : registrations) {
            User user = registration.getPerson().getUser();
            if (user == null) continue;
            users.add(user);
        }
        return users;
    }

    private static Set<Registration> getCourseBasedRegistrations(ExecutionCourse executionCourse) {
        HashSet<Registration> registrations = new HashSet<Registration>();
        for (Attends attends : executionCourse.getAttendsSet()) {
            registrations.add(attends.getRegistration());
        }
        return registrations;
    }

    private Set<Registration> getCampusBasedRegistrations() {
        HashSet<Registration> registrations = new HashSet<Registration>();
        for (ExecutionDegree executionDegree : ExecutionYear.readCurrentExecutionYear().getExecutionDegreesSet()) {
            if (!executionDegree.getCampus().equals((Object)this.campus)) continue;
            DegreeCurricularPlan degreeCurricularPlan = executionDegree.getDegreeCurricularPlan();
            for (StudentCurricularPlan studentCurricularPlan : degreeCurricularPlan.getStudentCurricularPlansSet()) {
                Registration registration = studentCurricularPlan.getRegistration();
                if (registration == null || !registration.isActive()) continue;
                registrations.add(registration);
            }
        }
        return registrations;
    }

    public Set<User> getMembers(DateTime when) {
        return this.getMembers();
    }

    public boolean isMember(User user) {
        if (user == null) {
            return false;
        }
        if (user.getPerson().getStudent() == null) {
            return false;
        }
        for (Registration registration : user.getPerson().getStudent().getRegistrationsSet()) {
            if (this.executionCourse != null && registration.getAttendingExecutionCoursesFor().contains((Object)this.executionCourse)) {
                return true;
            }
            if (!registration.isActive() || this.degreeType != null && registration.getDegree().getDegreeType() != this.degreeType || this.degree != null && registration.getActiveStudentCurricularPlan() != null && !registration.getActiveStudentCurricularPlan().getDegree().equals(this.degree) || this.cycle != null && !StudentGroup.getPredicateForActiveRegistrationsThatHaveAtLeastOneEnrolment(this.cycle, this.executionYear).apply((Object)registration) || this.campus != null && registration.getCampus() != this.campus || this.executionCourse != null && !registration.getAttendingExecutionCoursesFor().contains((Object)this.executionCourse) || this.curricularYear != null && registration.getCurricularYear() != this.curricularYear.getYear().intValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isMember(User user, DateTime when) {
        return this.isMember(user);
    }

    public PersistentGroup toPersistentGroup() {
        return PersistentStudentGroup.getInstance(this.degreeType, this.degree, this.cycle, this.campus, this.executionCourse, this.curricularYear, this.executionYear);
    }

    public boolean equals(Object object) {
        if (object instanceof StudentGroup) {
            StudentGroup other = (StudentGroup)((Object)object);
            return Objects.equal((Object)this.degreeType, (Object)other.degreeType) && Objects.equal((Object)this.degree, (Object)other.degree) && Objects.equal((Object)((Object)this.cycle), (Object)((Object)other.cycle)) && Objects.equal((Object)this.campus, (Object)other.campus) && Objects.equal((Object)((Object)this.executionCourse), (Object)((Object)other.executionCourse)) && Objects.equal((Object)this.curricularYear, (Object)other.curricularYear) && Objects.equal((Object)this.executionYear, (Object)other.executionYear);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.degreeType, this.degree, this.cycle, this.campus, this.executionCourse, this.curricularYear, this.executionYear});
    }
}

