/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.WrittenEvaluation;
import org.fenixedu.academic.domain.WrittenEvaluationEnrolment_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.spaces.domain.Space;

public class WrittenEvaluationEnrolment
extends WrittenEvaluationEnrolment_Base {
    public WrittenEvaluationEnrolment() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public WrittenEvaluationEnrolment(WrittenEvaluation writtenEvaluation, Registration registration) {
        this();
        this.setWrittenEvaluation(writtenEvaluation);
        this.setStudent(registration);
    }

    public WrittenEvaluationEnrolment(WrittenEvaluation writtenEvaluation, Registration registration, Space room) {
        this();
        this.setWrittenEvaluation(writtenEvaluation);
        this.setStudent(registration);
        this.setRoom(room);
    }

    public void delete() {
        if (this.getRoom() != null) {
            throw new DomainException("error.notAuthorizedUnEnrollment", new String[0]);
        }
        this.setWrittenEvaluation(null);
        this.setStudent(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public boolean isForExecutionPeriod(ExecutionSemester executionSemester) {
        for (ExecutionCourse executionCourse : this.getWrittenEvaluation().getAssociatedExecutionCoursesSet()) {
            if (executionCourse.getExecutionPeriod() != executionSemester) continue;
            return true;
        }
        return false;
    }
}

