/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.ProjectSubmissionFile_Base;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.util.FileUtils;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.io.domain.GenericFile;
import org.fenixedu.bennu.io.servlets.FileDownloadServlet;

public class ProjectSubmissionFile
extends ProjectSubmissionFile_Base {
    public ProjectSubmissionFile(String filename, String displayName, byte[] content) {
        this.init(displayName, filename, content);
    }

    public void setFilename(String filename) {
        super.setFilename(FileUtils.cleanupUserInputFilename(filename));
    }

    public void setDisplayName(String displayName) {
        super.setDisplayName(FileUtils.cleanupUserInputFileDisplayName(displayName));
    }

    public boolean isAccessible(User user) {
        ExecutionCourse executionCourse = this.getProjectSubmission().getAttends().getExecutionCourse();
        if (user != null && user.getPerson().getTeacher() != null) {
            Teacher teacher = user.getPerson().getTeacher();
            Department department = teacher.getDepartment();
            if (department != null && this.getProjectSubmission().getProject().getDeparmentsSet().contains((Object)department)) {
                return true;
            }
            for (Professorship professorship : teacher.getProfessorshipsSet()) {
                if (!professorship.getExecutionCourse().equals((Object)executionCourse)) continue;
                return true;
            }
        }
        if (user != null && user.getPerson().getStudent() != null) {
            for (Attends attends : this.getProjectSubmission().getStudentGroup().getAttendsSet()) {
                if (!attends.getRegistration().getStudent().equals((Object)user.getPerson().getStudent())) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public String getDownloadUrl() {
        return FileDownloadServlet.getDownloadUrl((GenericFile)this);
    }

    public void delete() {
        this.setProjectSubmission(null);
        super.delete();
    }
}

