/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.util.EvaluationType;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.LocalizedString;

public enum GradeScale {
    TYPE20(true, new GradeScaleLogic(){

        @Override
        public boolean checkFinal(Grade grade) {
            String value = grade.getValue();
            if (value.equals(GradeScale.NA) || value.equals(GradeScale.RE)) {
                return true;
            }
            try {
                int intValue = Integer.parseInt(value);
                return intValue >= 10 && intValue <= 20;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        @Override
        public boolean checkNotFinal(Grade grade) {
            String value = grade.getValue();
            if (value.equals(GradeScale.NA) || value.equals(GradeScale.RE)) {
                return true;
            }
            try {
                double doubleValue = Double.parseDouble(value);
                return doubleValue >= 0.0 && doubleValue <= 20.0;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        @Override
        public String qualify(Grade grade) {
            if (grade.getGradeScale() != TYPE20) {
                return "";
            }
            try {
                int intValue = Integer.parseInt(grade.getValue());
                if (18 <= intValue && intValue <= 20) {
                    return BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.grade.a", (String[])new String[0]);
                }
                if (16 <= intValue && intValue <= 17) {
                    return BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.grade.b", (String[])new String[0]);
                }
                if (14 <= intValue && intValue <= 15) {
                    return BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.grade.c", (String[])new String[0]);
                }
                if (10 <= intValue && intValue <= 13) {
                    return BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.grade.d", (String[])new String[0]);
                }
                throw new DomainException("GradeScale.unable.to.qualify.given.grade", new String[0]);
            }
            catch (NumberFormatException e) {
                throw new DomainException("GradeScale.unable.to.qualify.given.grade", new String[0]);
            }
        }

        @Override
        public boolean isNotEvaluated(Grade grade) {
            String value = grade.getValue();
            return grade.isEmpty() || value.equals(GradeScale.NA);
        }

        @Override
        public boolean isNotApproved(Grade grade) {
            String value = grade.getValue();
            if (value.equals(GradeScale.RE) || this.isNotEvaluated(grade)) {
                return true;
            }
            try {
                return Integer.parseInt(value) < 10;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        @Override
        public boolean isApproved(Grade grade) {
            String value = grade.getValue();
            if (value.equals(GradeScale.AP)) {
                return true;
            }
            try {
                int intValue = Integer.parseInt(value);
                return 10 <= intValue && intValue <= 20;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        @Override
        public boolean belongsTo(String value) {
            if (value.equals(GradeScale.NA) || value.equals(GradeScale.RE)) {
                return true;
            }
            try {
                double doubleValue = Double.parseDouble(value);
                return doubleValue >= 0.0 && doubleValue <= 20.0;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }),
    TYPE5(true, new GradeScaleLogic(){

        @Override
        public boolean checkFinal(Grade grade) {
            String value = grade.getValue();
            if (value.equals(GradeScale.NA) || value.equals(GradeScale.RE)) {
                return true;
            }
            try {
                int intValue = Integer.parseInt(value);
                return intValue >= 3 && intValue <= 5;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        @Override
        public boolean checkNotFinal(Grade grade) {
            String value = grade.getValue();
            if (value.equals(GradeScale.NA) || value.equals(GradeScale.RE)) {
                return true;
            }
            try {
                double doubleValue = Double.parseDouble(value);
                return doubleValue >= 0.0 && doubleValue <= 20.0;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        @Override
        public String qualify(Grade grade) {
            if (grade.getGradeScale() != TYPE5) {
                return "";
            }
            try {
                int intValue = Integer.parseInt(grade.getValue());
                if (intValue == 5) {
                    return BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.grade.a", (String[])new String[0]);
                }
                if (intValue == 4) {
                    return BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.grade.b", (String[])new String[0]);
                }
                if (intValue == 3) {
                    return BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.grade.c", (String[])new String[0]);
                }
                throw new DomainException("GradeScale.unable.to.qualify.given.grade", new String[0]);
            }
            catch (NumberFormatException e) {
                throw new DomainException("GradeScale.unable.to.qualify.given.grade", new String[0]);
            }
        }

        @Override
        public boolean isNotEvaluated(Grade grade) {
            if (grade.isEmpty()) {
                return true;
            }
            return grade.getValue().equals(GradeScale.NA);
        }

        @Override
        public boolean isNotApproved(Grade grade) {
            String value = grade.getValue();
            if (value.equals(GradeScale.RE) || this.isNotEvaluated(grade)) {
                return true;
            }
            try {
                return Integer.parseInt(value) < 3;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        @Override
        public boolean isApproved(Grade grade) {
            try {
                int intValue = Integer.parseInt(grade.getValue());
                return 3 <= intValue && intValue <= 5;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        @Override
        public boolean belongsTo(String value) {
            if (value.equals(GradeScale.NA) || value.equals(GradeScale.RE)) {
                return true;
            }
            try {
                double doubleValue = Double.parseDouble(value);
                return doubleValue >= 0.0 && doubleValue <= 5.0;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }),
    TYPEAP(true, new GradeScaleLogic(){

        @Override
        public boolean checkFinal(Grade grade) {
            String value = grade.getValue();
            return value.equals(GradeScale.NA) || value.equals(GradeScale.RE) || value.equals(GradeScale.AP);
        }

        @Override
        public boolean checkNotFinal(Grade grade) {
            String value = grade.getValue();
            return value.equals(GradeScale.NA) || value.equals(GradeScale.RE) || value.equals(GradeScale.AP);
        }

        @Override
        public String qualify(Grade grade) {
            if (grade.getGradeScale() != TYPEAP) {
                return "";
            }
            String value = grade.getValue();
            if (value.equals(GradeScale.AP)) {
                return BundleUtil.getString((String)"resources.ApplicationResources", (String)"msg.approved", (String[])new String[0]);
            }
            if (value.equals(GradeScale.RE)) {
                return BundleUtil.getString((String)"resources.ApplicationResources", (String)"msg.notApproved", (String[])new String[0]);
            }
            if (value.equals(GradeScale.NA)) {
                return BundleUtil.getString((String)"resources.ApplicationResources", (String)"msg.notEvaluated", (String[])new String[0]);
            }
            throw new DomainException("GradeScale.unable.to.qualify.given.grade", new String[0]);
        }

        @Override
        public boolean isNotEvaluated(Grade grade) {
            String value = grade.getValue();
            return grade.isEmpty() || value.equals(GradeScale.NA);
        }

        @Override
        public boolean isNotApproved(Grade grade) {
            String value = grade.getValue();
            return value.equals(GradeScale.RE) || this.isNotEvaluated(grade);
        }

        @Override
        public boolean isApproved(Grade grade) {
            String value = grade.getValue();
            return value.equals(GradeScale.AP);
        }

        @Override
        public boolean belongsTo(String value) {
            return value.equals(GradeScale.NA) || value.equals(GradeScale.RE) || value.equals(GradeScale.AP);
        }
    }),
    TYPEAPT(false, new GradeScaleLogic(){

        @Override
        public boolean checkFinal(Grade grade) {
            String value = grade.getValue();
            return value.equals(GradeScale.NA) || value.equals(GradeScale.RE) || value.equals(GradeScale.APT);
        }

        @Override
        public boolean checkNotFinal(Grade grade) {
            String value = grade.getValue();
            return value.equals(GradeScale.NA) || value.equals(GradeScale.RE) || value.equals(GradeScale.APT);
        }

        @Override
        public String qualify(Grade grade) {
            if (grade.getGradeScale() != TYPEAPT) {
                return "";
            }
            String value = grade.getValue();
            if (value.equals(GradeScale.APT)) {
                return BundleUtil.getString((String)"resources.ApplicationResources", (String)"msg.apt", (String[])new String[0]);
            }
            if (value.equals(GradeScale.RE)) {
                return BundleUtil.getString((String)"resources.ApplicationResources", (String)"msg.notApproved", (String[])new String[0]);
            }
            if (value.equals(GradeScale.NA)) {
                return BundleUtil.getString((String)"resources.ApplicationResources", (String)"msg.notEvaluated", (String[])new String[0]);
            }
            throw new DomainException("GradeScale.unable.to.qualify.given.grade", new String[0]);
        }

        @Override
        public boolean isNotEvaluated(Grade grade) {
            String value = grade.getValue();
            return grade.isEmpty() || value.equals(GradeScale.NA);
        }

        @Override
        public boolean isNotApproved(Grade grade) {
            String value = grade.getValue();
            return value.equals(GradeScale.RE) || this.isNotEvaluated(grade);
        }

        @Override
        public boolean isApproved(Grade grade) {
            String value = grade.getValue();
            return value.equals(GradeScale.APT);
        }

        @Override
        public boolean belongsTo(String value) {
            return value.equals(GradeScale.NA) || value.equals(GradeScale.RE) || value.equals(GradeScale.APT);
        }
    }),
    TYPEECTS(false, new GradeScaleLogic(){

        @Override
        public boolean belongsTo(String value) {
            return value.equals(GradeScale.A) || value.equals(GradeScale.B) || value.equals("C") || value.equals("D") || value.equals(GradeScale.E) || value.equals("F") || value.equals(GradeScale.NA);
        }

        @Override
        public boolean checkFinal(Grade grade) {
            return false;
        }

        @Override
        public boolean checkNotFinal(Grade grade) {
            return false;
        }

        @Override
        public boolean isApproved(Grade grade) {
            return !this.isNotEvaluated(grade) && !this.isNotApproved(grade);
        }

        @Override
        public boolean isNotApproved(Grade grade) {
            return grade.getValue().equals("F");
        }

        @Override
        public boolean isNotEvaluated(Grade grade) {
            return grade.getValue().equals(GradeScale.NA);
        }

        @Override
        public String qualify(Grade grade) {
            return null;
        }
    }),
    TYPEQUALITATIVE(true, new GradeScaleLogic(){

        @Override
        public boolean belongsTo(String value) {
            return GradeScale.NA.equals(value) || GradeScale.RE.equals(value) || GradeScale.S.equals(value) || GradeScale.B.equals(value) || GradeScale.MB.equals(value) || GradeScale.E.equals(value);
        }

        @Override
        public boolean checkFinal(Grade grade) {
            return false;
        }

        @Override
        public boolean checkNotFinal(Grade grade) {
            return false;
        }

        @Override
        public boolean isApproved(Grade grade) {
            return !this.isNotEvaluated(grade) && !this.isNotApproved(grade);
        }

        @Override
        public boolean isNotApproved(Grade grade) {
            return GradeScale.RE.equals(grade.getValue());
        }

        @Override
        public boolean isNotEvaluated(Grade grade) {
            return GradeScale.NA.equals(grade.getValue());
        }

        @Override
        public String qualify(Grade grade) {
            return null;
        }
    });

    private boolean isPublic;
    private GradeScaleLogic logic;
    public static final String NA = "NA";
    public static final String RE = "RE";
    public static final String AP = "AP";
    public static final String APT = "APT";
    public static final String I = "I";
    public static final String S = "S";
    public static final String B = "B";
    public static final String MB = "MB";
    public static final String MBDL = "MBDL";
    public static final String BD = "BD";
    public static final String E = "E";
    public static final String R = "R";
    public static final String AD = "AD";
    public static final String ADL = "ADL";
    public static final String A = "A";
    public static final String AMB = "AMB";

    private GradeScale(boolean isPublic, GradeScaleLogic logic) {
        this.setPublic(isPublic);
        this.setLogic(logic);
    }

    public String getName() {
        return this.name();
    }

    public void setLogic(GradeScaleLogic logic) {
        this.logic = logic;
    }

    @Deprecated
    public boolean isValid(String value, EvaluationType evaluationType) {
        try {
            Grade grade = Grade.createGrade(value, this);
            if (grade.isEmpty()) {
                return false;
            }
            if (EvaluationType.FINAL_TYPE.equals(evaluationType)) {
                return this.logic.checkFinal(grade);
            }
            return this.logic.checkNotFinal(grade);
        }
        catch (DomainException de) {
            return false;
        }
    }

    public boolean isNotEvaluated(Grade grade) {
        return this.logic.isNotEvaluated(grade);
    }

    public boolean isNotApproved(Grade grade) {
        return this.logic.isNotApproved(grade);
    }

    public boolean isApproved(Grade grade) {
        return this.logic.isApproved(grade);
    }

    public boolean belongsTo(String grade) {
        return this.logic.belongsTo(grade);
    }

    public boolean belongsTo(Grade grade) {
        return this.logic.belongsTo(grade.getValue());
    }

    public LocalizedString getExtendedValue(Grade grade) {
        return this.logic.getExtendedValue(grade);
    }

    @Deprecated
    public final String getQualifiedName(String value) {
        Grade grade = Grade.createGrade(value, this);
        if (this.logic.isApproved(grade)) {
            return this.logic.qualify(grade);
        }
        throw new DomainException("GradeScale.unable.to.qualify.given.grade", new String[0]);
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public static List<GradeScale> getPublicGradeScales() {
        ArrayList<GradeScale> publicGradeScales = new ArrayList<GradeScale>();
        for (GradeScale gradeScale : GradeScale.values()) {
            if (!gradeScale.isPublic) continue;
            publicGradeScales.add(gradeScale);
        }
        return publicGradeScales;
    }

    public String getDescription() {
        return BundleUtil.getString((String)"resources.EnumerationResources", (String)this.name(), (String[])new String[0]);
    }

    public String getPossibleValueDescription(boolean isFinal) {
        String key = isFinal ? "TYPE.final" : this.name() + ".description";
        return BundleUtil.getString((String)"resources.EnumerationResources", (String)key, (String[])new String[0]);
    }

    public int compareGrades(Grade grade1, Grade grade2) {
        return this.logic.compareGrades(grade1, grade2);
    }

    public static interface GradeScaleLogic {
        @Deprecated
        public boolean checkFinal(Grade var1);

        @Deprecated
        public boolean checkNotFinal(Grade var1);

        @Deprecated
        public String qualify(Grade var1);

        public boolean isNotEvaluated(Grade var1);

        public boolean isNotApproved(Grade var1);

        public boolean isApproved(Grade var1);

        public boolean belongsTo(String var1);

        default public LocalizedString getExtendedValue(Grade grade) {
            return BundleUtil.getLocalizedString((String)"resources.EnumerationResources", (String)(GradeScale.class.getSimpleName() + "." + grade.getValue()), (String[])new String[0]);
        }

        default public int compareGrades(Grade grade1, Grade grade2) {
            if (grade2 == null) {
                return 1;
            }
            boolean isApproved1 = this.isApproved(grade1);
            boolean isApproved2 = this.isApproved(grade2);
            if (isApproved1 && isApproved2) {
                if (grade1.getValue().equals(GradeScale.AP)) {
                    return 1;
                }
                if (grade2.getValue().equals(GradeScale.AP)) {
                    return -1;
                }
                if (grade1.getGradeScale().equals((Object)grade2.getGradeScale())) {
                    return grade1.getValue().compareTo(grade2.getValue());
                }
                throw new DomainException("Grade.unsupported.comparassion.of.grades.of.different.scales", new String[0]);
            }
            if (isApproved1 || grade2.getValue().equals(GradeScale.NA) || grade2.getValue().equals(GradeScale.RE)) {
                return 1;
            }
            if (isApproved2 || grade1.getValue().equals(GradeScale.NA) || grade1.getValue().equals(GradeScale.RE)) {
                return -1;
            }
            return grade1.getValue().compareTo(grade2.getValue());
        }
    }
}

