/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.Evaluation;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.FinalEvaluation_Base;
import org.fenixedu.academic.domain.FinalMark;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.Mark;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.InfoEvaluation;
import org.fenixedu.academic.dto.InfoFinalEvaluation;
import org.fenixedu.academic.util.EvaluationType;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class FinalEvaluation
extends FinalEvaluation_Base {
    public FinalEvaluation() {
        this.setGradeScale(GradeScale.TYPE20);
    }

    public Integer getGradesListVersion() {
        int lastVersion = 0;
        for (Mark mark : this.getMarksSet()) {
            FinalMark finalMark = (FinalMark)((Object)mark);
            if (finalMark.getGradeListVersion() <= lastVersion) continue;
            lastVersion = finalMark.getGradeListVersion();
        }
        if (lastVersion == 99) {
            throw new DomainException("grades list version cannot be higher than 99", new String[0]);
        }
        return ++lastVersion;
    }

    public FinalMark addNewMark(Attends attends, String markValue) {
        if (attends.getMarkByEvaluation((Evaluation)((Object)this)) != null) {
            throw new DomainException("error.Evaluation.attend.already.has.mark.for.evaluation", new String[0]);
        }
        return new FinalMark(attends, this, markValue);
    }

    public EvaluationType getEvaluationType() {
        return EvaluationType.FINAL_TYPE;
    }

    public List<FinalMark> getAlreadySubmitedMarks(ExecutionCourse executionCourse) {
        ArrayList<FinalMark> result = new ArrayList<FinalMark>();
        for (Mark mark : this.getMarksSet()) {
            FinalMark finalMark = (FinalMark)((Object)mark);
            if (!finalMark.getAttend().getExecutionCourse().equals((Object)executionCourse) || finalMark.getGradeListVersion() == 0 || finalMark.getSubmitedMark() == null) continue;
            result.add(finalMark);
        }
        return result;
    }

    public List<Attends> getNotSubmitedMarkAttends(ExecutionCourse executionCourse) {
        ArrayList<Attends> result = new ArrayList<Attends>();
        for (Attends attends : executionCourse.getAttendsSet()) {
            FinalMark mark;
            if (attends.getEnrolment() == null || !attends.getRegistration().getDegreeType().isPreBolonhaDegree() || (mark = this.getFinalMark(attends)) != null && (mark.getGradeListVersion() != 0 || mark.getSubmitedMark() != null)) continue;
            result.add(attends);
        }
        return result;
    }

    private FinalMark getFinalMark(Attends attends) {
        for (Mark mark : attends.getAssociatedMarksSet()) {
            if (!mark.getEvaluation().equals((Object)this)) continue;
            return (FinalMark)((Object)mark);
        }
        return null;
    }

    private void checkRulesToDelete() {
        if (!this.getMarksSet().isEmpty()) {
            throw new DomainException("error.existing.marks", new String[0]);
        }
    }

    public void delete() {
        this.checkRulesToDelete();
        super.delete();
    }

    public boolean isFinal() {
        return true;
    }

    public String getPresentationName() {
        return BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.final.evaluation", (String[])new String[0]);
    }

    public Date getEvaluationDate() {
        return ((ExecutionCourse)((Object)this.getAssociatedExecutionCoursesSet().iterator().next())).getExecutionPeriod().getEndDate();
    }

    public InfoEvaluation newInfoFromDomain() {
        InfoFinalEvaluation infoFinalEvaluation = new InfoFinalEvaluation();
        infoFinalEvaluation.copyFromDomain(this);
        return infoFinalEvaluation;
    }
}

