/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import jvstm.cps.ConsistencyPredicate;
import org.fenixedu.academic.domain.ExecutionInterval_Base;
import org.fenixedu.academic.domain.accounting.PaymentCode;
import org.fenixedu.academic.domain.accounting.PaymentCodeMapping;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.period.CandidacyPeriod;
import org.fenixedu.academic.domain.period.DegreeCandidacyForGraduatedPersonCandidacyPeriod;
import org.fenixedu.academic.domain.period.DegreeChangeCandidacyPeriod;
import org.fenixedu.academic.domain.period.DegreeTransferCandidacyPeriod;
import org.fenixedu.academic.domain.period.MobilityApplicationPeriod;
import org.fenixedu.academic.domain.period.Over23CandidacyPeriod;
import org.fenixedu.academic.domain.period.SecondCycleCandidacyPeriod;
import org.fenixedu.academic.domain.period.StandaloneCandidacyPeriod;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.util.PeriodState;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;

public abstract class ExecutionInterval
extends ExecutionInterval_Base {
    public static final Comparator<ExecutionInterval> COMPARATOR_BY_BEGIN_DATE = new Comparator<ExecutionInterval>(){

        @Override
        public int compare(ExecutionInterval o1, ExecutionInterval o2) {
            return AcademicInterval.COMPARATOR_BY_BEGIN_DATE.compare(o1.getAcademicInterval(), o2.getAcademicInterval());
        }
    };

    protected ExecutionInterval() {
        this.setRootDomainObject(Bennu.getInstance());
        this.setState(PeriodState.NOT_OPEN);
    }

    public void setAcademicInterval(AcademicInterval academicInterval) {
        if (academicInterval == null) {
            throw new DomainException("error.executionInterval.empty.executionInterval", new String[0]);
        }
        super.setAcademicInterval(academicInterval);
    }

    public void setState(PeriodState state) {
        if (state == null) {
            throw new DomainException("error.executionInterval.empty.state", new String[0]);
        }
        super.setState(state);
    }

    @ConsistencyPredicate
    protected boolean checkDateInterval() {
        return this.getBeginDateYearMonthDay() != null && this.getEndDateYearMonthDay() != null && this.getBeginDateYearMonthDay().isBefore((ReadablePartial)this.getEndDateYearMonthDay());
    }

    public List<? extends CandidacyPeriod> getCandidacyPeriods(Class<? extends CandidacyPeriod> clazz) {
        ArrayList<CandidacyPeriod> result = new ArrayList<CandidacyPeriod>();
        for (CandidacyPeriod candidacyPeriod : this.getCandidacyPeriodsSet()) {
            if (!((Object)((Object)candidacyPeriod)).getClass().equals(clazz)) continue;
            result.add(candidacyPeriod);
        }
        return result;
    }

    public boolean hasCandidacyPeriods(Class<? extends CandidacyPeriod> clazz) {
        for (CandidacyPeriod candidacyPeriod : this.getCandidacyPeriodsSet()) {
            if (!((Object)((Object)candidacyPeriod)).getClass().equals(clazz)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public Over23CandidacyPeriod getOver23CandidacyPeriod() {
        List<? extends CandidacyPeriod> candidacyPeriods = this.getCandidacyPeriods(Over23CandidacyPeriod.class);
        return candidacyPeriods.isEmpty() ? null : (Over23CandidacyPeriod)((Object)candidacyPeriods.iterator().next());
    }

    public List<Over23CandidacyPeriod> getOver23CandidacyPeriods() {
        return this.getCandidacyPeriods(Over23CandidacyPeriod.class);
    }

    public boolean hasOver23CandidacyPeriod() {
        return this.hasCandidacyPeriods(Over23CandidacyPeriod.class);
    }

    public List<SecondCycleCandidacyPeriod> getSecondCycleCandidacyPeriods() {
        return this.getCandidacyPeriods(SecondCycleCandidacyPeriod.class);
    }

    public List<MobilityApplicationPeriod> getMobilityApplicationPeriods() {
        return this.getCandidacyPeriods(MobilityApplicationPeriod.class);
    }

    public boolean hasAnySecondCycleCandidacyPeriod() {
        return this.hasCandidacyPeriods(SecondCycleCandidacyPeriod.class);
    }

    public DegreeCandidacyForGraduatedPersonCandidacyPeriod getDegreeCandidacyForGraduatedPersonCandidacyPeriod() {
        List<? extends CandidacyPeriod> candidacyPeriods = this.getCandidacyPeriods(DegreeCandidacyForGraduatedPersonCandidacyPeriod.class);
        return candidacyPeriods.isEmpty() ? null : (DegreeCandidacyForGraduatedPersonCandidacyPeriod)((Object)candidacyPeriods.iterator().next());
    }

    public boolean hasDegreeCandidacyForGraduatedPersonCandidacyPeriod() {
        return this.hasCandidacyPeriods(DegreeCandidacyForGraduatedPersonCandidacyPeriod.class);
    }

    public DegreeChangeCandidacyPeriod getDegreeChangeCandidacyPeriod() {
        List<? extends CandidacyPeriod> candidacyPeriods = this.getCandidacyPeriods(DegreeChangeCandidacyPeriod.class);
        return candidacyPeriods.isEmpty() ? null : (DegreeChangeCandidacyPeriod)((Object)candidacyPeriods.iterator().next());
    }

    public boolean hasDegreeChangeCandidacyPeriod() {
        return this.hasCandidacyPeriods(DegreeChangeCandidacyPeriod.class);
    }

    public DegreeTransferCandidacyPeriod getDegreeTransferCandidacyPeriod() {
        List<? extends CandidacyPeriod> candidacyPeriods = this.getCandidacyPeriods(DegreeTransferCandidacyPeriod.class);
        return candidacyPeriods.isEmpty() ? null : (DegreeTransferCandidacyPeriod)((Object)candidacyPeriods.iterator().next());
    }

    public boolean hasDegreeTransferCandidacyPeriod() {
        return this.hasCandidacyPeriods(DegreeTransferCandidacyPeriod.class);
    }

    public List<StandaloneCandidacyPeriod> getStandaloneCandidacyPeriods() {
        return this.getCandidacyPeriods(StandaloneCandidacyPeriod.class);
    }

    public boolean hasAnyStandaloneCandidacyPeriod() {
        return this.hasCandidacyPeriods(StandaloneCandidacyPeriod.class);
    }

    public PaymentCode findNewCodeInPaymentCodeMapping(PaymentCode oldCode) {
        for (PaymentCodeMapping mapping : this.getPaymentCodeMappingsSet()) {
            if (!mapping.hasOldPaymentCode(oldCode)) continue;
            return mapping.getNewPaymentCode();
        }
        return null;
    }

    public abstract String getQualifiedName();

    public abstract boolean isCurrent();

    public static List<ExecutionInterval> readExecutionIntervalsWithCandidacyPeriod(Class<? extends CandidacyPeriod> clazz) {
        ArrayList<ExecutionInterval> result = new ArrayList<ExecutionInterval>();
        for (ExecutionInterval executionInterval : Bennu.getInstance().getExecutionIntervalsSet()) {
            if (!executionInterval.hasCandidacyPeriods(clazz)) continue;
            result.add(executionInterval);
        }
        return result;
    }

    public static ExecutionInterval getExecutionInterval(String qualifiedName) {
        for (ExecutionInterval interval : Bennu.getInstance().getExecutionIntervalsSet()) {
            if (!interval.getQualifiedName().equals(qualifiedName)) continue;
            return interval;
        }
        return null;
    }

    public static ExecutionInterval getExecutionInterval(AcademicInterval academicInterval) {
        for (ExecutionInterval interval : Bennu.getInstance().getExecutionIntervalsSet()) {
            if (!interval.getAcademicInterval().equals(academicInterval)) continue;
            return interval;
        }
        return null;
    }

    public boolean isAfter(ExecutionInterval input) {
        return this.compareExecutionInterval(input) > 0;
    }

    public boolean isAfterOrEquals(ExecutionInterval input) {
        return this.compareExecutionInterval(input) >= 0;
    }

    public int compareExecutionInterval(ExecutionInterval input) {
        int result = 0;
        if (input == null) {
            result = -1;
        }
        if (result == 0) {
            ExecutionInterval.assertExecutionIntervalType(((Object)((Object)this)).getClass(), input);
            result = COMPARATOR_BY_BEGIN_DATE.compare(this, input);
        }
        return result;
    }

    public static <T extends ExecutionInterval> T assertExecutionIntervalType(Class<T> clazz, ExecutionInterval input) {
        ExecutionInterval result = null;
        if (input != null) {
            if (!clazz.isAssignableFrom(((Object)((Object)input)).getClass())) {
                throw new DomainException("error.ExecutionInterval.unexpected", clazz.getSimpleName(), ((Object)((Object)input)).getClass().getSimpleName());
            }
            result = input;
        }
        return (T)((Object)result);
    }

    @Deprecated
    public Date getBeginDate() {
        YearMonthDay ymd = this.getBeginDateYearMonthDay();
        return ymd == null ? null : new Date(ymd.getYear() - 1900, ymd.getMonthOfYear() - 1, ymd.getDayOfMonth());
    }

    public LocalDate getBeginLocalDate() {
        YearMonthDay result = this.getBeginDateYearMonthDay();
        return result == null ? null : result.toLocalDate();
    }

    @Deprecated
    public void setBeginDate(Date date) {
        if (date == null) {
            this.setBeginDateYearMonthDay(null);
        } else {
            this.setBeginDateYearMonthDay(YearMonthDay.fromDateFields((Date)date));
        }
    }

    @Deprecated
    public Date getEndDate() {
        YearMonthDay ymd = this.getEndDateYearMonthDay();
        return ymd == null ? null : new Date(ymd.getYear() - 1900, ymd.getMonthOfYear() - 1, ymd.getDayOfMonth());
    }

    public LocalDate getEndLocalDate() {
        YearMonthDay result = this.getEndDateYearMonthDay();
        return result == null ? null : result.toLocalDate();
    }

    @Deprecated
    public void setEndDate(Date date) {
        if (date == null) {
            this.setEndDateYearMonthDay(null);
        } else {
            this.setEndDateYearMonthDay(YearMonthDay.fromDateFields((Date)date));
        }
    }

    public abstract <E extends ExecutionInterval> E convert(Class<E> var1);
}

