/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.fenixedu.academic.FenixEduAcademicConfiguration;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.EnrolmentEvaluation_Base;
import org.fenixedu.academic.domain.Enrolment_Base;
import org.fenixedu.academic.domain.EntryPhase;
import org.fenixedu.academic.domain.EvaluationConfiguration;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.IEnrolment;
import org.fenixedu.academic.domain.OptionalEnrolment;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accessControl.AcademicAuthorizationGroup;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.curriculum.CurricularCourseType;
import org.fenixedu.academic.domain.curriculum.EnrollmentCondition;
import org.fenixedu.academic.domain.curriculum.EnrollmentState;
import org.fenixedu.academic.domain.curriculum.EnrolmentEvaluationContext;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.degreeStructure.EctsTableIndex;
import org.fenixedu.academic.domain.enrolment.EnroledEnrolmentWrapper;
import org.fenixedu.academic.domain.enrolment.ExternalDegreeEnrolmentWrapper;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.log.EnrolmentEvaluationLog;
import org.fenixedu.academic.domain.log.EnrolmentLog;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationDataByExecutionYear;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.StudentStatute;
import org.fenixedu.academic.domain.student.curriculum.Curriculum;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.academic.domain.studentCurriculum.CreditsDismissal;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academic.domain.studentCurriculum.EctsAndWeightProviderRegistry;
import org.fenixedu.academic.domain.studentCurriculum.EnrolmentWrapper;
import org.fenixedu.academic.domain.studentCurriculum.InternalCreditsSourceCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.InternalEnrolmentWrapper;
import org.fenixedu.academic.domain.studentCurriculum.OptionalDismissal;
import org.fenixedu.academic.domain.thesis.Thesis;
import org.fenixedu.academic.domain.treasury.TreasuryBridgeAPIFactory;
import org.fenixedu.academic.util.EnrolmentAction;
import org.fenixedu.academic.util.EnrolmentEvaluationState;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.signals.DomainObjectEvent;
import org.fenixedu.bennu.signals.Signal;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.YearMonthDay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.consistencyPredicates.ConsistencyPredicate;

public class Enrolment
extends Enrolment_Base
implements IEnrolment {
    public static final Logger logger = LoggerFactory.getLogger(Enrolment.class);
    public static final Comparator<Enrolment> REVERSE_COMPARATOR_BY_EXECUTION_PERIOD_AND_ID = new Comparator<Enrolment>(){

        @Override
        public int compare(Enrolment o1, Enrolment o2) {
            return -ICurriculumEntry.COMPARATOR_BY_EXECUTION_PERIOD_AND_ID.compare(o1, o2);
        }
    };
    public static final Comparator<Enrolment> COMPARATOR_BY_STUDENT_NUMBER = new Comparator<Enrolment>(){

        @Override
        public int compare(Enrolment e1, Enrolment e2) {
            int s2;
            int s1 = e1.getStudent().getNumber();
            return s1 == (s2 = e2.getStudent().getNumber().intValue()) ? e1.getExternalId().compareTo(e2.getExternalId()) : s1 - s2;
        }
    };
    public static final String SIGNAL_CREATED = "fenixedu.academic.enrolment.created";
    private static Supplier<EnrolmentPredicate> PREDICATE_SEASON = () -> new EnrolmentPredicate(){

        @Override
        public boolean test(Enrolment enrolment) {
            if (enrolment.isEvaluatedInSeason(this.getEvaluationSeason(), this.getExecutionSemester())) {
                throw new DomainException("error.EvaluationSeason.enrolment.evaluated.in.this.season", enrolment.getName().getContent(), this.getEvaluationSeason().getName().getContent());
            }
            if (this.getContext() == EnrolmentEvaluationContext.MARK_SHEET_EVALUATION) {
                if (enrolment.isEnroledInSeason(this.getEvaluationSeason(), this.getExecutionSemester())) {
                    throw new DomainException("error.EvaluationSeason.already.enroled.in.this.season", enrolment.getName().getContent(), this.getEvaluationSeason().getName().getContent());
                }
                if (enrolment.isApproved() && !this.getEvaluationSeason().isImprovement()) {
                    throw new DomainException("error.EvaluationSeason.evaluation.already.approved", enrolment.getName().getContent(), this.getEvaluationSeason().getName().getContent());
                }
            }
            return true;
        }
    };
    private static Supplier<EnrolmentPredicate> PREDICATE_IMPROVEMENT = () -> new EnrolmentPredicate(){

        @Override
        public boolean test(Enrolment enrolment) {
            ExecutionSemester enrolmentSemester;
            ExecutionSemester improvementSemester = this.getExecutionSemester();
            if (improvementSemester.isBeforeOrEquals(enrolmentSemester = enrolment.getExecutionPeriod())) {
                throw new DomainException("error.EnrolmentEvaluation.improvement.semester.must.be.after.or.equal.enrolment", enrolment.getName().getContent());
            }
            if (!enrolment.isApproved()) {
                throw new DomainException("curricularRules.ruleExecutors.ImprovementOfApprovedEnrolmentExecutor.degree.module.hasnt.been.approved", enrolment.getName().getContent());
            }
            Enrolment.getPredicateSeason().fill(this.getEvaluationSeason(), improvementSemester, this.getContext()).test(enrolment);
            DegreeModule degreeModule = enrolment.getDegreeModule();
            if (!degreeModule.hasAnyParentContexts(improvementSemester)) {
                throw new DomainException("curricularRules.ruleExecutors.ImprovementOfApprovedEnrolmentExecutor.degree.module.has.no.context.in.present.execution.period", enrolment.getName().getContent(), improvementSemester.getQualifiedName());
            }
            ExecutionSemester nextSemester = enrolmentSemester.getNextExecutionPeriod();
            if (improvementSemester == nextSemester) {
                return true;
            }
            if (!improvementSemester.isOneYearAfter(enrolmentSemester)) {
                for (ExecutionSemester iter = nextSemester; iter != null && iter != improvementSemester; iter = iter.getNextExecutionPeriod()) {
                    if (!degreeModule.hasAnyParentContexts(iter)) continue;
                    throw new DomainException("curricularRules.ruleExecutors.ImprovementOfApprovedEnrolmentExecutor.is.not.improving.in.execution.period.following.approval", new String[0]);
                }
            }
            return true;
        }
    };
    private static Supplier<EnrolmentPredicate> PREDICATE_SPECIAL_SEASON = () -> new EnrolmentPredicate(){

        @Override
        public boolean test(Enrolment enrolment) {
            ExecutionSemester enrolmentSemester;
            ExecutionSemester specialSeasonSemester = this.getExecutionSemester();
            if (specialSeasonSemester != (enrolmentSemester = enrolment.getExecutionPeriod())) {
                throw new DomainException("error.EnrolmentEvaluation.special.season.semester.must.be", enrolment.getName().getContent());
            }
            if (enrolment.isApproved()) {
                throw new DomainException("curricularRules.ruleExecutors.EnrolmentInSpecialSeasonEvaluationExecutor.degree.module.has.been.approved", enrolment.getName().getContent());
            }
            Enrolment.getPredicateSeason().fill(this.getEvaluationSeason(), this.getExecutionSemester(), this.getContext()).test(enrolment);
            if (enrolment.hasSpecialSeasonInExecutionYear(enrolmentSemester.getExecutionYear())) {
                throw new DomainException("curricularRules.ruleExecutors.EnrolmentInSpecialSeasonEvaluationExecutor.already.enroled.in.special.season", enrolment.getName().getContent(), enrolment.getExecutionYear().getYear());
            }
            StudentCurricularPlan scp = enrolment.getStudentCurricularPlan();
            Registration registration = scp.getRegistration();
            if (!this.isSpecialSeasonGrantedByStatute(registration) && !registration.getStudent().isSenior(this.getExecutionSemester().getExecutionYear())) {
                throw new DomainException("error.special.season.not.granted", new String[0]);
            }
            boolean isServices = AcademicAuthorizationGroup.get(AcademicOperationType.STUDENT_ENROLMENTS).isMember(Authenticate.getUser());
            return this.considerThisEnrolmentNormalEnrolments(enrolment) || this.considerThisEnrolmentPropaedeuticEnrolments(enrolment, isServices) || this.considerThisEnrolmentExtraCurricularEnrolments(enrolment, isServices) || this.considerThisEnrolmentStandaloneEnrolments(enrolment, isServices);
        }

        private boolean isSpecialSeasonGrantedByStatute(Registration registration) {
            Student student = registration.getStudent();
            for (StudentStatute statute : student.getStudentStatutesSet()) {
                if (!statute.getType().isSpecialSeasonGranted() && !statute.hasSeniorStatuteForRegistration(registration) || !statute.isValidInExecutionPeriod(this.getExecutionSemester())) continue;
                return true;
            }
            return false;
        }

        private boolean considerThisEnrolmentNormalEnrolments(Enrolment enrolment) {
            if (enrolment.isBolonhaDegree() && !enrolment.isExtraCurricular() && !enrolment.isPropaedeutic() && !enrolment.isStandalone() && enrolment.getParentCycleCurriculumGroup().isConclusionProcessed()) {
                return false;
            }
            return !enrolment.parentCurriculumGroupIsNoCourseGroupCurriculumGroup() || enrolment.isPropaedeutic();
        }

        private boolean considerThisEnrolmentPropaedeuticEnrolments(Enrolment enrolment, boolean isServices) {
            return enrolment.isPropaedeutic() && isServices;
        }

        private boolean considerThisEnrolmentExtraCurricularEnrolments(Enrolment enrolment, boolean isServices) {
            return enrolment.isExtraCurricular() && isServices;
        }

        private boolean considerThisEnrolmentStandaloneEnrolments(Enrolment enrolment, boolean isServices) {
            return enrolment.isStandalone() && isServices;
        }
    };

    public Enrolment() {
        super.setIsExtraCurricular(Boolean.FALSE);
        Signal.emit((String)SIGNAL_CREATED, (Object)new DomainObjectEvent((DomainObject)this));
    }

    public Enrolment(StudentCurricularPlan studentCurricularPlan, CurricularCourse curricularCourse, ExecutionSemester executionSemester, EnrollmentCondition enrolmentCondition, String createdBy) {
        this();
        this.initializeAsNew(studentCurricularPlan, curricularCourse, executionSemester, enrolmentCondition, createdBy);
        this.createCurriculumLineLog(EnrolmentAction.ENROL);
    }

    @Override
    public final boolean isEnrolment() {
        return true;
    }

    public boolean isOptional() {
        return false;
    }

    @Override
    public final boolean isExternalEnrolment() {
        return false;
    }

    public final boolean isPropaedeutic() {
        return super.isPropaedeutic();
    }

    public boolean isExtraCurricular() {
        return super.isExtraCurricular();
    }

    @Deprecated
    public Boolean getIsExtraCurricular() {
        return this.isExtraCurricular();
    }

    @Deprecated
    public void setIsExtraCurricular(Boolean isExtraCurricular) {
        throw new DomainException("error.org.fenixedu.academic.domain.Enrolment.use.markAsExtraCurricular.method.instead", new String[0]);
    }

    public void markAsExtraCurricular() {
        this.setCurriculumGroup((CurriculumGroup)((Object)this.getStudentCurricularPlan().getExtraCurriculumGroup()));
        super.setIsExtraCurricular(null);
    }

    public final boolean isFinal() {
        return this.getEnrolmentCondition() == EnrollmentCondition.FINAL;
    }

    public final boolean isInvisible() {
        return this.getEnrolmentCondition() == EnrollmentCondition.INVISIBLE;
    }

    public final boolean isTemporary() {
        return this.getEnrolmentCondition() == EnrollmentCondition.TEMPORARY;
    }

    public final boolean isImpossible() {
        return this.getEnrolmentCondition() == EnrollmentCondition.IMPOSSIBLE;
    }

    @Deprecated
    public final boolean isSpecialSeason() {
        return this.hasSpecialSeason();
    }

    public Enrolment(StudentCurricularPlan studentCurricularPlan, CurriculumGroup curriculumGroup, CurricularCourse curricularCourse, ExecutionSemester executionSemester, EnrollmentCondition enrolmentCondition, String createdBy) {
        this();
        if (studentCurricularPlan == null || curriculumGroup == null || curricularCourse == null || executionSemester == null || enrolmentCondition == null || createdBy == null) {
            throw new DomainException("invalid arguments", new String[0]);
        }
        this.checkInitConstraints(studentCurricularPlan, curricularCourse, executionSemester);
        this.initializeAsNew(studentCurricularPlan, curriculumGroup, curricularCourse, executionSemester, enrolmentCondition, createdBy);
        this.createCurriculumLineLog(EnrolmentAction.ENROL);
    }

    protected void checkInitConstraints(StudentCurricularPlan studentCurricularPlan, CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        if (studentCurricularPlan.getEnrolmentByCurricularCourseAndExecutionPeriod(curricularCourse, executionSemester) != null) {
            throw new DomainException("error.Enrolment.duplicate.enrolment", curricularCourse.getName());
        }
    }

    protected void initializeAsNew(StudentCurricularPlan studentCurricularPlan, CurriculumGroup curriculumGroup, CurricularCourse curricularCourse, ExecutionSemester executionSemester, EnrollmentCondition enrolmentCondition, String createdBy) {
        this.initializeAsNewWithoutEnrolmentEvaluation(studentCurricularPlan, curriculumGroup, curricularCourse, executionSemester, enrolmentCondition, createdBy);
        this.createEnrolmentEvaluationWithoutGrade();
    }

    protected void initializeAsNewWithoutEnrolmentEvaluation(StudentCurricularPlan studentCurricularPlan, CurriculumGroup curriculumGroup, CurricularCourse curricularCourse, ExecutionSemester executionSemester, EnrollmentCondition enrolmentCondition, String createdBy) {
        this.initializeCommon(studentCurricularPlan, curricularCourse, executionSemester, enrolmentCondition, createdBy);
        this.setCurriculumGroup(curriculumGroup);
    }

    protected void initializeAsNew(StudentCurricularPlan studentCurricularPlan, CurricularCourse curricularCourse, ExecutionSemester executionSemester, EnrollmentCondition enrolmentCondition, String createdBy) {
        this.initializeAsNewWithoutEnrolmentEvaluation(studentCurricularPlan, curricularCourse, executionSemester, enrolmentCondition, createdBy);
        this.createEnrolmentEvaluationWithoutGrade();
    }

    private void initializeCommon(StudentCurricularPlan studentCurricularPlan, CurricularCourse curricularCourse, ExecutionSemester executionSemester, EnrollmentCondition enrolmentCondition, String createdBy) {
        this.setCurricularCourse(curricularCourse);
        this.setWeigth(studentCurricularPlan.isBolonhaDegree() ? curricularCourse.getEctsCredits(executionSemester) : curricularCourse.getWeigth());
        this.setEnrollmentState(EnrollmentState.ENROLLED);
        this.setExecutionPeriod(executionSemester);
        this.setEvaluationSeason(EvaluationConfiguration.getInstance().getDefaultEvaluationSeason());
        this.setCreatedBy(createdBy);
        this.setCreationDateDateTime(new DateTime());
        this.setEnrolmentCondition(enrolmentCondition);
        this.createAttend(studentCurricularPlan.getRegistration(), curricularCourse, executionSemester);
        super.setIsExtraCurricular(Boolean.FALSE);
    }

    protected void initializeAsNewWithoutEnrolmentEvaluation(StudentCurricularPlan studentCurricularPlan, CurricularCourse curricularCourse, ExecutionSemester executionSemester, EnrollmentCondition enrolmentCondition, String createdBy) {
        this.initializeCommon(studentCurricularPlan, curricularCourse, executionSemester, enrolmentCondition, createdBy);
        this.setStudentCurricularPlan(studentCurricularPlan);
    }

    @Override
    public void delete() {
        this.checkRulesToDelete();
        this.createCurriculumLineLog(EnrolmentAction.UNENROL);
        this.deleteInformation();
        this.setEvaluationSeason(null);
        super.delete();
    }

    protected void deleteInformation() {
        for (Thesis thesis : this.getThesesSet()) {
            if (!thesis.isDeletable()) {
                throw new DomainException("error.Enrolment.cannot.delete.thesis", new String[0]);
            }
            thesis.delete();
        }
        Registration registration = this.getRegistration();
        this.getStudentCurricularPlan().setIsFirstTimeToNull();
        this.setExecutionPeriod(null);
        this.setStudentCurricularPlan(null);
        this.setDegreeModule(null);
        this.setCurriculumGroup(null);
        this.getNotNeedToEnrollCurricularCoursesSet().clear();
        Iterator attendsIter = this.getAttendsSet().iterator();
        while (attendsIter.hasNext()) {
            Attends attends = (Attends)((Object)attendsIter.next());
            attendsIter.remove();
            attends.setEnrolment(null);
            if (!attends.getAssociatedMarksSet().isEmpty() || !attends.getStudentGroupsSet().isEmpty()) continue;
            boolean hasShiftEnrolment = false;
            for (Shift shift : attends.getExecutionCourse().getAssociatedShifts()) {
                if (!shift.getStudentsSet().contains((Object)registration)) continue;
                hasShiftEnrolment = true;
                break;
            }
            if (hasShiftEnrolment) continue;
            attends.delete();
        }
        Iterator evalsIter = this.getEvaluationsSet().iterator();
        while (evalsIter.hasNext()) {
            EnrolmentEvaluation eval = (EnrolmentEvaluation)((Object)evalsIter.next());
            evalsIter.remove();
            eval.delete();
        }
    }

    protected void checkRulesToDelete() {
        if (!this.getExtraExamRequestsSet().isEmpty()) {
            throw new DomainException("error.Enrolment.has.ExtraExamRequests", new String[0]);
        }
        if (!this.getEnrolmentWrappersSet().isEmpty()) {
            throw new DomainException("error.Enrolment.is.origin.in.some.Equivalence", new String[0]);
        }
        if (!this.getCourseLoadRequestsSet().isEmpty()) {
            throw new DomainException("error.Enrolment.has.CourseLoadRequests", new String[0]);
        }
        if (!this.getProgramCertificateRequestsSet().isEmpty()) {
            throw new DomainException("error.Enrolment.has.ProgramCertificateRequests", new String[0]);
        }
    }

    public final Collection<Enrolment> getBrothers() {
        HashSet<Enrolment> result = new HashSet<Enrolment>();
        result.addAll(this.getStudentCurricularPlan().getEnrolments(this.getCurricularCourse()));
        result.remove(this);
        return result;
    }

    public final Optional<EnrolmentEvaluation> getEnrolmentEvaluationBySeasonAndState(EnrolmentEvaluationState state, EvaluationSeason season) {
        Supplier<Stream> supplier = () -> this.getEnrolmentEvaluationBySeason(season).filter(e -> e.getEnrolmentEvaluationState().equals(state));
        if (supplier.get().count() > 1L) {
            logger.warn("Multiple Evaluations for pair Season<->STATE! [REG {}] [SCP {}] [{}] [{}] [{}]", new Object[]{this.getRegistration().getNumber(), this.getStudentCurricularPlan().getName(), this.print("").toString().replace("/n", ""), season == null ? "" : season.getName().getContent(), state == null ? "" : state.toString()});
        }
        return supplier.get().findAny();
    }

    public final Stream<EnrolmentEvaluation> getEnrolmentEvaluationBySeason(EvaluationSeason season) {
        return this.getEvaluationsSet().stream().filter(e -> e.getEvaluationSeason().equals(season));
    }

    public boolean isEvaluatedInSeason(EvaluationSeason season, ExecutionSemester semester) {
        return this.getEnrolmentEvaluation(season, semester, Boolean.TRUE).isPresent();
    }

    public boolean isEnroledInSeason(EvaluationSeason season, ExecutionSemester semester) {
        return this.getTemporaryEvaluation(season, semester).isPresent();
    }

    public final Optional<EnrolmentEvaluation> getEnrolmentEvaluation(EvaluationSeason season, ExecutionSemester semester, Boolean assertFinal) {
        Supplier<Stream> supplier = () -> this.getEnrolmentEvaluationBySeason(season).filter(evaluation -> {
            if (evaluation.isAnnuled()) {
                return false;
            }
            if (evaluation.getEvaluationSeason().isImprovement() && evaluation.getExecutionPeriod() != semester) {
                return false;
            }
            if (assertFinal != null) {
                if (assertFinal.booleanValue() && !evaluation.isFinal()) {
                    return false;
                }
                if (!assertFinal.booleanValue() && !evaluation.isTemporary()) {
                    return false;
                }
            }
            return true;
        });
        if (supplier.get().count() > 1L) {
            logger.warn("Multiple Evaluations for pair Season<->SEMESTER! [REG {}] [SCP {}] [{}] [{}] [{}]", new Object[]{this.getRegistration().getNumber(), this.getStudentCurricularPlan().getName(), this.print("").toString().replace("/n", ""), season == null ? "" : season.getName().getContent(), semester == null ? "" : semester.getQualifiedName()});
        }
        return supplier.get().findAny();
    }

    protected void createEnrolmentEvaluationWithoutGrade() {
        boolean existing = this.getEnrolmentEvaluationBySeason(EvaluationConfiguration.getInstance().getDefaultEvaluationSeason()).filter(e -> e.getGrade().equals(null)).findAny().isPresent();
        if (!existing) {
            EnrolmentEvaluation evaluation = new EnrolmentEvaluation(this, EvaluationConfiguration.getInstance().getDefaultEvaluationSeason(), EnrolmentEvaluationState.TEMPORARY_OBJ);
            evaluation.setWhenDateTime(new DateTime());
            this.addEvaluations(evaluation);
        }
    }

    private void createAttend(Registration registration, CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        List<ExecutionCourse> executionCourses = curricularCourse.getExecutionCoursesByExecutionPeriod(executionSemester);
        ExecutionCourse executionCourse = null;
        if (executionCourses.size() > 1) {
            Iterator<ExecutionCourse> iterator = executionCourses.iterator();
            while (iterator.hasNext()) {
                ExecutionCourse each;
                executionCourse = each = iterator.next();
            }
        } else if (executionCourses.size() == 1) {
            executionCourse = executionCourses.iterator().next();
        }
        if (executionCourse != null) {
            Attends attend = executionCourse.getAttendsByStudent(registration.getStudent());
            if (attend == null) {
                this.addAttends(new Attends(registration, executionCourse));
            } else if (attend.getEnrolment() == null) {
                attend.setRegistration(registration);
                this.addAttends(attend);
            } else {
                throw new DomainException("error.cannot.create.multiple.enrolments.for.student.in.execution.course", executionCourse.getNome(), executionCourse.getExecutionPeriod().getQualifiedName());
            }
        }
    }

    public final void createAttends(Registration registration, ExecutionCourse executionCourse) {
        Attends attendsFor = this.getAttendsFor(executionCourse.getExecutionPeriod());
        if (attendsFor != null) {
            try {
                attendsFor.delete();
            }
            catch (DomainException e) {
                throw new DomainException("error.attends.cant.change.attends", new String[0]);
            }
        }
        this.addAttends(new Attends(registration, executionCourse));
    }

    public final EnrolmentEvaluation createTemporaryEvaluationForImprovement(Person person, EvaluationSeason evaluationSeason, ExecutionSemester executionSemester) {
        Enrolment.getPredicateImprovement().fill(evaluationSeason, executionSemester, EnrolmentEvaluationContext.MARK_SHEET_EVALUATION).test(this);
        EnrolmentEvaluation enrolmentEvaluation = new EnrolmentEvaluation(this, evaluationSeason, EnrolmentEvaluationState.TEMPORARY_OBJ, person, executionSemester);
        this.createAttendForImprovement(executionSemester);
        RegistrationDataByExecutionYear.getOrCreateRegistrationDataByYear(this.getRegistration(), executionSemester.getExecutionYear());
        Signal.emit((String)"IMPROVEMENT_ENROLMENT", (Object)new DomainObjectEvent((DomainObject)enrolmentEvaluation));
        return enrolmentEvaluation;
    }

    private void createAttendForImprovement(final ExecutionSemester executionSemester) {
        final Registration registration = this.getRegistration();
        ExecutionCourse currentExecutionCourse = (ExecutionCourse)((Object)CollectionUtils.find((Collection)this.getCurricularCourse().getAssociatedExecutionCoursesSet(), (Predicate)new Predicate(){

            public final boolean evaluate(Object arg0) {
                ExecutionCourse executionCourse = (ExecutionCourse)((Object)arg0);
                return executionCourse.getExecutionPeriod().equals(executionSemester) && executionCourse.getEntryPhase().equals((Object)EntryPhase.FIRST_PHASE);
            }
        }));
        if (currentExecutionCourse != null) {
            Set attends = currentExecutionCourse.getAttendsSet();
            Attends attend = (Attends)((Object)CollectionUtils.find((Collection)attends, (Predicate)new Predicate(){

                public boolean evaluate(Object arg0) {
                    Attends attend = (Attends)((Object)arg0);
                    return attend.getRegistration().equals((Object)registration);
                }
            }));
            if (attend == null) {
                attend = this.getStudent().getAttends(currentExecutionCourse);
                if (attend != null) {
                    attend.setRegistration(registration);
                } else {
                    attend = new Attends(registration, currentExecutionCourse);
                }
            }
            attend.setEnrolment(this);
        }
    }

    public final void deleteTemporaryEvaluationForImprovement(EvaluationSeason season, ExecutionSemester improvementSemester) throws DomainException {
        Attends attends;
        EnrolmentEvaluation temporaryImprovement = this.getTemporaryEvaluation(season, improvementSemester).orElse(null);
        if (temporaryImprovement == null || !temporaryImprovement.isTemporary()) {
            throw new DomainException("error.enrolment.cant.unenroll", new String[0]);
        }
        if (temporaryImprovement.getMarkSheet() != null && temporaryImprovement.getMarkSheet().isConfirmed()) {
            throw new DomainException("error.enrolment.impossible.to.delete.evaluation.has.marksheet", new String[0]);
        }
        TreasuryBridgeAPIFactory.implementation().improvementUnrenrolment(temporaryImprovement);
        temporaryImprovement.delete();
        if (this.getExecutionPeriod() != improvementSemester && (attends = this.getAttendsFor(improvementSemester)) != null) {
            attends.delete();
        }
    }

    public final boolean isImprovementForExecutionCourse(ExecutionCourse executionCourse) {
        return this.getCurricularCourse().getAssociatedExecutionCoursesSet().contains((Object)executionCourse) && this.getExecutionPeriod() != executionCourse.getExecutionPeriod();
    }

    public static EnrolmentPredicate getPredicateSeason() {
        return PREDICATE_SEASON.get();
    }

    public static void setPredicateSeason(Supplier<EnrolmentPredicate> input) {
        if (input != null && input.get() != null) {
            PREDICATE_SEASON = input;
        } else {
            logger.error("Could not set PREDICATE_SEASON to null");
        }
    }

    public static EnrolmentPredicate getPredicateImprovement() {
        return PREDICATE_IMPROVEMENT.get();
    }

    public static void setPredicateImprovement(Supplier<EnrolmentPredicate> input) {
        if (input != null && input.get() != null) {
            PREDICATE_IMPROVEMENT = input;
        } else {
            logger.error("Could not set PREDICATE_IMPROVEMENT to null");
        }
    }

    public static EnrolmentPredicate getPredicateSpecialSeason() {
        return PREDICATE_SPECIAL_SEASON.get();
    }

    public static void setPredicateSpecialSeason(Supplier<EnrolmentPredicate> input) {
        if (input != null && input.get() != null) {
            PREDICATE_SPECIAL_SEASON = input;
        } else {
            logger.error("Could not set PREDICATE_SPECIAL_SEASON to null");
        }
    }

    public final EnrolmentEvaluation createTemporaryEvaluationForSpecialSeason(Person person, EvaluationSeason evaluationSeason) {
        ExecutionSemester executionSemester = this.getExecutionPeriod();
        Enrolment.getPredicateSpecialSeason().fill(evaluationSeason, executionSemester, EnrolmentEvaluationContext.MARK_SHEET_EVALUATION).test(this);
        if (FenixEduAcademicConfiguration.getConfiguration().getEnrolmentsInSpecialSeasonEvaluationsInduceEnrolmentVariables().booleanValue()) {
            this.setEvaluationSeason(evaluationSeason);
            this.setEnrollmentState(EnrollmentState.ENROLLED);
        }
        EnrolmentEvaluation enrolmentEvaluation = new EnrolmentEvaluation(this, evaluationSeason, EnrolmentEvaluationState.TEMPORARY_OBJ, person);
        return enrolmentEvaluation;
    }

    public final void deleteTemporaryEvaluationForSpecialSeason(EvaluationSeason season) throws DomainException {
        EnrolmentEvaluation temporarySpecialSeason = this.getTemporaryEvaluation(season, this.getExecutionPeriod()).orElse(null);
        if (temporarySpecialSeason == null || !temporarySpecialSeason.isTemporary()) {
            throw new DomainException("error.enrolment.cant.unenroll", new String[0]);
        }
        if (temporarySpecialSeason.getMarkSheet() != null && temporarySpecialSeason.getMarkSheet().isConfirmed()) {
            throw new DomainException("error.enrolment.impossible.to.delete.evaluation.has.marksheet", new String[0]);
        }
        temporarySpecialSeason.delete();
        if (FenixEduAcademicConfiguration.getConfiguration().getEnrolmentsInSpecialSeasonEvaluationsInduceEnrolmentVariables().booleanValue()) {
            this.setEvaluationSeason(EvaluationConfiguration.getInstance().getDefaultEvaluationSeason());
            this.setEnrolmentCondition(EnrollmentCondition.FINAL);
            this.getEnrolmentEvaluationBySeasonAndState(EnrolmentEvaluationState.FINAL_OBJ, season).ifPresent(e -> this.setEnrollmentState(e.getEnrollmentStateByGrade()));
        }
    }

    public final List<EnrolmentEvaluation> getAllFinalEnrolmentEvaluations() {
        ArrayList<EnrolmentEvaluation> result = new ArrayList<EnrolmentEvaluation>();
        for (EnrolmentEvaluation enrolmentEvaluation : this.getEvaluationsSet()) {
            if (!enrolmentEvaluation.isFinal()) continue;
            result.add(enrolmentEvaluation);
        }
        return result;
    }

    @Deprecated
    public final boolean hasImprovement() {
        return this.getEvaluationsSet().stream().filter(i -> i.getEvaluationSeason().isImprovement()).findAny().isPresent();
    }

    public final boolean hasImprovementFor(ExecutionSemester executionSemester) {
        for (EnrolmentEvaluation enrolmentEvaluation : this.getEvaluationsSet()) {
            if (!enrolmentEvaluation.getEvaluationSeason().isImprovement() || enrolmentEvaluation.getExecutionPeriod() == null || !enrolmentEvaluation.getExecutionPeriod().equals(executionSemester)) continue;
            return true;
        }
        return false;
    }

    public final boolean hasSpecialSeason() {
        for (EnrolmentEvaluation evaluation : this.getEvaluationsSet()) {
            EvaluationSeason season = evaluation.getEvaluationSeason();
            if (!season.isSpecial() || !this.isEnroledInSeason(season, this.getExecutionPeriod())) continue;
            return true;
        }
        return false;
    }

    public final boolean hasSpecialSeasonInExecutionYear(ExecutionYear executionYear) {
        for (Enrolment enrolment : this.getBrothers()) {
            if (enrolment.getExecutionYear() != executionYear || !enrolment.hasSpecialSeason()) continue;
            return true;
        }
        return this.hasSpecialSeason();
    }

    public final boolean isNotEvaluated() {
        EnrolmentEvaluation latestEnrolmentEvaluation = this.getFinalEnrolmentEvaluation();
        return latestEnrolmentEvaluation == null || latestEnrolmentEvaluation.isNotEvaluated();
    }

    public final boolean isFlunked() {
        EnrolmentEvaluation latestEnrolmentEvaluation = this.getFinalEnrolmentEvaluation();
        return latestEnrolmentEvaluation != null && latestEnrolmentEvaluation.isFlunked();
    }

    @Override
    public final boolean isApproved() {
        if (this.isAnnulled()) {
            return false;
        }
        EnrolmentEvaluation latestEnrolmentEvaluation = this.getFinalEnrolmentEvaluation();
        return latestEnrolmentEvaluation != null && latestEnrolmentEvaluation.isApproved();
    }

    public final boolean isAproved(ExecutionYear executionYear) {
        return (executionYear == null || this.getExecutionYear().isBeforeOrEquals(executionYear)) && this.isApproved();
    }

    public boolean isApproved(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        if (executionSemester == null || this.getExecutionPeriod().isBeforeOrEquals(executionSemester)) {
            return this.isApproved() && this.hasCurricularCourse(this.getCurricularCourse(), curricularCourse, executionSemester);
        }
        return false;
    }

    public final CurriculumModule.ConclusionValue isConcluded(ExecutionYear executionYear) {
        return CurriculumModule.ConclusionValue.create(this.isAproved(executionYear));
    }

    public YearMonthDay calculateConclusionDate() {
        if (!this.isApproved()) {
            throw new DomainException("error.Enrolment.not.approved", new String[0]);
        }
        return EvaluationConfiguration.getInstance().getEnrolmentEvaluationForConclusionDate(this).map(EnrolmentEvaluation_Base::getExamDateYearMonthDay).orElse(null);
    }

    public final Curriculum getCurriculum(DateTime when, ExecutionYear year) {
        if (this.wasCreated(when) && (year == null || this.getExecutionYear().isBefore(year)) && this.isApproved() && !this.isPropaedeutic() && !this.isExtraCurricular()) {
            return new Curriculum((CurriculumModule)((Object)this), year, Collections.singleton(this), Collections.EMPTY_SET, Collections.singleton(this));
        }
        return Curriculum.createEmpty((CurriculumModule)((Object)this), year);
    }

    @Override
    public final Grade getGrade() {
        EnrolmentEvaluation enrolmentEvaluation = this.getFinalEnrolmentEvaluation();
        return enrolmentEvaluation == null ? Grade.createEmptyGrade() : enrolmentEvaluation.getGrade();
    }

    @Override
    public final String getGradeValue() {
        return this.getGrade().getValue();
    }

    @Override
    public Grade getEctsGrade(StudentCurricularPlan scp, DateTime processingDate) {
        Grade grade = this.getGrade();
        if (this.getEnrolmentWrappersSet().size() > 0) {
            HashSet<Dismissal> dismissals = new HashSet<Dismissal>();
            for (EnrolmentWrapper wrapper : this.getEnrolmentWrappersSet()) {
                if (wrapper.getCredits().getStudentCurricularPlan().isBolonhaDegree() && !wrapper.getCredits().getStudentCurricularPlan().equals((Object)scp)) continue;
                for (Dismissal dismissal : wrapper.getCredits().getDismissalsSet()) {
                    dismissals.add(dismissal);
                }
            }
            if (dismissals.size() == 1) {
                Dismissal dismissal = (Dismissal)dismissals.iterator().next();
                if (dismissal instanceof OptionalDismissal || dismissal instanceof CreditsDismissal || dismissal.getCurricularCourse().isOptionalCurricularCourse()) {
                    return EctsTableIndex.convertGradeToEcts(scp.getDegree(), (CurriculumLine)((Object)dismissal), grade, processingDate);
                }
                CurricularCourse curricularCourse = dismissal.getCurricularCourse();
                return EctsTableIndex.convertGradeToEcts(curricularCourse, (CurriculumLine)((Object)dismissal), grade, processingDate);
            }
            if (dismissals.size() > 1) {
                for (Dismissal dismissal : dismissals) {
                    if (dismissal.getParentCycleCurriculumGroup() == null) continue;
                    return EctsTableIndex.convertGradeToEcts(scp.getDegree(), (CurriculumLine)((Object)dismissal), grade, processingDate);
                }
            }
        }
        return EctsTableIndex.convertGradeToEcts(this.getCurricularCourse(), (CurriculumLine)((Object)this), grade, processingDate);
    }

    @Override
    public final Integer getFinalGrade() {
        return this.getGrade().getIntegerValue();
    }

    public GradeScale getGradeScaleChain() {
        return this.getCurricularCourse().getGradeScaleChain();
    }

    public GradeScale getGradeScale() {
        return this.getGradeScaleChain();
    }

    @Override
    public final boolean isEnroled() {
        return this.getEnrollmentState() == EnrollmentState.ENROLLED;
    }

    @Deprecated
    public final boolean isEnrolmentStateApproved() {
        return this.getEnrollmentState() == EnrollmentState.APROVED;
    }

    @Deprecated
    public final boolean isEnrolmentStateNotApproved() {
        return this.getEnrollmentState() == EnrollmentState.NOT_APROVED;
    }

    @Deprecated
    public final boolean isEnrolmentStateNotEvaluated() {
        return this.getEnrollmentState() == EnrollmentState.NOT_EVALUATED;
    }

    public final boolean isAnnulled() {
        return this.getEnrollmentState() == EnrollmentState.ANNULED;
    }

    public final boolean isTemporarilyEnroled() {
        return this.getEnrollmentState() == EnrollmentState.TEMPORARILY_ENROLLED;
    }

    public final boolean isEvaluated() {
        return this.isEnrolmentStateApproved() || this.isEnrolmentStateNotApproved();
    }

    public final boolean isActive() {
        return !this.isAnnulled() && !this.isTemporarilyEnroled();
    }

    public final Boolean isFirstTime() {
        if (this.getIsFirstTime() == null) {
            this.resetIsFirstTimeEnrolment();
        }
        return this.getIsFirstTime();
    }

    public final void resetIsFirstTimeEnrolment() {
        if (this.getStudentCurricularPlan() != null && this.getCurricularCourse() != null && this.getExecutionPeriod() != null && this.getEnrollmentState() != null) {
            this.getStudentCurricularPlan().resetIsFirstTimeEnrolmentForCurricularCourse(this.getCurricularCourse());
        } else {
            this.setIsFirstTime(Boolean.FALSE);
        }
    }

    public final void setDegreeModule(DegreeModule degreeModule) {
        super.setDegreeModule(degreeModule);
        this.resetIsFirstTimeEnrolment();
    }

    public final void setEnrollmentState(EnrollmentState enrollmentState) {
        super.setEnrollmentState(enrollmentState);
        this.resetIsFirstTimeEnrolment();
    }

    public final void setExecutionPeriod(ExecutionSemester executionSemester) {
        super.setExecutionPeriod(executionSemester);
        this.resetIsFirstTimeEnrolment();
    }

    public final void setStudentCurricularPlan(StudentCurricularPlan studentCurricularPlan) {
        super.setStudentCurricularPlan(studentCurricularPlan);
        this.resetIsFirstTimeEnrolment();
    }

    public final int getNumberOfTotalEnrolmentsInThisCourse() {
        return this.getStudentCurricularPlan().countEnrolmentsByCurricularCourse(this.getCurricularCourse());
    }

    public final int getNumberOfTotalEnrolmentsInThisCourse(ExecutionSemester untilExecutionPeriod) {
        return this.getStudentCurricularPlan().countEnrolmentsByCurricularCourse(this.getCurricularCourse(), untilExecutionPeriod);
    }

    protected void createCurriculumLineLog(EnrolmentAction action) {
        new EnrolmentLog(action, this.getRegistration(), this.getCurricularCourse(), this.getExecutionPeriod(), this.getCurrentUser());
    }

    public StringBuilder print(String tabs) {
        StringBuilder builder = new StringBuilder();
        builder.append(tabs);
        builder.append("[E ").append(this.getDegreeModule().getName()).append(" ").append(this.isApproved()).append(" ]\n");
        return builder;
    }

    public final EnrolmentEvaluation addNewEnrolmentEvaluation(EnrolmentEvaluationState enrolmentEvaluationState, EvaluationSeason evaluationSeason, Person responsibleFor, String gradeValue, Date availableDate, Date examDate, ExecutionSemester executionSemester, GradeScale gradeScale) {
        Grade grade = Grade.createGrade(gradeValue, gradeScale != null ? gradeScale : this.getGradeScale());
        EnrolmentEvaluation enrolmentEvaluation = new EnrolmentEvaluation(this, enrolmentEvaluationState, evaluationSeason, responsibleFor, grade, availableDate, examDate, new DateTime());
        if (evaluationSeason.isImprovement()) {
            enrolmentEvaluation.setExecutionPeriod(executionSemester);
        }
        return enrolmentEvaluation;
    }

    public final EnrolmentEvaluation addNewEnrolmentEvaluation(EnrolmentEvaluationState enrolmentEvaluationState, EvaluationSeason evaluationSeason, Person responsibleFor, String gradeValue, Date availableDate, Date examDate, ExecutionSemester executionSemester, String bookReference, String page, GradeScale gradeScale) {
        EnrolmentEvaluation enrolmentEvaluation = this.addNewEnrolmentEvaluation(enrolmentEvaluationState, evaluationSeason, responsibleFor, gradeValue, availableDate, examDate, executionSemester, gradeScale);
        enrolmentEvaluation.setBookReference(bookReference);
        enrolmentEvaluation.setPage(page);
        enrolmentEvaluation.setContext(EnrolmentEvaluationContext.CURRICULUM_VALIDATION_EVALUATION);
        enrolmentEvaluation.setGradeScale(gradeScale);
        EnrolmentEvaluationLog.logEnrolmentEvaluationCreation(enrolmentEvaluation);
        return enrolmentEvaluation;
    }

    public final boolean hasAssociatedMarkSheet(EvaluationSeason season) {
        for (EnrolmentEvaluation enrolmentEvaluation : this.getEvaluationsSet()) {
            if (enrolmentEvaluation.getMarkSheet() == null || !enrolmentEvaluation.getEvaluationSeason().equals(season)) continue;
            return true;
        }
        return false;
    }

    public final boolean hasAssociatedMarkSheetOrFinalGrade() {
        for (EnrolmentEvaluation enrolmentEvaluation : this.getEvaluationsSet()) {
            if (enrolmentEvaluation.getMarkSheet() == null && !enrolmentEvaluation.isFinal()) continue;
            return true;
        }
        return false;
    }

    public final boolean hasAssociatedMarkSheetOrFinalGrade(EvaluationSeason season) {
        for (EnrolmentEvaluation enrolmentEvaluation : this.getEvaluationsSet()) {
            if (!enrolmentEvaluation.getEvaluationSeason().equals(season) || enrolmentEvaluation.getMarkSheet() == null && !enrolmentEvaluation.isFinal()) continue;
            return true;
        }
        return false;
    }

    public final List<EnrolmentEvaluation> getConfirmedEvaluations(EvaluationSeason season) {
        ArrayList<EnrolmentEvaluation> evaluations = new ArrayList<EnrolmentEvaluation>();
        for (EnrolmentEvaluation evaluation : this.getEvaluationsSet()) {
            if (evaluation.getMarkSheet() == null || !evaluation.getMarkSheet().getEvaluationSeason().equals(season) || !evaluation.getMarkSheet().isConfirmed()) continue;
            evaluations.add(evaluation);
        }
        Collections.sort(evaluations, EnrolmentEvaluation.COMPARATORY_BY_WHEN);
        return evaluations;
    }

    public final Attends getAttendsByExecutionCourse(ExecutionCourse executionCourse) {
        for (Attends attends : this.getAttendsSet()) {
            if (!attends.isFor(executionCourse)) continue;
            return attends;
        }
        return null;
    }

    public final boolean hasAttendsFor(ExecutionSemester executionSemester) {
        for (Attends attends : this.getAttendsSet()) {
            if (!attends.isFor(executionSemester)) continue;
            return true;
        }
        return false;
    }

    public final Attends getAttendsFor(ExecutionSemester executionSemester) {
        Attends result = null;
        for (Attends attends : this.getAttendsSet()) {
            if (!attends.isFor(executionSemester)) continue;
            if (result == null) {
                result = attends;
                continue;
            }
            throw new DomainException("Enrolment.found.two.attends.for.same.execution.period", new String[0]);
        }
        return result;
    }

    public final ExecutionCourse getExecutionCourseFor(ExecutionSemester executionSemester) {
        for (Attends attend : this.getAttendsSet()) {
            if (attend.getExecutionCourse().getExecutionPeriod() != executionSemester) continue;
            return attend.getExecutionCourse();
        }
        return null;
    }

    public EnrolmentEvaluation getLatestEnrolmentEvaluationBySeason(EvaluationSeason season) {
        return EvaluationConfiguration.getInstance().getCurrentEnrolmentEvaluation(this, season).orElse(null);
    }

    public final EnrolmentEvaluation getFinalEnrolmentEvaluation() {
        return EvaluationConfiguration.getInstance().getFinalEnrolmentEvaluation(this).orElse(null);
    }

    public Optional<EnrolmentEvaluation> getFinalEnrolmentEvaluationBySeason(EvaluationSeason season) {
        return EvaluationConfiguration.getInstance().getFinalEnrolmentEvaluation(this, season);
    }

    private Optional<EnrolmentEvaluation> getTemporaryEvaluation(EvaluationSeason season, ExecutionSemester semester) {
        return this.getEnrolmentEvaluation(season, semester, Boolean.FALSE);
    }

    public final List<Enrolment> getEnrolments() {
        return Collections.singletonList(this);
    }

    public final boolean hasAnyEnrolments() {
        return true;
    }

    public final StudentCurricularPlan getStudentCurricularPlan() {
        return this.getCurriculumGroup() != null ? this.getCurriculumGroup().getStudentCurricularPlan() : super.getStudentCurricularPlan();
    }

    public boolean isEnroledInExecutionPeriod(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        return this.isValid(executionSemester) && this.getCurricularCourse().equals((Object)curricularCourse);
    }

    public boolean isValid(ExecutionSemester executionSemester) {
        return this.getExecutionPeriod() == executionSemester || this.getCurricularCourse().isAnual() && this.getExecutionPeriod().getExecutionYear() == executionSemester.getExecutionYear();
    }

    public boolean isValid(ExecutionYear executionYear) {
        for (ExecutionSemester executionSemester : executionYear.getExecutionPeriodsSet()) {
            if (!this.isValid(executionSemester)) continue;
            return true;
        }
        return false;
    }

    public final boolean hasEnrolmentWithEnroledState(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        return this.isEnroledInExecutionPeriod(curricularCourse, executionSemester) && this.isEnroled();
    }

    public final Collection<ExecutionCourse> getExecutionCourses() {
        return this.getCurricularCourse().getAssociatedExecutionCoursesSet();
    }

    public final boolean isEnrolmentTypeNormal() {
        return this.getCurricularCourse().getType() == CurricularCourseType.NORMAL_COURSE && !this.isExtraCurricular() && !this.isOptional();
    }

    @Override
    public final String getEnrolmentTypeName() {
        if (this.isExtraCurricular()) {
            return "EXTRA_CURRICULAR_ENROLMENT";
        }
        if (this.isOptional()) {
            return "ENROLMENT_IN_OPTIONAL_DEGREE_MODULE";
        }
        return "COMPULSORY_ENROLMENT";
    }

    public static int countEvaluated(List<Enrolment> enrolments) {
        int result = 0;
        for (Enrolment enrolment : enrolments) {
            if (!enrolment.isEvaluated()) continue;
            ++result;
        }
        return result;
    }

    public static int countApproved(List<Enrolment> enrolments) {
        int result = 0;
        for (Enrolment enrolment : enrolments) {
            if (!enrolment.isEnrolmentStateApproved()) continue;
            ++result;
        }
        return result;
    }

    @Override
    public final Double getWeigth() {
        Function<ICurriculumEntry, BigDecimal> provider = EctsAndWeightProviderRegistry.getWeightProvider(Enrolment.class);
        if (provider != null) {
            BigDecimal providedValue = provider.apply(this);
            return providedValue != null ? Double.valueOf(providedValue.doubleValue()) : null;
        }
        return this.isExtraCurricular() || this.isPropaedeutic() ? Double.valueOf(0.0).doubleValue() : this.getWeigthForCurriculum().doubleValue();
    }

    @Override
    public final BigDecimal getWeigthForCurriculum() {
        CurricularCourse curricularCourse;
        Function<ICurriculumEntry, BigDecimal> provider = EctsAndWeightProviderRegistry.getWeightForCurriculumProvider(Enrolment.class);
        if (provider != null) {
            return provider.apply(this);
        }
        Double d = super.getWeigth() == null || super.getWeigth() == 0.0 ? ((curricularCourse = this.getCurricularCourse()) == null ? null : curricularCourse.getWeigth()) : super.getWeigth();
        return d == null ? BigDecimal.ZERO : BigDecimal.valueOf(d);
    }

    @Deprecated
    public final double getCredits() {
        return this.getEctsCredits();
    }

    @Override
    public final Double getEctsCredits() {
        Function<ICurriculumEntry, BigDecimal> provider = EctsAndWeightProviderRegistry.getEctsProvider(Enrolment.class);
        if (provider != null) {
            BigDecimal providedValue = provider.apply(this);
            return providedValue != null ? Double.valueOf(providedValue.doubleValue()) : null;
        }
        return this.getEctsCreditsForCurriculum().doubleValue();
    }

    @Override
    public final BigDecimal getEctsCreditsForCurriculum() {
        Function<ICurriculumEntry, BigDecimal> provider = EctsAndWeightProviderRegistry.getEctsForCurriculumProvider(Enrolment.class);
        if (provider != null) {
            return provider.apply(this);
        }
        return BigDecimal.valueOf(this.getCurricularCourse().getEctsCredits(this.getExecutionPeriod()));
    }

    public final Double getAprovedEctsCredits() {
        return this.isApproved() ? this.getEctsCredits() : Double.valueOf(0.0);
    }

    public final Double getCreditsConcluded(ExecutionYear executionYear) {
        return executionYear == null || this.getExecutionYear().isBeforeOrEquals(executionYear) ? this.getAprovedEctsCredits() : 0.0;
    }

    public final Double getEnroledEctsCredits(ExecutionSemester executionSemester) {
        return this.isValid(executionSemester) && this.isEnroled() ? this.getEctsCredits() : Double.valueOf(0.0);
    }

    public final Double getEnroledEctsCredits(ExecutionYear executionYear) {
        return this.isValid(executionYear) && this.isEnroled() ? this.getEctsCredits() : Double.valueOf(0.0);
    }

    public final Enrolment findEnrolmentFor(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        return this.isEnroledInExecutionPeriod(curricularCourse, executionSemester) ? this : null;
    }

    public final Enrolment getApprovedEnrolment(CurricularCourse curricularCourse) {
        return this.isApproved(curricularCourse) ? this : null;
    }

    public Set<IDegreeModuleToEvaluate> getDegreeModulesToEvaluate(ExecutionSemester executionSemester) {
        if (this.isValid(executionSemester) && this.isEnroled()) {
            if (this.isFromExternalDegree()) {
                return Collections.singleton(new ExternalDegreeEnrolmentWrapper(this, executionSemester));
            }
            return Collections.singleton(new EnroledEnrolmentWrapper(this, executionSemester));
        }
        return Collections.emptySet();
    }

    private boolean isFromExternalDegree() {
        return this.getDegreeModule().getParentDegreeCurricularPlan() != this.getDegreeCurricularPlanOfDegreeModule();
    }

    public final double getAccumulatedEctsCredits(ExecutionSemester executionSemester) {
        return this.isBolonhaDegree() && !this.parentAllowAccumulatedEctsCredits() ? 0.0 : this.getStudentCurricularPlan().getAccumulatedEctsCredits(executionSemester, this.getCurricularCourse());
    }

    @Override
    public final String getDescription() {
        return this.getStudentCurricularPlan().getDegree().getPresentationName(this.getExecutionYear()) + " > " + this.getName().getContent();
    }

    @Override
    public final Thesis getThesis() {
        Set theses = this.getThesesSet();
        switch (theses.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Thesis)((Object)theses.iterator().next());
            }
        }
        TreeSet<Thesis> sortedTheses = new TreeSet<Thesis>(new Comparator<Thesis>(){

            @Override
            public int compare(Thesis o1, Thesis o2) {
                return o2.getCreation().compareTo((ReadableInstant)o1.getCreation());
            }
        });
        sortedTheses.addAll(theses);
        return (Thesis)((Object)sortedTheses.iterator().next());
    }

    public final boolean isBefore(Enrolment enrolment) {
        return this.getExecutionPeriod().isBefore(enrolment.getExecutionPeriod());
    }

    public Thesis getPreviousYearThesis() {
        ExecutionYear executionYear = this.getExecutionYear().getPreviousExecutionYear();
        Enrolment enrolment = this.getStudent().getDissertationEnrolment(null, executionYear);
        if (enrolment != null && enrolment.getThesis() != null) {
            return enrolment.getThesis();
        }
        return null;
    }

    public Thesis getPossibleThesis() {
        Thesis thesis = this.getThesis();
        return thesis == null ? this.getPreviousYearThesis() : thesis;
    }

    @Override
    public final Unit getAcademicUnit() {
        return Bennu.getInstance().getInstitutionUnit();
    }

    @Override
    public final String getCode() {
        if (this.getDegreeModule() != null) {
            return this.getDegreeModule().getCode();
        }
        return null;
    }

    public boolean hasAnyAssociatedMarkSheetOrFinalGrade() {
        for (EnrolmentEvaluation enrolmentEvaluation : this.getEvaluationsSet()) {
            if (enrolmentEvaluation.getMarkSheet() == null && !enrolmentEvaluation.isFinal()) continue;
            return true;
        }
        return false;
    }

    public boolean hasEnrolment(ExecutionSemester executionSemester) {
        return this.isValid(executionSemester);
    }

    public boolean hasEnrolment(ExecutionYear executionYear) {
        return this.isValid(executionYear);
    }

    public boolean isEnroledInSpecialSeason(ExecutionSemester executionSemester) {
        return this.isValid(executionSemester) && this.hasSpecialSeason();
    }

    public boolean isEnroledInSpecialSeason(ExecutionYear executionYear) {
        return this.isValid(executionYear) && this.hasSpecialSeason();
    }

    public int getNumberOfAllApprovedEnrolments(ExecutionSemester executionSemester) {
        return this.isValid(executionSemester) && this.isApproved() ? 1 : 0;
    }

    public boolean canBeSubmittedForOldMarkSheet(EvaluationSeason season) {
        if (season.isNormal() && this.getEvaluationsSet().isEmpty()) {
            return true;
        }
        for (EnrolmentEvaluation enrolmentEvaluation : this.getEvaluationsSet()) {
            if (!enrolmentEvaluation.getEvaluationSeason().equals(season) || enrolmentEvaluation.getMarkSheet() != null || !enrolmentEvaluation.isTemporary() && (!enrolmentEvaluation.isNotEvaluated() || enrolmentEvaluation.getExamDateYearMonthDay() != null)) continue;
            return true;
        }
        return false;
    }

    public boolean isSourceOfAnyCreditsInCurriculum() {
        for (InternalEnrolmentWrapper enrolmentWrapper : this.getEnrolmentWrappersSet()) {
            if (!enrolmentWrapper.getCredits().hasAnyDismissalInCurriculum()) continue;
            return true;
        }
        return false;
    }

    public static Enrolment getEnrolmentWithLastExecutionPeriod(List<Enrolment> enrolments) {
        Collections.sort(enrolments, REVERSE_COMPARATOR_BY_EXECUTION_PERIOD_AND_ID);
        return enrolments.iterator().next();
    }

    static Enrolment createBasedOn(OptionalEnrolment optionalEnrolment, CurriculumGroup curriculumGroup) {
        Enrolment.checkParameters(optionalEnrolment, curriculumGroup);
        Enrolment enrolment = new Enrolment();
        enrolment.setCurricularCourse(optionalEnrolment.getCurricularCourse());
        enrolment.setWeigth(optionalEnrolment.getWeigth());
        enrolment.setEnrollmentState(optionalEnrolment.getEnrollmentState());
        enrolment.setExecutionPeriod(optionalEnrolment.getExecutionPeriod());
        enrolment.setEvaluationSeason(optionalEnrolment.getEvaluationSeason());
        enrolment.setCreatedBy(Authenticate.getUser().getUsername());
        enrolment.setCreationDateDateTime(optionalEnrolment.getCreationDateDateTime());
        enrolment.setEnrolmentCondition(optionalEnrolment.getEnrolmentCondition());
        enrolment.setCurriculumGroup(curriculumGroup);
        enrolment.getEvaluationsSet().addAll(optionalEnrolment.getEvaluationsSet());
        enrolment.getProgramCertificateRequestsSet().addAll(optionalEnrolment.getProgramCertificateRequestsSet());
        enrolment.getCourseLoadRequestsSet().addAll(optionalEnrolment.getCourseLoadRequestsSet());
        enrolment.getExtraExamRequestsSet().addAll(optionalEnrolment.getExtraExamRequestsSet());
        enrolment.getEnrolmentWrappersSet().addAll(optionalEnrolment.getEnrolmentWrappersSet());
        enrolment.getThesesSet().addAll(optionalEnrolment.getThesesSet());
        enrolment.getExamDateCertificateRequestsSet().addAll(optionalEnrolment.getExamDateCertificateRequestsSet());
        Enrolment.changeAttends((Enrolment)((Object)optionalEnrolment), enrolment);
        enrolment.createCurriculumLineLog(EnrolmentAction.ENROL);
        return enrolment;
    }

    public void setCurriculumGroup(CurriculumGroup curriculumGroup) {
        super.setCurriculumGroup(curriculumGroup);
        if (curriculumGroup != null) {
            curriculumGroup.getStudentCurricularPlan().setIsFirstTimeToNull();
        }
    }

    protected static void changeAttends(Enrolment from, Enrolment to) {
        Registration newRegistration;
        Registration oldRegistration = from.getRegistration();
        if (oldRegistration != (newRegistration = to.getRegistration())) {
            for (Attends attend : from.getAttendsSet()) {
                oldRegistration.changeShifts(attend, newRegistration);
                attend.setRegistration(newRegistration);
            }
        }
        to.getAttendsSet().addAll(from.getAttendsSet());
    }

    private static void checkParameters(OptionalEnrolment optionalEnrolment, CurriculumGroup curriculumGroup) {
        if (optionalEnrolment == null) {
            throw new DomainException("error.Enrolment.invalid.optionalEnrolment", new String[0]);
        }
        if (curriculumGroup == null) {
            throw new DomainException("error.Enrolment.invalid.curriculumGroup", new String[0]);
        }
    }

    @Override
    public boolean isAnual() {
        CurricularCourse curricularCourse = this.getCurricularCourse();
        return curricularCourse != null && curricularCourse.isAnual();
    }

    public boolean hasAnyNonTemporaryEvaluations() {
        for (EnrolmentEvaluation evaluation : this.getEvaluationsSet()) {
            if (EnrolmentEvaluationState.TEMPORARY_OBJ.equals(evaluation.getEnrolmentEvaluationState())) continue;
            return true;
        }
        return false;
    }

    public boolean canBeUsedAsCreditsSource() {
        return !this.isInvisible() && this.isApproved() && !this.parentIsInternalCreditsGroup();
    }

    private boolean parentIsInternalCreditsGroup() {
        return this.getCurriculumGroup() instanceof InternalCreditsSourceCurriculumGroup;
    }

    public boolean isDissertation() {
        return this.getCurricularCourse().isDissertation();
    }

    public String getModuleTypeName() {
        return BundleUtil.getString((String)"resources.EnumerationResources", (String)this.getClass().getName(), (String[])new String[0]);
    }

    @ConsistencyPredicate
    public boolean checkThesisMultiplicity() {
        return this.getThesesSet().size() <= 2;
    }

    public void annul() {
        this.setEnrollmentState(EnrollmentState.ANNULED);
    }

    public void activate() {
        if (!this.isActive()) {
            Grade finalGrade = this.getGrade();
            this.setEnrollmentState(finalGrade.isEmpty() ? EnrollmentState.ENROLLED : finalGrade.getEnrolmentState());
        }
    }

    public static abstract class EnrolmentPredicate
    implements java.util.function.Predicate<Enrolment> {
        private EvaluationSeason evaluationSeason;
        private ExecutionSemester executionSemester;
        private EnrolmentEvaluationContext context;

        public EvaluationSeason getEvaluationSeason() {
            return this.evaluationSeason;
        }

        public ExecutionSemester getExecutionSemester() {
            return this.executionSemester;
        }

        public EnrolmentEvaluationContext getContext() {
            return this.context;
        }

        public EnrolmentPredicate fill(EvaluationSeason season, ExecutionSemester semester, EnrolmentEvaluationContext context) {
            this.evaluationSeason = season;
            this.executionSemester = semester;
            this.context = context;
            return this;
        }

        public boolean testExceptionless(Enrolment input) {
            try {
                return this.test(input);
            }
            catch (Throwable t) {
                return false;
            }
        }
    }
}

