/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.CoordinationTeamLog;
import org.fenixedu.academic.domain.Coordinator$callable$createCoordinator;
import org.fenixedu.academic.domain.Coordinator$callable$removeCoordinator;
import org.fenixedu.academic.domain.Coordinator$callable$setAsNotResponsible;
import org.fenixedu.academic.domain.Coordinator$callable$setAsResponsible;
import org.fenixedu.academic.domain.CoordinatorLog;
import org.fenixedu.academic.domain.Coordinator_Base;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.OperationType;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class Coordinator
extends Coordinator_Base {
    public static final Advice advice$createCoordinator = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$removeCoordinator = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$setAsResponsible = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$setAsNotResponsible = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    private Coordinator() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    private Coordinator(ExecutionDegree executionDegree, Person person, Boolean responsible) {
        this();
        for (Coordinator coordinator : executionDegree.getCoordinatorsListSet()) {
            if (coordinator.getPerson() != person) continue;
            throw new Error("error.person.already.is.coordinator.for.same.execution.degree");
        }
        this.setExecutionDegree(executionDegree);
        this.setPerson(person);
        this.setResponsible(responsible);
    }

    public void delete() throws DomainException {
        this.setExecutionDegree(null);
        this.setPerson(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public boolean isResponsible() {
        return this.getResponsible();
    }

    public Teacher getTeacher() {
        return this.getPerson().getTeacher();
    }

    public static Coordinator createCoordinator(ExecutionDegree executionDegree, Person person, Boolean bl) {
        return (Coordinator)((Object)advice$createCoordinator.perform((Callable)new Coordinator$callable$createCoordinator(executionDegree, person, bl)));
    }

    static /* synthetic */ Coordinator advised$createCoordinator(ExecutionDegree executionDegree, Person person, Boolean responsible) {
        CoordinationTeamLog.createLog(executionDegree.getDegree(), executionDegree.getExecutionYear(), "resources.MessagingResources", "log.degree.coordinationteam.addmember", person.getPresentationName(), executionDegree.getPresentationName());
        return new Coordinator(executionDegree, person, responsible);
    }

    public void removeCoordinator() {
        Object object = advice$removeCoordinator.perform((Callable)new Coordinator$callable$removeCoordinator(this));
    }

    static /* synthetic */ void advised$removeCoordinator(Coordinator this_) {
        this_.delete();
    }

    public void setAsResponsible(Person personAddingResponsible) {
    }

    public void setAsResponsible() {
        Object object = advice$setAsResponsible.perform((Callable)new Coordinator$callable$setAsResponsible(this));
    }

    static /* synthetic */ void advised$setAsResponsible(Coordinator this_) {
        this_.setResponsible(true);
    }

    public void setAsNotResponsible() {
        Object object = advice$setAsNotResponsible.perform((Callable)new Coordinator$callable$setAsNotResponsible(this));
    }

    static /* synthetic */ void advised$setAsNotResponsible(Coordinator this_) {
        this_.setResponsible(false);
    }

    public void makeAction(OperationType operationType, Person personMakingAction) {
        if (operationType.compareTo(OperationType.CHANGERESPONSIBLE_FALSE) == 0) {
            CoordinatorLog.createCoordinatorLog(new DateTime(), OperationType.CHANGERESPONSIBLE_FALSE, personMakingAction, this);
            this.setAsNotResponsible();
        } else if (operationType.compareTo(OperationType.CHANGERESPONSIBLE_TRUE) == 0) {
            CoordinatorLog.createCoordinatorLog(new DateTime(), OperationType.CHANGERESPONSIBLE_TRUE, personMakingAction, this);
            this.setAsResponsible();
        } else if (operationType.compareTo(OperationType.REMOVE) == 0) {
            CoordinatorLog.createCoordinatorLog(new DateTime(), OperationType.REMOVE, personMakingAction, this);
            this.removeCoordinator();
        }
    }

    public static Coordinator makeCreation(Person personMakingAction, ExecutionDegree executionDegree, Person person, Boolean responsible) {
        Coordinator coordinator = Coordinator.createCoordinator(executionDegree, person, responsible);
        CoordinatorLog.createCoordinatorLog(new DateTime(), OperationType.ADD, personMakingAction, coordinator);
        return coordinator;
    }
}

