/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.phd.candidacy.academicAdminOffice;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramDocumentType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProcessState;
import org.fenixedu.academic.domain.phd.PhdProgramCandidacyProcessState;
import org.fenixedu.academic.domain.phd.PhdProgramDocumentUploadBean;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcess;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcessBean;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcessStateBean;
import org.fenixedu.academic.domain.phd.candidacy.RatifyCandidacyBean;
import org.fenixedu.academic.domain.phd.candidacy.RegistrationFormalizationBean;
import org.fenixedu.academic.domain.phd.candidacy.activities.AddNotification;
import org.fenixedu.academic.domain.phd.candidacy.activities.AddState;
import org.fenixedu.academic.domain.phd.candidacy.activities.AssociateRegistration;
import org.fenixedu.academic.domain.phd.candidacy.activities.DeleteDocument;
import org.fenixedu.academic.domain.phd.candidacy.activities.EditProcessAttributes;
import org.fenixedu.academic.domain.phd.candidacy.activities.RatifyCandidacy;
import org.fenixedu.academic.domain.phd.candidacy.activities.RegistrationFormalization;
import org.fenixedu.academic.domain.phd.candidacy.activities.RemoveLastState;
import org.fenixedu.academic.domain.phd.candidacy.activities.RequestCandidacyReview;
import org.fenixedu.academic.domain.phd.candidacy.activities.UploadDocuments;
import org.fenixedu.academic.domain.phd.exceptions.PhdDomainOperationException;
import org.fenixedu.academic.domain.phd.notification.PhdNotification;
import org.fenixedu.academic.domain.phd.notification.PhdNotificationBean;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessBean;
import org.fenixedu.academic.dto.person.ChoosePersonBean;
import org.fenixedu.academic.dto.person.PersonBean;
import org.fenixedu.academic.report.phd.notification.PhdCandidacyDeclarationDocument;
import org.fenixedu.academic.report.phd.notification.PhdNotificationDocument;
import org.fenixedu.academic.service.services.caseHandling.CreateNewProcess;
import org.fenixedu.academic.service.services.caseHandling.ExecuteProcessActivity;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.phd.PhdProcessStateBean;
import org.fenixedu.academic.ui.struts.action.phd.academicAdminOffice.PhdIndividualProgramProcessDA;
import org.fenixedu.academic.ui.struts.action.phd.candidacy.CommonPhdCandidacyDA;
import org.fenixedu.academic.util.report.ReportsUtils;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyConverter;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@Mapping(path="/phdProgramCandidacyProcess", module="academicAdministration", functionality=PhdIndividualProgramProcessDA.class)
@Forwards(value={@Forward(name="searchPerson", path="/phd/candidacy/academicAdminOffice/searchPerson.jsp"), @Forward(name="createCandidacy", path="/phd/candidacy/academicAdminOffice/createCandidacy.jsp"), @Forward(name="manageProcesses", path="/academicAdministration/phdIndividualProgramProcess.do?method=manageProcesses"), @Forward(name="editCandidacyInformation", path="/phd/candidacy/academicAdminOffice/editCandidacyInformation.jsp"), @Forward(name="manageCandidacyDocuments", path="/phd/candidacy/academicAdminOffice/manageCandidacyDocuments.jsp"), @Forward(name="requestCandidacyReview", path="/phd/candidacy/academicAdminOffice/requestCandidacyReview.jsp"), @Forward(name="manageCandidacyReview", path="/phd/candidacy/academicAdminOffice/manageCandidacyReview.jsp"), @Forward(name="rejectCandidacyProcess", path="/phd/candidacy/academicAdminOffice/rejectCandidacyProcess.jsp"), @Forward(name="ratifyCandidacy", path="/phd/candidacy/academicAdminOffice/ratifyCandidacy.jsp"), @Forward(name="viewProcess", path="/academicAdministration/phdIndividualProgramProcess.do?method=viewProcess"), @Forward(name="manageNotifications", path="/phd/candidacy/academicAdminOffice/manageNotifications.jsp"), @Forward(name="createNotification", path="/phd/candidacy/academicAdminOffice/createNotification.jsp"), @Forward(name="registrationFormalization", path="/phd/candidacy/academicAdminOffice/registrationFormalization.jsp"), @Forward(name="associateRegistration", path="/phd/candidacy/academicAdminOffice/associateRegistration.jsp"), @Forward(name="manageStates", path="/phd/candidacy/academicAdminOffice/manageStates.jsp"), @Forward(name="editProcessAttributes", path="/phd/candidacy/academicAdminOffice/editProcessAttributes.jsp"), @Forward(name="editPhdProcessState", path="/phd/candidacy/academicAdminOffice/editState.jsp"), @Forward(name="viewLogs", path="/phd/candidacy/academicAdminOffice/logs/viewLogs.jsp")})
public class PhdProgramCandidacyProcessDA
extends CommonPhdCandidacyDA {
    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        if (process2 != null) {
            request.setAttribute("processId", (Object)process2.getExternalId());
            request.setAttribute("process", (Object)process2);
        }
        return super.execute(mapping, actionForm, request, response);
    }

    public ActionForward prepareSearchPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean bean = new PhdProgramCandidacyProcessBean();
        bean.setState(PhdProgramCandidacyProcessState.STAND_BY_WITH_MISSING_INFORMATION);
        bean.setPersonBean(new PersonBean());
        bean.setChoosePersonBean(new ChoosePersonBean());
        request.setAttribute("createCandidacyBean", (Object)bean);
        request.setAttribute("persons", Collections.emptyList());
        return mapping.findForward("searchPerson");
    }

    public ActionForward searchPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        PhdProgramCandidacyProcessBean bean = this.getCreateCandidacyProcessBean();
        request.setAttribute("createCandidacyBean", (Object)bean);
        ChoosePersonBean choosePersonBean = this.getCreateCandidacyProcessBean().getChoosePersonBean();
        if (!choosePersonBean.hasPerson()) {
            if (choosePersonBean.isFirstTimeSearch()) {
                Collection<Person> persons = Person.findPersonByDocumentID(choosePersonBean.getIdentificationNumber());
                choosePersonBean.setFirstTimeSearch(false);
                if (this.showSimilarPersons(choosePersonBean, persons)) {
                    RenderUtils.invalidateViewState();
                    return mapping.findForward("searchPerson");
                }
            }
            bean.setPersonBean(new PersonBean(choosePersonBean.getName(), choosePersonBean.getIdentificationNumber(), choosePersonBean.getDocumentType(), choosePersonBean.getDateOfBirth()));
            return mapping.findForward("createCandidacy");
        }
        bean.setPersonBean(new PersonBean(bean.getChoosePersonBean().getPerson()));
        return mapping.findForward("createCandidacy");
    }

    protected boolean showSimilarPersons(ChoosePersonBean choosePersonBean, Collection<Person> persons) {
        if (!persons.isEmpty()) {
            return true;
        }
        return !Person.findByDateOfBirth(choosePersonBean.getDateOfBirth(), Person.findPersonMatchingFirstAndLastName(choosePersonBean.getName())).isEmpty();
    }

    public ActionForward createCandidacyInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("createCandidacyBean", (Object)this.getCreateCandidacyProcessBean());
        return mapping.findForward("createCandidacy");
    }

    public ActionForward createCandidacyPostback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("createCandidacyBean", (Object)this.getCreateCandidacyProcessBean());
        RenderUtils.invalidateViewState();
        return mapping.findForward("createCandidacy");
    }

    public ActionForward createCandidacy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            if (!this.validateAreaCodeAndAreaOfAreaCode(request, this.getCreateCandidacyProcessBean().getChoosePersonBean().getPerson(), this.getCreateCandidacyProcessBean().getPersonBean().getCountryOfResidence(), this.getCreateCandidacyProcessBean().getPersonBean().getAreaCode(), this.getCreateCandidacyProcessBean().getPersonBean().getAreaOfAreaCode())) {
                request.setAttribute("createCandidacyBean", (Object)this.getCreateCandidacyProcessBean());
                return mapping.findForward("createCandidacy");
            }
            CreateNewProcess.run(PhdIndividualProgramProcess.class, (Object)this.getCreateCandidacyProcessBean());
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            request.setAttribute("createCandidacyBean", (Object)this.getCreateCandidacyProcessBean());
            return mapping.findForward("createCandidacy");
        }
        return mapping.findForward("manageProcesses");
    }

    private PhdProgramCandidacyProcessBean getCreateCandidacyProcessBean() {
        return (PhdProgramCandidacyProcessBean)this.getRenderedObject("createCandidacyBean");
    }

    public ActionForward cancelCreateCandidacy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("manageProcesses");
    }

    @Override
    public ActionForward manageCandidacyDocuments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.prepareDocumentsToUpload(request);
        return mapping.findForward("manageCandidacyDocuments");
    }

    private void prepareDocumentsToUpload(HttpServletRequest request) {
        request.setAttribute("documentsToUpload", Arrays.asList(new PhdProgramDocumentUploadBean(), new PhdProgramDocumentUploadBean(), new PhdProgramDocumentUploadBean(), new PhdProgramDocumentUploadBean(), new PhdProgramDocumentUploadBean()));
    }

    public ActionForward uploadDocumentsInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("documentsToUpload", this.getDocumentsToUpload());
        return mapping.findForward("manageCandidacyDocuments");
    }

    public ActionForward uploadDocuments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        if (!this.hasAnyDocumentToUpload()) {
            request.setAttribute("documentsToUpload", this.getDocumentsToUpload());
            this.addErrorMessage(request, "message.no.documents.to.upload", new String[0]);
            return mapping.findForward("manageCandidacyDocuments");
        }
        ActionForward result = this.executeActivity(UploadDocuments.class, this.getDocumentsToUpload(), request, mapping, "manageCandidacyDocuments", "manageCandidacyDocuments", "message.documents.uploaded.with.success", new String[0]);
        RenderUtils.invalidateViewState((String)"documentsToUpload");
        this.prepareDocumentsToUpload(request);
        return result;
    }

    protected boolean hasAnyDocumentToUpload() {
        for (PhdProgramDocumentUploadBean each : this.getDocumentsToUpload()) {
            if (!each.hasAnyInformation()) continue;
            return true;
        }
        return false;
    }

    protected List<PhdProgramDocumentUploadBean> getDocumentsToUpload() {
        return (List)this.getObjectFromViewState("documentsToUpload");
    }

    public ActionForward prepareRequestCandidacyReview(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        PhdProgramCandidacyProcessStateBean bean = new PhdProgramCandidacyProcessStateBean(process2.getIndividualProgramProcess());
        bean.setState(PhdProgramCandidacyProcessState.PENDING_FOR_COORDINATOR_OPINION);
        request.setAttribute("stateBean", (Object)bean);
        return mapping.findForward("requestCandidacyReview");
    }

    public ActionForward prepareRequestCandidacyReviewPostback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("stateBean", this.getRenderedObject("stateBean"));
        RenderUtils.invalidateViewState();
        return mapping.findForward("requestCandidacyReview");
    }

    public ActionForward requestCandidacyReview(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            PhdProgramCandidacyProcess process2 = this.getProcess(request);
            ExecuteProcessActivity.run((Process)((Object)process2), RequestCandidacyReview.class.getSimpleName(), this.getRenderedObject("stateBean"));
            return this.viewIndividualProgramProcess(request, process2);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            request.setAttribute("stateBean", this.getRenderedObject("stateBean"));
            return mapping.findForward("requestCandidacyReview");
        }
    }

    public ActionForward deleteDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.prepareDocumentsToUpload(request);
        return this.executeActivity(DeleteDocument.class, (Object)this.getDocument(request), request, mapping, "manageCandidacyDocuments", "manageCandidacyDocuments", "message.document.deleted.successfuly", new String[0]);
    }

    public ActionForward prepareRatifyCandidacy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("ratifyCandidacyBean", (Object)new RatifyCandidacyBean(this.getProcess(request)));
        return mapping.findForward("ratifyCandidacy");
    }

    public ActionForward prepareRatifyCandidacyInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("ratifyCandidacyBean", this.getRenderedObject("ratifyCandidacyBean"));
        return mapping.findForward("ratifyCandidacy");
    }

    public ActionForward ratifyCandidacy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        RatifyCandidacyBean bean = (RatifyCandidacyBean)this.getRenderedObject("ratifyCandidacyBean");
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), RatifyCandidacy.class, (Object)bean);
            this.addSuccessMessage(request, "message.candidacy.ratified.successfuly", new String[0]);
            request.setAttribute("processId", (Object)this.getProcess(request).getIndividualProgramProcess().getExternalId());
            return mapping.findForward("viewProcess");
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            request.setAttribute("ratifyCandidacyBean", (Object)bean);
            return mapping.findForward("ratifyCandidacy");
        }
    }

    public ActionForward manageNotifications(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("manageNotifications");
    }

    public ActionForward prepareCreateNotification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("notificationBean", (Object)new PhdNotificationBean(this.getProcess(request)));
        return mapping.findForward("createNotification");
    }

    public ActionForward prepareCreateNotificationInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("notificationBean", this.getRenderedObject("notificationBean"));
        return mapping.findForward("createNotification");
    }

    public ActionForward createNotification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdNotificationBean bean = (PhdNotificationBean)this.getRenderedObject("notificationBean");
        ActionForward result = this.executeActivity(AddNotification.class, bean, request, mapping, "createNotification", "manageNotifications", "message.notification.created.with.success", new String[0]);
        request.setAttribute("notificationBean", (Object)bean);
        return result;
    }

    private PhdNotification getNotification(HttpServletRequest request) {
        return (PhdNotification)((Object)this.getDomainObject(request, "notificationId"));
    }

    public ActionForward printNotification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        PhdNotificationDocument report = new PhdNotificationDocument(this.getNotification(request), this.getLanguage(request));
        this.writeFile(response, report.getReportFileName() + ".pdf", "application/pdf", ReportsUtils.generateReport(report).getData());
        return null;
    }

    private Locale getLanguage(HttpServletRequest request) {
        return new Locale.Builder().setLanguageTag(request.getParameter("language")).build();
    }

    public ActionForward markNotificationAsSent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.getNotification(request).markAsSent();
        return this.manageNotifications(mapping, form, request, response);
    }

    public ActionForward printCandidacyDeclaration(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        PhdCandidacyDeclarationDocument report = new PhdCandidacyDeclarationDocument(this.getProcess(request), this.getLanguage(request));
        this.writeFile(response, report.getReportFileName() + ".pdf", "application/pdf", ReportsUtils.generateReport(report).getData());
        return null;
    }

    public ActionForward prepareRegistrationFormalization(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.checkCandidacyPreConditions(request);
        RegistrationFormalizationBean bean = new RegistrationFormalizationBean(this.getProcess(request));
        request.setAttribute("registrationFormalizationBean", (Object)bean);
        return mapping.findForward("registrationFormalization");
    }

    private void checkCandidacyPreConditions(HttpServletRequest request) {
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        Person person = process2.getPerson();
        request.setAttribute("idDocument", (Object)process2.hasAnyDocuments(PhdIndividualProgramDocumentType.ID_DOCUMENT));
        request.setAttribute("personalPhoto", (Object)(process2.getPerson().getPersonalPhoto() != null ? 1 : 0));
        request.setAttribute("healthBulletin", (Object)process2.hasAnyDocuments(PhdIndividualProgramDocumentType.HEALTH_BULLETIN));
        request.setAttribute("habilitationsCertificates", (Object)(person.getAssociatedQualificationsSet().size() == process2.getDocumentsCount(PhdIndividualProgramDocumentType.HABILITATION_CERTIFICATE_DOCUMENT) ? 1 : 0));
        if (!process2.hasStudyPlan()) {
            this.addWarningMessage(request, "error.phd.candidacy.PhdProgramCandidacyProcess.registrationFormalization.must.create.study.plan", new String[0]);
        } else if (process2.isStudyPlanExempted()) {
            this.addWarningMessage(request, "message.phd.candidacy.registration.formalization.study.plan.is.exempted", new String[0]);
        }
    }

    public ActionForward registrationFormalizationInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.checkCandidacyPreConditions(request);
        request.setAttribute("registrationFormalizationBean", this.getRenderedObject("registrationFormalizationBean"));
        return mapping.findForward("registrationFormalization");
    }

    public ActionForward registrationFormalization(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            RegistrationFormalizationBean bean = (RegistrationFormalizationBean)this.getRenderedObject("registrationFormalizationBean");
            if (!bean.hasRegistration() && this.mustSelectFirstAnyRegistratiom(request)) {
                bean.setSelectRegistration(true);
                return this.registrationFormalizationInvalid(mapping, actionForm, request, response);
            }
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), RegistrationFormalization.class, (Object)bean);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            return this.registrationFormalizationInvalid(mapping, actionForm, request, response);
        }
        return this.viewIndividualProgramProcess(request, this.getProcess(request));
    }

    private boolean mustSelectFirstAnyRegistratiom(HttpServletRequest request) {
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        return process2.hasStudyPlan() && process2.hasPhdProgram() && process2.hasActiveRegistrationFor(process2.getPhdProgramLastActiveDegreeCurricularPlan());
    }

    public ActionForward prepareAssociateRegistration(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcess process2 = this.getProcess(request);
        RegistrationFormalizationBean bean = new RegistrationFormalizationBean(process2);
        bean.setWhenStartedStudies(process2.getWhenStartedStudies());
        request.setAttribute("registrationFormalizationBean", (Object)bean);
        return mapping.findForward("associateRegistration");
    }

    public ActionForward associateRegistrationInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("registrationFormalizationBean", this.getRenderedObject("registrationFormalizationBean"));
        return mapping.findForward("associateRegistration");
    }

    public ActionForward associateRegistration(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), AssociateRegistration.class, this.getRenderedObject("registrationFormalizationBean"));
            this.addSuccessMessage(request, "message.registration.associated.successfuly", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            return this.associateRegistrationInvalid(mapping, actionForm, request, response);
        }
        return this.viewIndividualProgramProcess(request, this.getProcess(request));
    }

    public ActionForward manageStates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean bean = new PhdProgramCandidacyProcessBean(this.getProcess(request));
        request.setAttribute("processBean", (Object)bean);
        return mapping.findForward("manageStates");
    }

    public ActionForward addState(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            PhdProgramCandidacyProcessBean bean = (PhdProgramCandidacyProcessBean)this.getRenderedObject("processBean");
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), AddState.class, (Object)bean);
        }
        catch (PhdDomainOperationException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
        }
        RenderUtils.invalidateViewState();
        return this.manageStates(mapping, form, request, response);
    }

    public ActionForward addStateInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdThesisProcessBean bean = (PhdThesisProcessBean)this.getRenderedObject("thesisProcessBean");
        request.setAttribute("thesisProcessBean", (Object)bean);
        return mapping.findForward("manageStates");
    }

    public ActionForward removeLastState(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean bean = (PhdProgramCandidacyProcessBean)this.getRenderedObject("processBean");
        try {
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), RemoveLastState.class, (Object)bean);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
        }
        RenderUtils.invalidateViewState();
        return this.manageStates(mapping, form, request, response);
    }

    public ActionForward prepareEditProcessAttributes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean bean = new PhdProgramCandidacyProcessBean(this.getProcess(request));
        request.setAttribute("processBean", (Object)bean);
        return mapping.findForward("editProcessAttributes");
    }

    public ActionForward editProcessAttributesInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("processBean", this.getRenderedObject("processBean"));
        return mapping.findForward("editProcessAttributes");
    }

    public ActionForward editProcessAttributes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean bean = (PhdProgramCandidacyProcessBean)this.getRenderedObject("processBean");
        ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), EditProcessAttributes.class, (Object)bean);
        return this.viewIndividualProgramProcess(mapping, form, request, response);
    }

    public ActionForward prepareEditState(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProcessState state = (PhdProcessState)((Object)this.getDomainObject(request, "stateId"));
        PhdProcessStateBean bean = new PhdProcessStateBean(state);
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("editPhdProcessState");
    }

    public ActionForward editState(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProcessStateBean bean = (PhdProcessStateBean)this.getRenderedObject("bean");
        bean.getState().editStateDate(bean);
        return this.manageStates(mapping, form, request, response);
    }

    public ActionForward editStateInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProcessStateBean bean = (PhdProcessStateBean)this.getRenderedObject("bean");
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("editPhdProcessState");
    }

    public ActionForward viewLogs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("viewLogs");
    }

    public static class PhdRegistrationFormalizationRegistrations
    implements DataProvider {
        public Converter getConverter() {
            return new DomainObjectKeyConverter();
        }

        public Object provide(Object source, Object currentValue) {
            RegistrationFormalizationBean bean = (RegistrationFormalizationBean)source;
            return bean.getAvailableRegistrationsToAssociate();
        }
    }
}

