/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.student.candidacy.registrations;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.candidacy.StudentCandidacy;
import org.fenixedu.academic.domain.contacts.EmailAddress;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.candidacy.registrations.RegisteredDegreeCandidaciesSelectionBean;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import org.joda.time.LocalDate;

public class RegisteredDegreeCandidaciesWithApplyForResidence {
    private final RegisteredDegreeCandidaciesSelectionBean bean;

    public RegisteredDegreeCandidaciesWithApplyForResidence(RegisteredDegreeCandidaciesSelectionBean registeredDegreeCandidaciesSelectionBean) {
        this.bean = registeredDegreeCandidaciesSelectionBean;
    }

    public List<StudentCandidacy> search(Set<Degree> allowedDegrees) {
        List<StudentCandidacy> degreeCandidacies = this.bean.search(allowedDegrees);
        ArrayList<StudentCandidacy> result = new ArrayList<StudentCandidacy>();
        for (StudentCandidacy studentCandidacy : degreeCandidacies) {
            if ((studentCandidacy.getApplyForResidence() == null || !studentCandidacy.getApplyForResidence().booleanValue()) && StringUtils.isEmpty((String)studentCandidacy.getNotesAboutResidenceAppliance())) continue;
            result.add(studentCandidacy);
        }
        Collections.sort(result, RegisteredDegreeCandidaciesSelectionBean.DEGREE_CANDIDACIES_COMPARATOR);
        return result;
    }

    public Spreadsheet export(Set<Degree> allowedDegrees) {
        Spreadsheet spreadsheet = new Spreadsheet("Candidatura a Residencia");
        this.addHeaders(spreadsheet);
        for (StudentCandidacy candidacy : this.search(allowedDegrees)) {
            this.addRow(spreadsheet, candidacy);
        }
        return spreadsheet;
    }

    public String getFilename() {
        return new LocalDate().toString("dd-MM-yyyy") + ".Candidatos.Residencia.xls";
    }

    private void addHeaders(Spreadsheet spreadsheet) {
        spreadsheet.setHeader("Data de Matricula");
        spreadsheet.setHeader("Curso");
        spreadsheet.setHeader("N\u00ba de Aluno");
        spreadsheet.setHeader("Nome");
        spreadsheet.setHeader("Nota de Seriacao");
        spreadsheet.setHeader("Localidade");
        spreadsheet.setHeader("Concelho");
        spreadsheet.setHeader("Distrito");
        spreadsheet.setHeader("Email " + Unit.getInstitutionAcronym());
        spreadsheet.setHeader("Email pessoal");
        spreadsheet.setHeader("Telefone");
        spreadsheet.setHeader("Telemovel");
        spreadsheet.setHeader("Candidatou-se");
        spreadsheet.setHeader("Nota sobre Candidatura");
    }

    private void addRow(Spreadsheet spreadsheet, StudentCandidacy candidacy) {
        Person person = candidacy.getPerson();
        Spreadsheet.Row row = spreadsheet.addRow();
        row.setCell(candidacy.getActiveCandidacySituation().getSituationDate().toString("dd/MM/yyyy HH:mm"));
        row.setCell(candidacy.getExecutionDegree().getDegree().getNameFor(ExecutionYear.readCurrentExecutionYear()).getContent());
        row.setCell(candidacy.getRegistration().getStudent().getNumber());
        row.setCell(person.getName());
        row.setCell(this.getEntryGrade(candidacy));
        row.setCell(person.getArea());
        row.setCell(person.getDistrictSubdivisionOfResidence());
        row.setCell(person.getDistrictOfResidence());
        row.setCell(person.getInstitutionalEmailAddressValue());
        row.setCell(this.getPersonalEmailAddress(person));
        row.setCell(this.getPhone(person));
        row.setCell(this.getMobilePhone(person));
        row.setCell(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)(candidacy.getApplyForResidence() != false ? "label.yes" : "label.no"), (String[])new String[0]));
        row.setCell(candidacy.getNotesAboutResidenceAppliance().replaceAll("\n", " ").replaceAll("\r", " "));
    }

    private BigDecimal getEntryGrade(StudentCandidacy candidacy) {
        return new BigDecimal(candidacy.getEntryGrade()).setScale(2, 6);
    }

    private String getPersonalEmailAddress(Person person) {
        for (EmailAddress email : person.getEmailAddresses()) {
            if (!email.isPersonalType() || !email.hasValue()) continue;
            return email.getValue();
        }
        return "";
    }

    private String getPhone(Person person) {
        return person.hasDefaultPhone() && person.getDefaultPhone().hasNumber() ? person.getDefaultPhone().getNumber() : "";
    }

    private String getMobilePhone(Person person) {
        return person.hasDefaultMobilePhone() && person.getDefaultMobilePhone().hasNumber() ? person.getDefaultMobilePhone().getNumber() : "";
    }
}

