/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.providers;

import java.util.ArrayList;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.dto.teacher.ImportLessonPlanningsBean;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyConverter;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class ListShiftsToImportLessonPlanningsProvider
implements DataProvider {
    public Object provide(Object source, Object currentValue) {
        ImportLessonPlanningsBean bean = (ImportLessonPlanningsBean)source;
        TreeSet<Shift> shifts = new TreeSet<Shift>(Shift.SHIFT_COMPARATOR_BY_TYPE_AND_ORDERED_LESSONS);
        ExecutionCourse executionCourseFrom = bean.getExecutionCourse();
        ExecutionCourse executionCourseTo = bean.getExecutionCourseTo();
        if (executionCourseFrom != null && executionCourseTo != null) {
            ArrayList<ShiftType> shiftTypesTo = new ArrayList<ShiftType>();
            for (ShiftType shiftType : executionCourseTo.getShiftTypes()) {
                if (!executionCourseTo.hasCourseLoadForType(shiftType)) continue;
                shiftTypesTo.add(shiftType);
            }
            for (Shift shift : executionCourseFrom.getAssociatedShifts()) {
                if (!CollectionUtils.containsAny(shiftTypesTo, shift.getTypes())) continue;
                shifts.add(shift);
            }
            if (shifts.isEmpty()) {
                return executionCourseFrom.getAssociatedShifts();
            }
        }
        return shifts;
    }

    public Converter getConverter() {
        return new DomainObjectKeyConverter();
    }
}

