/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report.academicAdministrativeOffice;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.AcademicServiceRequestEvent;
import org.fenixedu.academic.domain.accounting.postingRules.serviceRequests.phd.PhdFinalizationCertificateRequestPR;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.serviceRequests.documentRequests.certificates.PhdFinalizationCertificateRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IDocumentRequest;
import org.fenixedu.academic.report.academicAdministrativeOffice.AdministrativeOfficeDocument;
import org.fenixedu.academic.util.FenixStringTools;
import org.fenixedu.academic.util.Money;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;

public class PhdFinalizationCertificate
extends AdministrativeOfficeDocument {
    protected static final int LINE_LENGTH = 70;

    PhdFinalizationCertificate(IDocumentRequest documentRequest) {
        super(documentRequest);
    }

    protected PhdFinalizationCertificateRequest getDocumentRequest() {
        return (PhdFinalizationCertificateRequest)((Object)super.getDocumentRequest());
    }

    @Override
    protected String getDegreeDescription() {
        PhdIndividualProgramProcess phdIndividualProgramProcess = this.getDocumentRequest().getPhdIndividualProgramProcess();
        return phdIndividualProgramProcess.getPhdProgram().getName().getContent(this.getLanguage());
    }

    @Override
    protected void addPriceFields() {
        AcademicServiceRequestEvent event = this.getDocumentRequest().getEvent();
        PhdFinalizationCertificateRequestPR postingRule = (PhdFinalizationCertificateRequestPR)((Object)event.getPostingRule());
        this.addParameter("originalAmount", postingRule.getFixedAmount().toString());
        this.addParameter("urgentAmount", this.getDocumentRequest().isUrgentRequest() ? postingRule.getFixedAmount().toString() : Money.ZERO.toString());
        this.addParameter("totalAmount", event.getOriginalAmountToPay().toString());
    }

    @Override
    protected void setPersonFields() {
        Person person = this.getDocumentRequest().getPerson();
        StringBuilder builder1 = new StringBuilder();
        if (this.getLanguage().equals(MultiLanguageString.pt)) {
            builder1.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.with", (String[])new String[0])).append(" ");
        }
        builder1.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.finalization.certificate.identity.card", (String[])new String[0]));
        builder1.append(" ").append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.number.short", (String[])new String[0]));
        builder1.append(" ").append(person.getDocumentIdNumber());
        StringBuilder builder2 = new StringBuilder();
        builder2.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"documents.birthLocale", (String[])new String[0]));
        builder2.append(" ").append(this.getBirthLocale(person, false));
        if (this.getDocumentRequest().getDocumentRequestType().equals((Object)DocumentRequestType.APPROVEMENT_MOBILITY_CERTIFICATE)) {
            this.addParameter("name", person.getName().toUpperCase());
            this.addParameter("documentIdNumber", builder1.toString());
            this.addParameter("birthLocale", builder2.toString());
        } else {
            this.addParameter("name", FenixStringTools.multipleLineRightPad(person.getName().toUpperCase(), 70, '-'));
            this.addParameter("documentIdNumber", FenixStringTools.multipleLineRightPad(builder1.toString(), 70, '-'));
            this.addParameter("birthLocale", FenixStringTools.multipleLineRightPad(builder2.toString(), 70, '-'));
        }
        this.setNationality(person);
    }

    @Override
    protected void setNationality(Person person) {
        StringBuilder builder = new StringBuilder();
        if (this.getLanguage().equals(MultiLanguageString.pt)) {
            builder.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.and", (String[])new String[0])).append(" ");
        }
        builder.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"documents.nationality.one", (String[])new String[0]));
        String nationality = person.getCountry().getFilteredNationality(this.getLocale());
        builder.append(" ").append(nationality.toUpperCase()).append(" ");
        if (this.getDocumentRequest().getDocumentRequestType().equals((Object)DocumentRequestType.APPROVEMENT_MOBILITY_CERTIFICATE)) {
            this.addParameter("nationality", builder.toString());
        } else {
            this.addParameter("nationality", FenixStringTools.multipleLineRightPad(builder.toString(), 70, '-'));
        }
    }

    @Override
    protected void fillReport() {
        super.fillReport();
        Person coordinator = this.getAdministrativeOffice().getCoordinator().getPerson();
        String coordinatorTitle = this.getCoordinatorGender(coordinator);
        this.fillFirstParagraph(coordinator, coordinatorTitle);
        this.addPersonalInfo();
        this.setFooter(this.getDocumentRequest());
        this.addProgrammeInfo();
        this.fillInstitutionAndStaffFields();
    }

    private void setFooter(PhdFinalizationCertificateRequest documentRequest) {
        PhdIndividualProgramProcess phdIndividualProgramProcess = this.getDocumentRequest().getPhdIndividualProgramProcess();
        String student = phdIndividualProgramProcess.getStudent().getPerson().isMale() ? BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.maleStudent", (String[])new String[0]) : BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.femaleStudent", (String[])new String[0]);
        StringBuilder studentNumber = new StringBuilder();
        String stringTemplate = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.footer.studentNumber", (String[])new String[0]);
        studentNumber.append(MessageFormat.format(stringTemplate, student, phdIndividualProgramProcess.getStudent().getNumber().toString()));
        studentNumber.append("/D");
        this.addParameter("studentNumber", studentNumber.toString());
        StringBuilder documentNumber = new StringBuilder();
        stringTemplate = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.serviceRequestNumberYear", (String[])new String[0]);
        documentNumber.append(stringTemplate);
        documentNumber.append(": ");
        documentNumber.append(documentRequest.getServiceRequestNumberYear());
        this.addParameter("documentNumber", documentNumber.toString());
    }

    protected void fillFirstParagraph(Person coordinator, String coordinatorTitle) {
        String adminOfficeName = this.getI18NText(this.getAdministrativeOffice().getName());
        String institutionName = this.getInstitutionName();
        String universityName = this.getUniversityName(new DateTime());
        String stringTemplate = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.academicDocument.declaration.firstParagraph", (String[])new String[0]);
        this.addParameter("firstParagraph", "     " + MessageFormat.format(stringTemplate, coordinator.getName(), coordinatorTitle, adminOfficeName.toUpperCase(this.getLocale()), institutionName.toUpperCase(this.getLocale()), universityName.toUpperCase(this.getLocale())));
        this.addParameter("certificate", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"message.phd.finalization.certificate.certifies.that", (String[])new String[0]));
    }

    private void addProgrammeInfo() {
        PhdIndividualProgramProcess phdIndividualProgramProcess = this.getDocumentRequest().getPhdIndividualProgramProcess();
        String stringTemplate = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.finalization.certificate.concluded.in", (String[])new String[0]);
        String conclusionDate = MessageFormat.format(stringTemplate, phdIndividualProgramProcess.getConclusionDate().toString("dd/MM/yyyy"));
        this.addParameter("conclusionDate", conclusionDate);
        StringBuilder thesisTitle = new StringBuilder();
        thesisTitle.append("\"");
        thesisTitle.append(this.getThesisTitle(phdIndividualProgramProcess));
        thesisTitle.append("\"");
        this.addParameter("thesisTitle", thesisTitle.toString());
        StringBuilder builder = new StringBuilder();
        builder.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"message.phd.finalization.certificate.made.thesis.presentation.on.doctoral.grade", (String[])new String[0])).append(":").append(" ");
        builder.append(phdIndividualProgramProcess.getPhdProgram().getName().getContent(this.getLanguage()).toUpperCase());
        this.addParameter("phdProgram", PhdFinalizationCertificate.customMultipleLineRightPad(builder.toString(), 70, '-'));
        this.addParameter("finalizationInfo", this.buildFinalizationInfo());
    }

    private String getThesisTitle(PhdIndividualProgramProcess phdIndividualProgramProcess) {
        if (this.getLanguage().equals(MultiLanguageString.en) && !StringUtils.isEmpty((String)phdIndividualProgramProcess.getThesisTitleEn())) {
            return phdIndividualProgramProcess.getThesisTitleEn();
        }
        return phdIndividualProgramProcess.getThesisTitle();
    }

    private String buildFinalizationInfo() {
        PhdIndividualProgramProcess phdIndividualProgramProcess = this.getDocumentRequest().getPhdIndividualProgramProcess();
        String thesisFinalGrade = phdIndividualProgramProcess.getFinalGrade().getLocalizedName(this.getLocale());
        if (phdIndividualProgramProcess.isBolonha().booleanValue() && phdIndividualProgramProcess.hasRegistryDiplomaRequest()) {
            return String.format(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"message.phd.finalization.info.thesis.grade.approved.by.jury.registry.diploma", (String[])new String[0]), thesisFinalGrade, phdIndividualProgramProcess.getRegistryDiplomaRequest().getRegistryCode().getCode());
        }
        return String.format(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"message.phd.finalization.info.thesis.grade.approved.by.jury", (String[])new String[0]), thesisFinalGrade);
    }

    private void addPersonalInfo() {
        Person person = this.getDocumentRequest().getPerson();
        String genderPrefix = person.isMale() ? BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.finalization.certificate.father.prefix.for.male", (String[])new String[0]) : BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.finalization.certificate.father.prefix.for.female", (String[])new String[0]);
        StringBuilder builder = new StringBuilder();
        builder.append(genderPrefix).append(" ");
        builder.append(person.getNameOfFather().toUpperCase());
        this.addParameter("fatherName", FenixStringTools.multipleLineRightPad(builder.toString(), 70, '-'));
        builder = new StringBuilder();
        builder.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.finalization.certificate.mother.prefix.for.female", (String[])new String[0])).append(" ");
        builder.append(person.getNameOfMother().toUpperCase());
        this.addParameter("motherName", FenixStringTools.multipleLineRightPad(builder.toString(), 70, '-'));
    }

    private static String customMultipleLineRightPad(String field, int LINE_LENGTH, char fillPaddingWith) {
        if (!StringUtils.isEmpty((String)field) && !field.endsWith(" ")) {
            field = field + " ";
        }
        if (field.length() < LINE_LENGTH) {
            return StringUtils.rightPad((String)field, (int)LINE_LENGTH, (char)fillPaddingWith);
        }
        List<String> words = Arrays.asList(field.split(" "));
        int currentLineLength = 0;
        String result = "";
        for (String word : words) {
            String toAdd = word + " ";
            if (currentLineLength + toAdd.length() > LINE_LENGTH) {
                result = StringUtils.rightPad((String)result, (int)LINE_LENGTH, (String)" ") + '\n';
                currentLineLength = toAdd.length();
            } else {
                currentLineLength += toAdd.length();
            }
            result = result + toAdd;
        }
        if (currentLineLength < LINE_LENGTH) {
            return StringUtils.rightPad((String)result, (int)(result.length() + (LINE_LENGTH - currentLineLength)), (char)fillPaddingWith);
        }
        return result;
    }
}

