/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.student.enrollment.bolonha;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curriculum.EnrolmentEvaluationContext;
import org.fenixedu.academic.domain.enrolment.EnroledCurriculumModuleWrapper;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.NoCourseGroupCurriculumGroup;
import org.fenixedu.academic.dto.student.enrollment.bolonha.NoCourseGroupEnroledCurriculumModuleWrapper;
import org.fenixedu.academic.dto.student.enrollment.bolonha.StudentCurriculumEnrolmentBean;
import org.fenixedu.academic.dto.student.enrollment.bolonha.StudentCurriculumGroupBean;

public class SpecialSeasonStudentCurriculumGroupBean
implements Serializable {
    private EvaluationSeason evaluationSeason;

    protected SpecialSeasonStudentCurriculumGroupBean(EvaluationSeason evaluationSeason) {
        this.setEvaluationSeason(evaluationSeason);
    }

    public StudentCurriculumGroupBean create(CurriculumGroup curriculumGroup, ExecutionSemester executionSemester) {
        return new StudentCurriculumGroupBean(curriculumGroup, executionSemester, null){

            @Override
            protected List<IDegreeModuleToEvaluate> buildCourseGroupsToEnrol(CurriculumGroup group, ExecutionSemester executionSemester) {
                return Collections.emptyList();
            }

            @Override
            protected List<StudentCurriculumEnrolmentBean> buildCurricularCoursesEnroled(CurriculumGroup group, ExecutionSemester executionSemester) {
                ArrayList<StudentCurriculumEnrolmentBean> result = new ArrayList<StudentCurriculumEnrolmentBean>();
                for (CurriculumModule curriculumModule : group.getCurriculumModulesSet()) {
                    Enrolment enrolment;
                    if (!curriculumModule.isEnrolment() || !(enrolment = (Enrolment)((Object)curriculumModule)).isEnroledInSeason(SpecialSeasonStudentCurriculumGroupBean.this.getEvaluationSeason(), executionSemester)) continue;
                    result.add(new StudentCurriculumEnrolmentBean(enrolment));
                }
                return result;
            }

            @Override
            protected List<IDegreeModuleToEvaluate> buildCurricularCoursesToEnrol(CurriculumGroup group, ExecutionSemester executionSemester) {
                ArrayList<IDegreeModuleToEvaluate> result = new ArrayList<IDegreeModuleToEvaluate>();
                for (CurriculumModule curriculumModule : group.getCurriculumModulesSet()) {
                    if (!curriculumModule.isEnrolment()) continue;
                    Enrolment enrolment = (Enrolment)((Object)curriculumModule);
                    if (!Enrolment.getPredicateSpecialSeason().fill(SpecialSeasonStudentCurriculumGroupBean.this.getEvaluationSeason(), executionSemester, EnrolmentEvaluationContext.MARK_SHEET_EVALUATION).testExceptionless(enrolment)) continue;
                    if (enrolment.parentCurriculumGroupIsNoCourseGroupCurriculumGroup()) {
                        result.add(new NoCourseGroupEnroledCurriculumModuleWrapper((CurriculumModule)((Object)enrolment), enrolment.getExecutionPeriod()));
                        continue;
                    }
                    result.add(new EnroledCurriculumModuleWrapper((CurriculumModule)((Object)enrolment), enrolment.getExecutionPeriod()));
                }
                return result;
            }

            @Override
            protected List<StudentCurriculumGroupBean> buildCurriculumGroupsEnroled(CurriculumGroup parentGroup, ExecutionSemester executionSemester, int[] curricularYears) {
                ArrayList<StudentCurriculumGroupBean> result = new ArrayList<StudentCurriculumGroupBean>();
                Set<CurriculumGroup> curriculumGroupsToEnrolmentProcess = parentGroup.getCurriculumGroupsToEnrolmentProcess();
                if (!parentGroup.isNoCourseGroupCurriculumGroup()) {
                    for (NoCourseGroupCurriculumGroup noCourseGroupCurriculumGroup : parentGroup.getNoCourseGroupCurriculumGroups()) {
                        if (!noCourseGroupCurriculumGroup.isVisible()) continue;
                        curriculumGroupsToEnrolmentProcess.add((CurriculumGroup)((Object)noCourseGroupCurriculumGroup));
                    }
                }
                for (CurriculumGroup curriculumGroup : curriculumGroupsToEnrolmentProcess) {
                    result.add(SpecialSeasonStudentCurriculumGroupBean.this.create(curriculumGroup, executionSemester));
                }
                return result;
            }

            @Override
            public List<IDegreeModuleToEvaluate> getSortedDegreeModulesToEvaluate() {
                ArrayList<IDegreeModuleToEvaluate> result = new ArrayList<IDegreeModuleToEvaluate>(this.getCurricularCoursesToEnrol());
                Collections.sort(result, IDegreeModuleToEvaluate.COMPARATOR_BY_EXECUTION_PERIOD);
                return result;
            }

            @Override
            public boolean isToBeDisabled() {
                return true;
            }
        };
    }

    public static StudentCurriculumGroupBean create(CurriculumGroup curriculumGroup, ExecutionSemester executionSemester, EvaluationSeason evaluationSeason) {
        return new SpecialSeasonStudentCurriculumGroupBean(evaluationSeason).create(curriculumGroup, executionSemester);
    }

    public EvaluationSeason getEvaluationSeason() {
        return this.evaluationSeason;
    }

    public void setEvaluationSeason(EvaluationSeason evaluationSeason) {
        this.evaluationSeason = evaluationSeason;
    }
}

