/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.treasury.TreasuryBridgeAPIFactory;
import org.fenixedu.academic.dto.InfoObject;
import org.fenixedu.academic.dto.InfoPerson;
import org.joda.time.LocalDate;

public class InfoStudent
extends InfoObject {
    private final Registration registration;

    public InfoStudent(Registration registration) {
        this.registration = registration;
    }

    public InfoPerson getInfoPerson() {
        return InfoPerson.newInfoFromDomain(this.getRegistration().getPerson());
    }

    public Integer getNumber() {
        return this.getRegistration().getNumber();
    }

    public DegreeType getDegreeType() {
        return this.getRegistration().getDegreeType();
    }

    public Boolean getPayedTuition() {
        return !TreasuryBridgeAPIFactory.implementation().isAcademicalActsBlocked(this.registration.getPerson(), new LocalDate());
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof InfoStudent && this.getRegistration() == ((InfoStudent)obj).getRegistration();
    }

    public String toString() {
        return this.getRegistration().toString();
    }

    public static InfoStudent newInfoFromDomain(Registration registration) {
        return registration == null ? null : new InfoStudent(registration);
    }

    public Boolean getFlunked() {
        return this.getRegistration().getFlunked();
    }

    public Boolean getRequestedChangeDegree() {
        return this.getRegistration().getRequestedChangeDegree();
    }

    public Boolean getInterruptedStudies() {
        return this.getRegistration().getInterruptedStudies();
    }

    @Override
    public String getExternalId() {
        return this.getRegistration().getExternalId();
    }

    @Override
    public void setExternalId(String integer) {
        throw new Error("Method should not be called!");
    }

    private Registration getRegistration() {
        return this.registration;
    }
}

