/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.time.chronologies.durationFields;

import org.fenixedu.academic.domain.time.calendarStructure.AcademicYearCE;
import org.fenixedu.academic.domain.time.chronologies.AcademicChronology;
import org.fenixedu.academic.domain.time.chronologies.durationFields.AcademicYearsDurationFieldType;
import org.joda.time.Chronology;
import org.joda.time.Duration;
import org.joda.time.DurationFieldType;
import org.joda.time.field.BaseDurationField;
import org.joda.time.field.FieldUtils;

public class AcademicYearsDurationField
extends BaseDurationField {
    private final AcademicChronology chronology;

    public AcademicYearsDurationField(AcademicChronology chronology_) {
        super(AcademicYearsDurationFieldType.academicYears());
        this.chronology = chronology_;
    }

    public long add(long instant, int value) {
        int academicYear = this.chronology.getAcademicYear(instant);
        if (academicYear != 0) {
            AcademicYearCE academicYearCE = this.chronology.getAcademicYearIn(academicYear);
            AcademicYearCE academicYearCEAfter = this.chronology.getAcademicYearIn(academicYear + value);
            if (academicYearCEAfter != null) {
                long result = academicYearCEAfter.getBegin().getMillis() + new Duration(academicYearCE.getBegin().getMillis(), instant).getMillis();
                return result < academicYearCE.getEnd().getMillis() ? result : academicYearCE.getEnd().getMillis();
            }
        }
        throw this.unsupported();
    }

    public long add(long instant, long value) {
        return this.add(instant, FieldUtils.safeToInt((long)value));
    }

    public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
        int minuendAcademicYear = this.chronology.getAcademicYear(minuendInstant);
        int subtrahendAcademicYear = this.chronology.getAcademicYear(subtrahendInstant);
        if (minuendAcademicYear != 0 && subtrahendAcademicYear != 0) {
            return minuendAcademicYear - subtrahendAcademicYear;
        }
        throw this.unsupported();
    }

    public long getMillis(int value, long instant) {
        int academicYear = this.chronology.getAcademicYear(instant);
        if (academicYear != 0) {
            AcademicYearCE academicYearCE = this.chronology.getAcademicYearIn(academicYear);
            AcademicYearCE academicYearCEAfter = this.chronology.getAcademicYearIn(academicYear + value);
            if (academicYearCEAfter != null) {
                long result = academicYearCEAfter.getBegin().getMillis() + new Duration(academicYearCE.getBegin().getMillis(), instant).getMillis();
                return result < academicYearCE.getEnd().getMillis() ? result - instant : academicYearCE.getEnd().getMillis() - instant;
            }
        }
        throw this.unsupported();
    }

    public long getMillis(long value, long instant) {
        return this.getMillis(FieldUtils.safeToInt((long)value), instant);
    }

    public long getUnitMillis() {
        return DurationFieldType.years().getField((Chronology)this.chronology).getUnitMillis();
    }

    public boolean isPrecise() {
        return false;
    }

    private UnsupportedOperationException unsupported() {
        return new UnsupportedOperationException(AcademicYearsDurationFieldType.academicYears() + " field is unsupported");
    }

    public long getValueAsLong(long duration, long instant) {
        int valueBegin = this.chronology.getAcademicYear(instant);
        int valueEnd = this.chronology.getAcademicYear(instant + duration);
        if (valueBegin != 0 && valueEnd != 0) {
            return valueEnd - valueBegin;
        }
        throw this.unsupported();
    }
}

