/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.candidacy;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.candidacy.ApplicantOverallPromise;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyReferee;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyRefereeLetter$callable$create;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyRefereeLetterBean;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyRefereeLetterFile;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyRefereeLetter_Base;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcess;
import org.fenixedu.bennu.core.domain.Bennu;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PhdCandidacyRefereeLetter
extends PhdCandidacyRefereeLetter_Base {
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    private PhdCandidacyRefereeLetter() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public PhdCandidacyRefereeLetter(PhdCandidacyReferee referee, PhdCandidacyRefereeLetterBean bean) {
        this();
        this.edit(referee, bean);
    }

    private void edit(PhdCandidacyReferee referee, PhdCandidacyRefereeLetterBean bean) {
        this.check(referee, bean);
        this.setCandidacyReferee(referee);
        this.setPhdProgramCandidacyProcess(referee.getPhdProgramCandidacyProcess());
        this.setHowLongKnownApplicant(bean.getHowLongKnownApplicant());
        this.setCapacity(bean.getCapacity());
        this.setComparisonGroup(bean.getComparisonGroup());
        this.setRankInClass(bean.getRankInClass());
        this.setAcademicPerformance(bean.getAcademicPerformance());
        this.setSocialAndCommunicationSkills(bean.getSocialAndCommunicationSkills());
        this.setPotencialToExcelPhd(bean.getPotencialToExcelPhd());
        this.setComments(bean.getComments());
        if (bean.hasFileContent()) {
            if (this.getFile() != null) {
                this.getFile().delete();
            }
            this.setFile(new PhdCandidacyRefereeLetterFile(this.getPhdProgramCandidacyProcess(), bean.getFilename(), bean.getFileContent()));
        }
        this.setRefereeName(bean.getRefereeName());
        this.setRefereePosition(bean.getRefereePosition());
        this.setRefereeInstitution(bean.getRefereeInstitution());
        this.setRefereeAddress(bean.getRefereeAddress());
        this.setRefereeCity(bean.getRefereeCity());
        this.setRefereeZipCode(bean.getRefereeZipCode());
        this.setRefereeCountry(bean.getRefereeCountry());
    }

    private void check(PhdCandidacyReferee referee, PhdCandidacyRefereeLetterBean bean) {
        String[] args = new String[]{};
        if (referee == null) {
            throw new DomainException("error.PhdCandidacyRefereeLetter.invalid.referee", args);
        }
        if (referee.getLetter() != null) {
            throw new DomainException("error.PhdCandidacyRefereeLetter.referee.already.has.letter", new String[0]);
        }
        PhdProgramCandidacyProcess obj = referee.getPhdProgramCandidacyProcess();
        String[] args1 = new String[]{};
        if (obj == null) {
            throw new DomainException("error.PhdCandidacyRefereeLetter.invalid.process", args1);
        }
        String obj5 = bean.getHowLongKnownApplicant();
        String[] args6 = new String[]{};
        if (obj5 == null || obj5.isEmpty()) {
            throw new DomainException("error.PhdCandidacyRefereeLetter.invalid.howLongKnownApplicant", args6);
        }
        String obj6 = bean.getCapacity();
        String[] args7 = new String[]{};
        if (obj6 == null || obj6.isEmpty()) {
            throw new DomainException("error.PhdCandidacyRefereeLetter.invalid.capacity", args7);
        }
        String obj7 = bean.getComparisonGroup();
        String[] args8 = new String[]{};
        if (obj7 == null || obj7.isEmpty()) {
            throw new DomainException("error.PhdCandidacyRefereeLetter.invalid.comparisonGroup", args8);
        }
        ApplicantOverallPromise obj1 = bean.getAcademicPerformance();
        String[] args2 = new String[]{};
        if (obj1 == null) {
            throw new DomainException("error.PhdCandidacyRefereeLetter.invalid.academicPerformance", args2);
        }
        ApplicantOverallPromise obj2 = bean.getSocialAndCommunicationSkills();
        String[] args3 = new String[]{};
        if (obj2 == null) {
            throw new DomainException("error.PhdCandidacyRefereeLetter.invalid.socialAndCommunicationSkills", args3);
        }
        ApplicantOverallPromise obj3 = bean.getPotencialToExcelPhd();
        String[] args4 = new String[]{};
        if (obj3 == null) {
            throw new DomainException("error.PhdCandidacyRefereeLetter.invalid.potencialToExcelPhd", args4);
        }
        String obj8 = bean.getRefereeName();
        String[] args9 = new String[]{};
        if (obj8 == null || obj8.isEmpty()) {
            throw new DomainException("error.PhdCandidacyRefereeLetter.invalid.refereeName", args9);
        }
        String obj9 = bean.getRefereeInstitution();
        String[] args10 = new String[]{};
        if (obj9 == null || obj9.isEmpty()) {
            throw new DomainException("error.PhdCandidacyRefereeLetter.invalid.refereeInstitution", args10);
        }
        String obj10 = bean.getRefereeAddress();
        String[] args11 = new String[]{};
        if (obj10 == null || obj10.isEmpty()) {
            throw new DomainException("error.PhdCandidacyRefereeLetter.invalid.refereeAddress", args11);
        }
        String obj11 = bean.getRefereeCity();
        String[] args12 = new String[]{};
        if (obj11 == null || obj11.isEmpty()) {
            throw new DomainException("error.PhdCandidacyRefereeLetter.invalid.refereeCity", args12);
        }
        String obj12 = bean.getRefereeZipCode();
        String[] args13 = new String[]{};
        if (obj12 == null || obj12.isEmpty()) {
            throw new DomainException("error.PhdCandidacyRefereeLetter.invalid.refereeZipCode", args13);
        }
        Country obj4 = bean.getRefereeCountry();
        String[] args5 = new String[]{};
        if (obj4 == null) {
            throw new DomainException("error.PhdCandidacyRefereeLetter.invalid.refereeCountry", args5);
        }
    }

    public String getRefereeEmail() {
        return this.getCandidacyReferee().getEmail();
    }

    public void delete() {
        if (this.getFile() != null) {
            this.getFile().delete();
        }
        this.setRefereeCountry(null);
        this.setCandidacyReferee(null);
        this.setPhdProgramCandidacyProcess(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public static PhdCandidacyRefereeLetter create(PhdCandidacyRefereeLetterBean phdCandidacyRefereeLetterBean) {
        return (PhdCandidacyRefereeLetter)((Object)advice$create.perform((Callable)new PhdCandidacyRefereeLetter$callable$create(phdCandidacyRefereeLetterBean)));
    }

    static /* synthetic */ PhdCandidacyRefereeLetter advised$create(PhdCandidacyRefereeLetterBean bean) {
        return new PhdCandidacyRefereeLetter(bean.getCandidacyReferee(), bean);
    }
}

