/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.organizationalStructure;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitNamePart;
import org.fenixedu.academic.domain.organizationalStructure.UnitName_Base;
import org.fenixedu.bennu.core.domain.Bennu;

public class UnitName
extends UnitName_Base
implements Comparable<UnitName> {
    public UnitName(Unit unit) {
        this.setRootDomainObject(Bennu.getInstance());
        this.setUnit(unit);
        this.setIsExternalUnit(!unit.isInternal());
    }

    @Override
    public int compareTo(UnitName unitName) {
        int stringCompare = this.getName().compareTo(unitName.getName());
        return stringCompare == 0 ? this.getExternalId().compareTo(unitName.getExternalId()) : stringCompare;
    }

    public void setName(String name) {
        super.setName(UnitNamePart.normalize(name));
        UnitNamePart.reindex(this);
    }

    private static boolean containsAll(String normalizedUnitName, String[] nameParts) {
        for (String namePart : nameParts) {
            if (normalizedUnitName.indexOf(namePart) != -1) continue;
            return false;
        }
        return true;
    }

    public static void find(UnitNameLimitedOrderedSet unitNameLimitedOrderedSet, String name, int size) {
        String[] nameParts = UnitNamePart.getNameParts(name);
        if (nameParts.length > 0) {
            UnitNamePart unitNamePart = UnitNamePart.find(nameParts[0]);
            if (unitNamePart != null && nameParts.length == 1) {
                unitNameLimitedOrderedSet.addAll(unitNamePart.getUnitNameSet());
            } else {
                Set unitNames = unitNamePart == null ? Bennu.getInstance().getUnitNameSet() : unitNamePart.getUnitNameSet();
                for (UnitName unitName : unitNames) {
                    String normalizedUnitName = unitName.getName();
                    if (!UnitName.containsAll(normalizedUnitName, nameParts)) continue;
                    unitNameLimitedOrderedSet.add(unitName);
                }
            }
        }
    }

    public static void findExternalInstitution(UnitNameLimitedOrderedSet unitNameLimitedOrderedSet, String name, int size, UnitNameLimitedOrderedSet resultSet) {
        UnitName.find(unitNameLimitedOrderedSet, name, size);
        HashSet<UnitName> restOfTheUnitNames = new HashSet<UnitName>();
        HashSet<UnitName> unitNamesWithScore = new HashSet<UnitName>();
        String[] nameParts = UnitNamePart.getNameParts(name);
        for (UnitName unitName : unitNameLimitedOrderedSet) {
            if (unitName.getUnit().getCode() != null) {
                if (UnitName.containsAllExactWords(unitName.getName(), nameParts)) {
                    if (resultSet.containsExactSameName(unitName)) continue;
                    resultSet.add(unitName);
                    if (resultSet.size() != size) continue;
                    return;
                }
                unitNamesWithScore.add(unitName);
                continue;
            }
            restOfTheUnitNames.add(unitName);
        }
        UnitName.addDifferentUnitNames(size, resultSet, unitNamesWithScore);
        UnitName.addDifferentUnitNames(size, resultSet, restOfTheUnitNames);
    }

    private static void addDifferentUnitNames(int size, UnitNameLimitedOrderedSet resultSet, Set<UnitName> unitNamesWithScore) {
        for (UnitName unitName : unitNamesWithScore) {
            if (unitName.getUnit().getCode() != null || resultSet.containsExactSameName(unitName)) continue;
            resultSet.add(unitName);
            if (resultSet.size() != size) continue;
            return;
        }
    }

    private static boolean containsAllExactWords(String normalizedUnitName, String[] nameParts) {
        String[] unitNameParts = UnitNamePart.getNameParts(normalizedUnitName);
        for (String namePart : nameParts) {
            if (namePart.length() <= 3 || UnitName.existsCompleteNamePart(unitNameParts, namePart)) continue;
            return false;
        }
        return true;
    }

    private static boolean existsCompleteNamePart(String[] unitNameParts, String namePart) {
        for (String unitPart : unitNameParts) {
            if (!unitPart.equalsIgnoreCase(namePart)) continue;
            return true;
        }
        return false;
    }

    public static void findExactWords(UnitNameLimitedOrderedSet unitNameLimitedOrderedSet, String name) {
        String[] nameParts = UnitNamePart.getNameParts(name);
        if (nameParts.length > 0) {
            UnitNamePart unitNamePart = UnitNamePart.find(nameParts[0]);
            if (unitNamePart != null && nameParts.length == 1) {
                unitNameLimitedOrderedSet.addAll(unitNamePart.getUnitNameSet());
            } else {
                Set unitNames = unitNamePart == null ? Bennu.getInstance().getUnitNameSet() : unitNamePart.getUnitNameSet();
                for (UnitName unitName : unitNames) {
                    String normalizedUnitName = unitName.getName();
                    if (!UnitName.containsAllExactWords(normalizedUnitName, nameParts) || UnitName.existsTheSameCode(unitName, unitNameLimitedOrderedSet)) continue;
                    unitNameLimitedOrderedSet.add(unitName);
                }
            }
        }
    }

    private static boolean existsTheSameCode(UnitName unitName, UnitNameLimitedOrderedSet unitNameLimitedOrderedSet) {
        for (UnitName unitNameTemp : unitNameLimitedOrderedSet) {
            if (StringUtils.isEmpty((String)unitName.getUnit().getCode()) || !StringUtils.isNumeric((String)unitName.getUnit().getCode())) {
                return false;
            }
            if (!unitName.getUnit().getCode().equals(unitNameTemp.getUnit().getCode())) continue;
            return true;
        }
        return false;
    }

    public static Collection<UnitName> findInternalUnitWithType(String name, int size, Class<? extends Unit> unitType) {
        InternalUnitNameAndTypeLimitedOrderedSet internalUnitNameAndTypeLimitedOrderedSet = new InternalUnitNameAndTypeLimitedOrderedSet(size, unitType);
        UnitName.find(internalUnitNameAndTypeLimitedOrderedSet, name, size);
        return internalUnitNameAndTypeLimitedOrderedSet;
    }

    public static Collection<UnitName> findInternalUnit(String name, int size) {
        InternalUnitNameLimitedOrderedSet unitNameLimitedOrderedSet = new InternalUnitNameLimitedOrderedSet(size);
        UnitName.find(unitNameLimitedOrderedSet, name, size);
        return unitNameLimitedOrderedSet;
    }

    public static Collection<UnitName> findExternalUnit(String name, int size) {
        ExternalUnitNameLimitedOrderedSet unitNameLimitedOrderedSet = new ExternalUnitNameLimitedOrderedSet(size);
        UnitName.find(unitNameLimitedOrderedSet, name, size);
        return unitNameLimitedOrderedSet;
    }

    public static Collection<UnitName> findExternalUnit(String name, int size, Predicate predicate) {
        ExternalUnitNameLimitedOrderedSet unitNameLimitedOrderedSet = new ExternalUnitNameLimitedOrderedSet(size, predicate);
        UnitName.find(unitNameLimitedOrderedSet, name, size);
        return unitNameLimitedOrderedSet;
    }

    public static Collection<UnitName> findExternalAcademicUnit(String name, int size) {
        ExternalAcademicUnitNameLimitedOrderedSet academicUnitNameLimitedOrderedSet = new ExternalAcademicUnitNameLimitedOrderedSet(size);
        UnitName.findExactWords(academicUnitNameLimitedOrderedSet, name);
        return academicUnitNameLimitedOrderedSet;
    }

    public static Collection<UnitName> findExternalInstitutionUnitWithScore(String name, int size) {
        ExternalUnitNameLimitedOrderedSet unitNameLimitedOrderedSet = new ExternalUnitNameLimitedOrderedSet(size + 400);
        ExternalUnitNameLimitedOrderedSet resultSet = new ExternalUnitNameLimitedOrderedSet(size);
        UnitName.findExternalInstitution(unitNameLimitedOrderedSet, name, size, resultSet);
        return resultSet;
    }

    public static Collection<UnitName> find(String name, int size) {
        UnitNameLimitedOrderedSet unitNameLimitedOrderedSet = new UnitNameLimitedOrderedSet(size);
        UnitName.find(unitNameLimitedOrderedSet, name, size);
        return unitNameLimitedOrderedSet;
    }

    public void delete() {
        HashSet unitNameParts = new HashSet(this.getUnitNamePartSet());
        this.getUnitNamePartSet().clear();
        this.setUnit(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
        for (UnitNamePart unitNamePart : unitNameParts) {
            unitNamePart.deleteIfEmpty();
        }
    }

    public static class ExternalAcademicUnitNameLimitedOrderedSet
    extends UnitNameLimitedOrderedSet {
        private final Unit institutionUnit = Bennu.getInstance().getInstitutionUnit();

        public ExternalAcademicUnitNameLimitedOrderedSet(int maxElements) {
            super(maxElements);
        }

        @Override
        public boolean add(UnitName unitName) {
            String code = unitName.getUnit().getCode();
            return unitName.getIsExternalUnit() != false && !StringUtils.isEmpty((String)code) && StringUtils.isNumeric((String)code) && super.add(unitName);
        }
    }

    public static class ExternalUnitNameLimitedOrderedSet
    extends UnitNameLimitedOrderedSet {
        private final Predicate predicate;

        public ExternalUnitNameLimitedOrderedSet(int maxElements) {
            this(maxElements, null);
        }

        public ExternalUnitNameLimitedOrderedSet(int maxElements, Predicate predicate) {
            super(maxElements);
            this.predicate = predicate;
        }

        @Override
        public boolean add(UnitName unitName) {
            return (this.predicate == null || this.predicate.evaluate((Object)unitName)) && unitName.getIsExternalUnit() != false ? super.add(unitName) : false;
        }
    }

    public static class InternalUnitNameLimitedOrderedSet
    extends UnitNameLimitedOrderedSet {
        public InternalUnitNameLimitedOrderedSet(int maxElements) {
            super(maxElements);
        }

        @Override
        public boolean add(UnitName unitName) {
            return unitName.getIsExternalUnit() != false ? false : super.add(unitName);
        }
    }

    public static class InternalUnitNameAndTypeLimitedOrderedSet
    extends UnitNameLimitedOrderedSet {
        private final Class<? extends Unit> unitType;

        public InternalUnitNameAndTypeLimitedOrderedSet(int maxElements, Class<? extends Unit> unitType) {
            super(maxElements);
            this.unitType = unitType;
        }

        @Override
        public boolean add(UnitName unitName) {
            UnitName lastUnitName;
            if (this.size() < this.maxElements && ((Object)((Object)unitName.getUnit())).getClass().equals(this.unitType)) {
                return super.add(unitName);
            }
            UnitName unitName2 = lastUnitName = this.isEmpty() ? null : (UnitName)this.last();
            if (lastUnitName != null && lastUnitName.compareTo(unitName) > 0 && ((Object)((Object)unitName.getUnit())).getClass().equals(this.unitType)) {
                this.remove(lastUnitName);
                return super.add(unitName);
            }
            return false;
        }
    }

    public static class UnitNameLimitedOrderedSet
    extends TreeSet<UnitName> {
        protected final int maxElements;

        public UnitNameLimitedOrderedSet(int maxElements) {
            this.maxElements = maxElements;
        }

        @Override
        public boolean add(UnitName unitName) {
            if (this.size() < this.maxElements) {
                return super.add(unitName);
            }
            UnitName lastUnitName = (UnitName)this.last();
            if (lastUnitName.compareTo(unitName) > 0) {
                this.remove(lastUnitName);
                return super.add(unitName);
            }
            return false;
        }

        public boolean containsExactSameName(UnitName unitName) {
            for (UnitName forUnitName : this) {
                if (!forUnitName.getUnit().getName().equals(unitName.getUnit().getName())) continue;
                return true;
            }
            return false;
        }
    }
}

