/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.contacts;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.concurrent.Callable;
import org.fenixedu.academic.FenixEduAcademicConfiguration;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.contacts.PartyContact;
import org.fenixedu.academic.domain.contacts.PartyContactType;
import org.fenixedu.academic.domain.contacts.PhysicalAddress$callable$setValid;
import org.fenixedu.academic.domain.contacts.PhysicalAddressData;
import org.fenixedu.academic.domain.contacts.PhysicalAddressValidation;
import org.fenixedu.academic.domain.contacts.PhysicalAddress_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PhysicalAddress
extends PhysicalAddress_Base {
    public static Comparator<PhysicalAddress> COMPARATOR_BY_ADDRESS;
    public static final Advice advice$setValid;

    public static PhysicalAddress createPhysicalAddress(Party party, PhysicalAddressData data, PartyContactType type, Boolean isDefault) {
        return new PhysicalAddress(party, type, isDefault, data);
    }

    protected PhysicalAddress() {
        new PhysicalAddressValidation(this);
    }

    protected PhysicalAddress(Party party, PartyContactType type, boolean defaultContact, PhysicalAddressData data) {
        this();
        super.init(party, type, defaultContact);
        this.setVisibleToPublic(Boolean.FALSE);
        this.setVisibleToStudents(Boolean.FALSE);
        this.setVisibleToStaff(Boolean.FALSE);
        this.edit(data);
    }

    public PhysicalAddress(Party party, PartyContactType type, Boolean defaultContact, String address, String areaCode, String areaOfAreaCode, String area, String parishOfResidence, String districtSubdivisionOfResidence, String districtOfResidence, Country countryOfResidence) {
        this(party, type, defaultContact, new PhysicalAddressData(address, areaCode, areaOfAreaCode, area, parishOfResidence, districtSubdivisionOfResidence, districtOfResidence, countryOfResidence));
    }

    public void edit(PhysicalAddressData data) {
        if (data == null) {
            return;
        }
        if (!data.equals(new PhysicalAddressData(this))) {
            super.setAddress(data.getAddress());
            super.setAreaCode(data.getAreaCode());
            super.setAreaOfAreaCode(data.getAreaOfAreaCode());
            super.setArea(data.getArea());
            super.setParishOfResidence(data.getParishOfResidence());
            super.setDistrictSubdivisionOfResidence(data.getDistrictSubdivisionOfResidence());
            super.setDistrictOfResidence(data.getDistrictOfResidence());
            super.setCountryOfResidence(data.getCountryOfResidence());
            if (!this.waitsValidation()) {
                new PhysicalAddressValidation(this);
            }
            this.setLastModifiedDate(new DateTime());
        }
    }

    public void edit(PartyContactType type, Boolean defaultContact, String address, String areaCode, String areaOfAreaCode, String area, String parishOfResidence, String districtSubdivisionOfResidence, String districtOfResidence, Country countryOfResidence) {
        super.edit(type, defaultContact.booleanValue());
        this.edit(new PhysicalAddressData(address, areaCode, areaOfAreaCode, area, parishOfResidence, districtSubdivisionOfResidence, districtOfResidence, countryOfResidence));
    }

    public boolean isPhysicalAddress() {
        return true;
    }

    public String getCountryOfResidenceName() {
        return this.getCountryOfResidence() != null ? this.getCountryOfResidence().getName() : "";
    }

    public void deleteWithoutCheckRules() {
        super.deleteWithoutCheckRules();
    }

    public void delete() {
        super.delete();
    }

    protected void checkRulesToDelete() {
        if (this.getParty().getPartyContacts(((Object)((Object)this)).getClass()).size() == 1) {
            throw new DomainException("error.domain.contacts.PhysicalAddress.cannot.remove.last.physicalAddress", new String[0]);
        }
    }

    public String getPresentationValue() {
        return this.getAddress();
    }

    public String getPostalCode() {
        StringBuilder result = new StringBuilder();
        result.append(this.getAreaCode());
        result.append(" ");
        result.append(this.getAreaOfAreaCode());
        return result.toString();
    }

    public boolean hasValue(String value) {
        return false;
    }

    public void setValid() {
        Object object = advice$setValid.perform((Callable)new PhysicalAddress$callable$setValid(this));
    }

    static /* synthetic */ void advised$setValid(PhysicalAddress this_) {
        if (!this_.isValid()) {
            PhysicalAddressValidation physicalAddressValidation = (PhysicalAddressValidation)((Object)this_.getPartyContactValidation());
            physicalAddressValidation.setValid();
            String userName = AccessControl.getPerson() == null ? "-" : AccessControl.getPerson().getUsername();
            physicalAddressValidation.setDescription(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.contacts.physicalAddress.validation.description", (String[])new String[]{userName}));
        }
    }

    public void logCreate(Person person) {
        this.logCreateAux(person, "label.partyContacts.PhysicalAddress");
    }

    public void logEdit(Person person, boolean propertiesChanged, boolean valueChanged, boolean createdNewContact, String newValue) {
        this.logEditAux(person, propertiesChanged, valueChanged, createdNewContact, newValue, "label.partyContacts.PhysicalAddress");
    }

    public void logDelete(Person person) {
        this.logDeleteAux(person, "label.partyContacts.PhysicalAddress");
    }

    public void logValid(Person person) {
        this.logValidAux(person, "label.partyContacts.PhysicalAddress");
    }

    public void logRefuse(Person person) {
        this.logRefuseAux(person, "label.partyContacts.PhysicalAddress");
    }

    public boolean isToBeValidated() {
        return PhysicalAddress.requiresValidation();
    }

    public static boolean requiresValidation() {
        return FenixEduAcademicConfiguration.getPhysicalAddressRequiresValidation();
    }

    static {
        advice$setValid = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_ADDRESS = new Comparator<PhysicalAddress>(){

            @Override
            public int compare(PhysicalAddress contact, PhysicalAddress otherContact) {
                String address = contact.getAddress();
                String otherAddress = otherContact.getAddress();
                int result = 0;
                if (address != null && otherAddress != null) {
                    result = address.compareTo(otherAddress);
                } else if (address != null) {
                    result = 1;
                } else if (otherAddress != null) {
                    result = -1;
                }
                return result == 0 ? PartyContact.COMPARATOR_BY_TYPE.compare((PartyContact)((Object)contact), (PartyContact)((Object)otherContact)) : result;
            }
        };
    }
}

