/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules;

import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.postingRules.FixedAmountWithPenaltyPR_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;

public abstract class FixedAmountWithPenaltyPR
extends FixedAmountWithPenaltyPR_Base {
    protected FixedAmountWithPenaltyPR() {
    }

    protected void init(EntryType entryType, EventType eventType, DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money fixedAmount, Money fixedAmountPenalty) {
        super.init(entryType, eventType, startDate, endDate, serviceAgreementTemplate, fixedAmount);
        this.checkParameters(fixedAmountPenalty);
        super.setFixedAmountPenalty(fixedAmountPenalty);
    }

    private void checkParameters(Money fixedAmountPenalty) {
        if (fixedAmountPenalty == null) {
            throw new DomainException("error.accounting.postingRules.FixedAmountWithPenaltyPR.fixedAmountPenalty.cannot.be.null", new String[0]);
        }
    }

    protected Money doCalculationForAmountToPay(Event event, DateTime when, boolean applyDiscount) {
        return super.doCalculationForAmountToPay(event, when, applyDiscount).add(this.hasPenalty(event, when) ? this.getFixedAmountPenalty() : Money.ZERO);
    }

    public void setFixedAmountPenalty(Money fixedAmountPenalty) {
        throw new DomainException("error.accounting.postingRules.FixedAmountWithPenaltyPR.cannot.modify.fixedAmountPenalty", new String[0]);
    }

    protected abstract boolean hasPenalty(Event var1, DateTime var2);
}

