/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.accounting.AcademicEvent;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.postingRules.FixedAmountPR_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.DomainExceptionWithLabelFormatter;
import org.fenixedu.academic.dto.accounting.AccountingTransactionDetailDTO;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;

public class FixedAmountPR
extends FixedAmountPR_Base {
    protected FixedAmountPR() {
    }

    public FixedAmountPR(EntryType entryType, EventType eventType, DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money fixedAmount) {
        this();
        this.init(entryType, eventType, startDate, endDate, serviceAgreementTemplate, fixedAmount);
    }

    private void checkParameters(Money fixedAmount) {
        if (fixedAmount == null) {
            throw new DomainException("error.accounting.postingRules.FixedAmountPR.fixedAmount.cannot.be.null", new String[0]);
        }
    }

    protected void init(EntryType entryType, EventType eventType, DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money fixedAmount) {
        super.init(entryType, eventType, startDate, endDate, serviceAgreementTemplate);
        this.checkParameters(fixedAmount);
        super.setFixedAmount(fixedAmount);
    }

    protected Set<AccountingTransaction> internalProcess(User user, Collection<EntryDTO> entryDTOs, Event event, Account fromAccount, Account toAccount, AccountingTransactionDetailDTO transactionDetail) {
        if (entryDTOs.size() != 1) {
            throw new DomainException("error.accounting.postingRules.FixedAmountPR.invalid.number.of.entryDTOs", new String[0]);
        }
        EntryDTO entryDTO = entryDTOs.iterator().next();
        this.checkIfCanAddAmount(entryDTO.getAmountToPay(), event, transactionDetail.getWhenRegistered());
        return Collections.singleton(this.makeAccountingTransaction(user, event, fromAccount, toAccount, entryDTO.getEntryType(), entryDTO.getAmountToPay(), transactionDetail));
    }

    public void setFixedAmount(Money fixedAmount) {
        throw new DomainException("error.accounting.postingRules.FixedAmountPR.cannot.modify.fixedAmount", new String[0]);
    }

    protected void checkIfCanAddAmount(Money amountToPay, Event event, DateTime when) {
        if (amountToPay.compareTo(this.calculateTotalAmountToPay(event, when)) < 0) {
            throw new DomainExceptionWithLabelFormatter("error.accounting.postingRules.FixedAmountPR.amount.being.payed.must.match.amount.to.pay", event.getDescriptionForEntryType(this.getEntryType()));
        }
    }

    public List<EntryDTO> calculateEntries(Event event, DateTime when) {
        Money totalAmountToPay = this.calculateTotalAmountToPay(event, when);
        return Collections.singletonList(new EntryDTO(this.getEntryType(), event, totalAmountToPay, Money.ZERO, totalAmountToPay, event.getDescriptionForEntryType(this.getEntryType()), totalAmountToPay));
    }

    protected Money doCalculationForAmountToPay(Event event, DateTime when, boolean applyDiscount) {
        return this.getFixedAmount();
    }

    protected Money subtractFromExemptions(Event event, DateTime when, boolean applyDiscount, Money amountToPay) {
        if (event instanceof AcademicEvent) {
            AcademicEvent requestEvent = (AcademicEvent)((Object)event);
            if (requestEvent.hasAcademicEventExemption()) {
                amountToPay = amountToPay.subtract(requestEvent.getAcademicEventExemption().getValue());
            }
            return amountToPay.isPositive() ? amountToPay : Money.ZERO;
        }
        return amountToPay;
    }

    public FixedAmountPR edit(Money fixedAmount) {
        this.deactivate();
        return new FixedAmountPR(this.getEntryType(), this.getEventType(), new DateTime().minus(1000L), null, this.getServiceAgreementTemplate(), fixedAmount);
    }
}

