/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.gratuity;

import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityExemption;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityExemptionJustificationByDispatch_Base;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityExemptionJustificationType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.DomainExceptionWithLabelFormatter;
import org.fenixedu.academic.util.LabelFormatter;
import org.joda.time.YearMonthDay;

public class GratuityExemptionJustificationByDispatch
extends GratuityExemptionJustificationByDispatch_Base {
    protected GratuityExemptionJustificationByDispatch() {
    }

    public GratuityExemptionJustificationByDispatch(GratuityExemption gratuityExemption, GratuityExemptionJustificationType justificationType, String reason, YearMonthDay dispatchDate) {
        this();
        this.init(gratuityExemption, justificationType, reason, dispatchDate);
    }

    protected void init(GratuityExemption gratuityExemption, GratuityExemptionJustificationType justificationType, String reason, YearMonthDay dispatchDate) {
        this.checkParameters(justificationType, reason, dispatchDate);
        super.init(gratuityExemption, justificationType, reason);
        super.setGratuityExemptionDispatchDate(dispatchDate);
    }

    private void checkParameters(GratuityExemptionJustificationType justificationType, String reason, YearMonthDay dispatchDate) {
        if (dispatchDate == null || StringUtils.isEmpty((String)reason)) {
            throw new DomainExceptionWithLabelFormatter("error.accounting.events.GratuityExemptionJustificationByDispatch.dispatchDate.and.reason.are.required", new LabelFormatter(justificationType.getQualifiedName(), "resources.EnumerationResources"));
        }
    }

    public void setGratuityExemptionDispatchDate(YearMonthDay dispatchDate) {
        throw new DomainException("error.org.fenixedu.academic.domain.accounting.events.gratuity.GratuityExemptionJustificationByDispatch.cannot.modify.dispatchDate", new String[0]);
    }

    public LabelFormatter getDescription() {
        LabelFormatter labelFormatter = new LabelFormatter();
        labelFormatter.appendLabel(this.getGratuityExemptionJustificationType().getQualifiedName(), "resources.EnumerationResources");
        String gratuityExemptionDate = this.getGratuityExemptionDispatchDate() != null ? this.getGratuityExemptionDispatchDate().toString("dd/MM/yyyy") : "-";
        labelFormatter.appendLabel(" (").appendLabel("label.in", "resources.ApplicationResources").appendLabel(" ").appendLabel(gratuityExemptionDate).appendLabel(")");
        return labelFormatter;
    }
}

