/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accessControl;

import java.util.Objects;
import org.fenixedu.academic.domain.accessControl.PersistentUnitGroup_Base;
import org.fenixedu.academic.domain.accessControl.UnitGroup;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.bennu.core.groups.Group;

public class PersistentUnitGroup
extends PersistentUnitGroup_Base {
    protected PersistentUnitGroup(Unit unit, AccountabilityTypeEnum relationType, boolean includeSubUnits) {
        this.setUnit(unit);
        this.setRelationType(relationType);
        this.setIncludeSubUnits(includeSubUnits);
    }

    public Group toGroup() {
        return UnitGroup.get(this.getUnit(), this.getRelationType(), this.getIncludeSubUnits());
    }

    protected void gc() {
        this.setUnit(null);
        super.gc();
    }

    public static PersistentUnitGroup getInstance(Unit unit, AccountabilityTypeEnum relationType, Boolean includeSubUnits) {
        return (PersistentUnitGroup)PersistentUnitGroup.singleton(() -> unit.getUnitGroupSet().stream().filter(group -> Objects.equals((Object)group.getRelationType(), (Object)relationType) && Objects.equals(group.getIncludeSubUnits(), includeSubUnits)).findAny(), () -> new PersistentUnitGroup(unit, relationType, includeSubUnits));
    }
}

