/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.util;

import org.fenixedu.academic.util.FenixUtil;

public class PeriodState
extends FenixUtil {
    public static final PeriodState CLOSED = new PeriodState("CL");
    public static final PeriodState OPEN = new PeriodState("O");
    public static final PeriodState NOT_OPEN = new PeriodState("NO");
    public static final PeriodState CURRENT = new PeriodState("C");
    public static final String CLOSED_CODE = "CL";
    public static final String CURRENT_CODE = "C";
    public static final String OPEN_CODE = "O";
    public static final String NOT_OPEN_CODE = "NO";
    private final String stateCode;

    public PeriodState(String stateCode) {
        this.stateCode = stateCode;
    }

    public String getStateCode() {
        return this.stateCode;
    }

    public PeriodState(PeriodState executionPeriodState) {
        this.stateCode = executionPeriodState.getStateCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PeriodState) {
            PeriodState executionPeriodState = (PeriodState)obj;
            return executionPeriodState.getStateCode().equals(this.stateCode);
        }
        return false;
    }

    public String toString() {
        String result = "";
        if (this.getStateCode().equals(CLOSED_CODE)) {
            result = "CLOSED";
        } else if (this.getStateCode().equals(CURRENT_CODE)) {
            result = "CURRENT";
        } else if (this.getStateCode().equals(OPEN_CODE)) {
            result = "OPEN";
        } else if (this.getStateCode().equals(NOT_OPEN_CODE)) {
            result = "NOT_OPEN";
        }
        return result;
    }

    public static PeriodState valueOf(String code) {
        if (code == null) {
            return null;
        }
        if (code.equals(CURRENT_CODE)) {
            return CURRENT;
        }
        if (code.equals(OPEN_CODE)) {
            return OPEN;
        }
        if (code.equals(NOT_OPEN_CODE)) {
            return NOT_OPEN;
        }
        if (code.equals(CLOSED_CODE)) {
            return CLOSED;
        }
        return null;
    }
}

