/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.providers.lists;

import java.util.TreeSet;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.dto.academicAdministration.DegreeByExecutionYearBean;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyConverter;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class DegreesForExecutionYear
implements DataProvider {
    public Object provide(Object source, Object currentValue) {
        TreeSet<Degree> result = new TreeSet<Degree>(Degree.COMPARATOR_BY_DEGREE_TYPE_AND_NAME_AND_ID);
        DegreeByExecutionYearBean chooseDegreeBean = (DegreeByExecutionYearBean)source;
        for (Degree degree : chooseDegreeBean.getAdministratedDegrees()) {
            if (!this.matchesExecutionYear(degree, chooseDegreeBean.getExecutionYear()) || !this.matchesDegreeType(degree, chooseDegreeBean.getDegreeType())) continue;
            result.add(degree);
        }
        return result;
    }

    private boolean matchesDegreeType(Degree degree, DegreeType degreeType) {
        return degreeType == null || degree.getDegreeType() == degreeType;
    }

    private boolean matchesExecutionYear(Degree degree, ExecutionYear executionYear) {
        if (executionYear == null) {
            return true;
        }
        for (ExecutionDegree executionDegree : executionYear.getExecutionDegreesSet()) {
            if (executionDegree.getDegree() != degree) continue;
            return true;
        }
        return false;
    }

    public Converter getConverter() {
        return new DomainObjectKeyConverter();
    }
}

