/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.degreeStructure.CurricularStage;
import org.fenixedu.academic.domain.organizationalStructure.CompetenceCourseGroupUnit;
import org.fenixedu.academic.domain.organizationalStructure.DepartmentUnit;
import org.fenixedu.academic.domain.organizationalStructure.ScientificAreaUnit;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.fenixWebFramework.renderers.CollectionRenderer;
import pt.ist.fenixWebFramework.renderers.OutputRenderer;
import pt.ist.fenixWebFramework.renderers.components.Face;
import pt.ist.fenixWebFramework.renderers.components.HtmlBlockContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlInlineContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlList;
import pt.ist.fenixWebFramework.renderers.components.HtmlListItem;
import pt.ist.fenixWebFramework.renderers.components.HtmlTable;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableCell;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableRow;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public class CompetenceCourseVersionList
extends OutputRenderer {
    private String approvedClass;
    private String draftClass;
    private String publishedClass;
    private String tableClasses;
    private String scientificAreaNameClasses;
    private String groupNameClasses;
    private String courseNameClasses;
    private String filterBy;
    private final Map<String, CollectionRenderer.TableLink> links = new Hashtable<String, CollectionRenderer.TableLink>();
    private final List<CollectionRenderer.TableLink> sortedLinks = new ArrayList<CollectionRenderer.TableLink>();
    private boolean groupLinks;
    private String linkGroupSeparator;
    private boolean showOldCompetenceCourses;
    private String messageClass;

    public String getFilterBy() {
        return this.filterBy;
    }

    public void setFilterBy(String filterBy) {
        this.filterBy = filterBy;
    }

    public String getCourseNameClasses() {
        return this.courseNameClasses;
    }

    public void setCourseNameClasses(String courseNameClasses) {
        this.courseNameClasses = courseNameClasses;
    }

    public String getScientificAreaNameClasses() {
        return this.scientificAreaNameClasses;
    }

    public void setScientificAreaNameClasses(String scientificAreaNameClasses) {
        this.scientificAreaNameClasses = scientificAreaNameClasses;
    }

    public String getTableClasses() {
        return this.tableClasses;
    }

    public void setTableClasses(String tableClasses) {
        this.tableClasses = tableClasses;
    }

    public String getApprovedClass() {
        return this.approvedClass;
    }

    public void setApprovedClass(String approvedClass) {
        this.approvedClass = approvedClass;
    }

    public String getDraftClass() {
        return this.draftClass;
    }

    public void setDraftClass(String draftClass) {
        this.draftClass = draftClass;
    }

    public String getMessageClass() {
        return this.messageClass;
    }

    public void setMessageClass(String messageClass) {
        this.messageClass = messageClass;
    }

    public String getPublishedClass() {
        return this.publishedClass;
    }

    public void setPublishedClass(String publishedClass) {
        this.publishedClass = publishedClass;
    }

    private CollectionRenderer.TableLink getTableLink(String name) {
        CollectionRenderer.TableLink tableLink = this.links.get(name);
        if (tableLink == null) {
            tableLink = new CollectionRenderer.TableLink(name);
            this.links.put(name, tableLink);
            this.sortedLinks.add(tableLink);
        }
        return tableLink;
    }

    private CollectionRenderer.TableLink getTableLink(int order) {
        Collections.sort(this.sortedLinks);
        return this.sortedLinks.get(order);
    }

    public String getLink(String name) {
        return this.getTableLink(name).getLink();
    }

    public void setLink(String name, String value) {
        this.getTableLink(name).setLink(value);
    }

    public String getModule(String name) {
        return this.getTableLink(name).getModule();
    }

    public void setModule(String name, String value) {
        this.getTableLink(name).setModule(value);
    }

    public String getParam(String name) {
        return this.getTableLink(name).getParam();
    }

    public void setParam(String name, String value) {
        this.getTableLink(name).setParam(value);
    }

    public String getKey(String name) {
        return this.getTableLink(name).getKey();
    }

    public void setKey(String name, String value) {
        this.getTableLink(name).setKey(value);
    }

    public String getBundle(String name) {
        return this.getTableLink(name).getBundle();
    }

    public void setBundle(String name, String value) {
        this.getTableLink(name).setBundle(value);
    }

    public String getText(String name) {
        return this.getTableLink(name).getText();
    }

    public void setText(String name, String value) {
        this.getTableLink(name).setText(value);
    }

    public String getOrder(String name) {
        return this.getTableLink(name).getOrder();
    }

    public void setOrder(String name, String value) {
        this.getTableLink(name).setOrder(value);
    }

    public boolean isExcludedFromFirst(String name) {
        return this.getTableLink(name).isExcludeFromFirst();
    }

    public void setExcludedFromFirst(String name, String value) {
        this.getTableLink(name).setExcludeFromFirst(new Boolean(value).booleanValue());
    }

    public boolean isExcludedFromLast(String name) {
        return this.getTableLink(name).isExcludeFromLast();
    }

    public void setVisibleIf(String name, String value) {
        this.getTableLink(name).setVisibleIf(value);
    }

    public String getVisibleIf(String name) {
        return this.getTableLink(name).getVisibleIf();
    }

    public void setVisibleIfNot(String name, String value) {
        this.getTableLink(name).setVisibleIfNot(value);
    }

    public String getVisibleIfNot(String name) {
        return this.getTableLink(name).getVisibleIfNot();
    }

    public void setExcludedFromLast(String name, String value) {
        this.getTableLink(name).setExcludeFromLast(new Boolean(value).booleanValue());
    }

    public boolean isGroupLinks() {
        return this.groupLinks;
    }

    public void setGroupLinks(boolean groupLinks) {
        this.groupLinks = groupLinks;
    }

    public String getLinkGroupSeparator() {
        return this.linkGroupSeparator;
    }

    public void setLinkGroupSeparator(String linkGroupSeparator) {
        this.linkGroupSeparator = linkGroupSeparator;
    }

    public boolean isShowOldCompetenceCourses() {
        return this.showOldCompetenceCourses;
    }

    public void setShowOldCompetenceCourses(boolean showOldCompetenceCourses) {
        this.showOldCompetenceCourses = showOldCompetenceCourses;
    }

    public String getLinkFormat(String name) {
        return this.getTableLink(name).getLinkFormat();
    }

    public void setLinkFormat(String name, String value) {
        this.getTableLink(name).setLinkFormat(value);
    }

    public String getCustomLink(String name) {
        return this.getTableLink(name).getCustom();
    }

    public void setCustomLink(String name, String value) {
        this.getTableLink(name).setCustom(value);
    }

    public String getContextRelative(String name) {
        return Boolean.toString(this.getTableLink(name).isContextRelative());
    }

    public void setContextRelative(String name, String value) {
        this.getTableLink(name).setContextRelative(Boolean.valueOf(Boolean.parseBoolean(value)));
    }

    protected Layout getLayout(Object object, Class type) {
        return new ComputerCourseVersionLayout();
    }

    public String getGroupNameClasses() {
        return this.groupNameClasses;
    }

    public void setGroupNameClasses(String groupNameClasses) {
        this.groupNameClasses = groupNameClasses;
    }

    private class ComputerCourseVersionLayout
    extends Layout {
        private static final String CAPTION_CLASSES = "mtop15 mbottom05";
        private boolean futureDepartmentMessageShown = false;
        private boolean futureGroupMessageShown = false;
        private boolean futureTransferMessageShown = false;
        private boolean oldDepartmentMessageShown = false;

        private ComputerCourseVersionLayout() {
        }

        private void setFutureDepartmentMessageShown(boolean futureDepartmentMessageShown) {
            this.futureDepartmentMessageShown = futureDepartmentMessageShown;
        }

        private boolean isFutureDepartmentMessageShown() {
            return this.futureDepartmentMessageShown;
        }

        private void setFutureGroupMessageShown(boolean futureGroupMessageShown) {
            this.futureGroupMessageShown = futureGroupMessageShown;
        }

        private boolean isFutureGroupMessageShown() {
            return this.futureGroupMessageShown;
        }

        private void setFutureTransferMessageShown(boolean futureTransferMessageShown) {
            this.futureTransferMessageShown = futureTransferMessageShown;
        }

        private boolean isFutureTransferMessageShown() {
            return this.futureTransferMessageShown;
        }

        private void setOldDepartmentMessageShown(boolean oldDepartmentMessageShown) {
            this.oldDepartmentMessageShown = oldDepartmentMessageShown;
        }

        private boolean isOldDepartmentMessageShown() {
            return this.oldDepartmentMessageShown;
        }

        public HtmlComponent createComponent(Object object, Class type) {
            Department department = (Department)((Object)object);
            HtmlBlockContainer listContainer = new HtmlBlockContainer();
            for (ScientificAreaUnit scientificArea : department.getDepartmentUnit().getScientificAreaUnits()) {
                HtmlText areaName = new HtmlText(scientificArea.getNameI18n().getContent());
                if (CompetenceCourseVersionList.this.getScientificAreaNameClasses() != null) {
                    areaName.setClasses(CompetenceCourseVersionList.this.getScientificAreaNameClasses());
                }
                HtmlList list = new HtmlList();
                CurricularStage stage = null;
                if (CompetenceCourseVersionList.this.getFilterBy() != null) {
                    stage = CurricularStage.valueOf(CompetenceCourseVersionList.this.getFilterBy());
                }
                for (CompetenceCourseGroupUnit group : scientificArea.getCompetenceCourseGroupUnits()) {
                    HtmlTableCell cell;
                    HtmlComponent coursePresentation;
                    HtmlTableRow courseRow;
                    HtmlListItem item = list.createItem();
                    HtmlBlockContainer courseContainer = new HtmlBlockContainer();
                    HtmlText groupName = new HtmlText(group.getPresentationName());
                    if (CompetenceCourseVersionList.this.getGroupNameClasses() != null) {
                        groupName.setClasses(CompetenceCourseVersionList.this.getGroupNameClasses());
                    }
                    courseContainer.addChild((HtmlComponent)groupName);
                    HtmlTable table = new HtmlTable();
                    for (CompetenceCourse course : group.getCurrentOrFutureCompetenceCourses()) {
                        if (!course.getCurricularStage().equals((Object)stage)) continue;
                        courseRow = table.createRow();
                        coursePresentation = this.getCurrentOrFutureCoursePresentation(course, group, department.getDepartmentUnit());
                        if (CompetenceCourseVersionList.this.getCourseNameClasses() != null) {
                            coursePresentation.setClasses(CompetenceCourseVersionList.this.getCourseNameClasses());
                        }
                        courseRow.createCell().setBody(coursePresentation);
                        cell = courseRow.createCell();
                        cell.setBody(this.getLinks(course));
                        cell.setClasses("aright");
                    }
                    if (CompetenceCourseVersionList.this.isShowOldCompetenceCourses()) {
                        for (CompetenceCourse course : group.getOldCompetenceCourses()) {
                            if (!course.getCurricularStage().equals((Object)stage)) continue;
                            courseRow = table.createRow();
                            coursePresentation = this.getOldCoursePresentation(course);
                            if (CompetenceCourseVersionList.this.getCourseNameClasses() != null) {
                                coursePresentation.setClasses(CompetenceCourseVersionList.this.getCourseNameClasses());
                            }
                            courseRow.createCell().setBody(coursePresentation);
                            cell = courseRow.createCell();
                            cell.setBody(this.getLinks(course));
                            cell.setClasses("aright");
                        }
                    }
                    courseContainer.addChild((HtmlComponent)table);
                    if (CompetenceCourseVersionList.this.getTableClasses() != null) {
                        table.setClasses(CompetenceCourseVersionList.this.getTableClasses());
                    }
                    item.setBody((HtmlComponent)courseContainer);
                }
                listContainer.addChild((HtmlComponent)areaName);
                listContainer.addChild((HtmlComponent)list);
            }
            HtmlBlockContainer container = new HtmlBlockContainer();
            container.addChild(this.getCaptionPresentation());
            container.addChild((HtmlComponent)listContainer);
            return container;
        }

        protected HtmlComponent getLinks(CompetenceCourse course) {
            HtmlInlineContainer container = new HtmlInlineContainer();
            int total = CompetenceCourseVersionList.this.sortedLinks.size();
            for (int i = 0; i < total; ++i) {
                CollectionRenderer.TableLink tableLink = CompetenceCourseVersionList.this.getTableLink(i);
                container.addChild(tableLink.generateLink((Object)course));
                if (i + 1 >= total) continue;
                container.addChild((HtmlComponent)new HtmlText(CompetenceCourseVersionList.this.getLinkGroupSeparator()));
            }
            container.setIndented(false);
            return container;
        }

        private HtmlComponent getCurrentOrFutureCoursePresentation(CompetenceCourse course, CompetenceCourseGroupUnit group, DepartmentUnit department) {
            HtmlInlineContainer container = new HtmlInlineContainer();
            if (!StringUtils.isEmpty((String)course.getCode())) {
                container.addChild((HtmlComponent)new HtmlText(course.getCode()));
                container.addChild((HtmlComponent)new HtmlText(" - "));
            }
            container.addChild((HtmlComponent)new HtmlText(course.getName()));
            container.addChild((HtmlComponent)new HtmlText(" ("));
            container.addChild((HtmlComponent)new HtmlText(course.getAcronym()));
            container.addChild((HtmlComponent)new HtmlText(") "));
            container.addChild(this.getStage(course.getCurricularStage()));
            if (course.getCompetenceCourseGroupUnit() != group) {
                container.addChild((HtmlComponent)new HtmlText(" ("));
                container.addChild(this.getFutureTransferMessage(course));
                container.addChild((HtmlComponent)new HtmlText(") "));
            } else if (course.getDepartmentUnit(ExecutionSemester.readLastExecutionSemester()) != department) {
                container.addChild((HtmlComponent)new HtmlText(" ("));
                container.addChild(this.getFutureDepartmentMessage(course));
                container.addChild((HtmlComponent)new HtmlText(") "));
            } else if (course.getCompetenceCourseGroupUnit(ExecutionSemester.readLastExecutionSemester()) != group) {
                container.addChild((HtmlComponent)new HtmlText(" ("));
                container.addChild(this.getFutureGroupMessage(course));
                container.addChild((HtmlComponent)new HtmlText(") "));
            }
            container.setIndented(false);
            return container;
        }

        private HtmlComponent getFutureDepartmentMessage(CompetenceCourse course) {
            this.setFutureDepartmentMessageShown(true);
            HtmlText text = new HtmlText(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"future.department", (String[])new String[0]) + ": " + course.getDepartmentUnit(ExecutionSemester.readLastExecutionSemester()).getAcronym());
            text.setClasses(CompetenceCourseVersionList.this.getMessageClass());
            return text;
        }

        private HtmlComponent getFutureGroupMessage(CompetenceCourse course) {
            this.setFutureGroupMessageShown(true);
            HtmlText text = new HtmlText(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"future.group", (String[])new String[0]) + ": " + course.getCompetenceCourseGroupUnit(ExecutionSemester.readLastExecutionSemester()).getName());
            text.setClasses(CompetenceCourseVersionList.this.getMessageClass());
            return text;
        }

        private HtmlComponent getFutureTransferMessage(CompetenceCourse course) {
            this.setFutureTransferMessageShown(true);
            HtmlText text = new HtmlText(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"future.transfer", (String[])new String[0]));
            text.setClasses(CompetenceCourseVersionList.this.getMessageClass());
            return text;
        }

        private HtmlComponent getOldCoursePresentation(CompetenceCourse course) {
            HtmlInlineContainer container = new HtmlInlineContainer();
            if (!StringUtils.isEmpty((String)course.getCode())) {
                container.addChild((HtmlComponent)new HtmlText(course.getCode()));
                container.addChild((HtmlComponent)new HtmlText(" - "));
            }
            container.addChild((HtmlComponent)new HtmlText(course.getName()));
            container.addChild((HtmlComponent)new HtmlText(" ("));
            container.addChild((HtmlComponent)new HtmlText(course.getAcronym()));
            container.addChild((HtmlComponent)new HtmlText(") "));
            container.addChild(this.getStage(course.getCurricularStage()));
            container.addChild((HtmlComponent)new HtmlText(" ("));
            container.addChild(this.getOldDepartmentMessage(course));
            container.addChild((HtmlComponent)new HtmlText(")"));
            container.setIndented(false);
            return container;
        }

        private HtmlComponent getOldDepartmentMessage(CompetenceCourse course) {
            this.setOldDepartmentMessageShown(true);
            HtmlText text = new HtmlText(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"current.department", (String[])new String[0]) + ": " + course.getDepartmentUnit().getAcronym());
            text.setClasses(CompetenceCourseVersionList.this.getMessageClass());
            return text;
        }

        private HtmlComponent getCaptionPresentation() {
            HtmlBlockContainer container = new HtmlBlockContainer();
            if (this.isFutureDepartmentMessageShown() || this.isFutureGroupMessageShown() || this.isFutureTransferMessageShown() || this.isOldDepartmentMessageShown()) {
                HtmlText message;
                HtmlInlineContainer messageLine;
                HtmlListItem item;
                HtmlText caption = new HtmlText(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"caption", (String[])new String[0]));
                caption.setClasses(CAPTION_CLASSES);
                caption.setFace(Face.STRONG);
                container.addChild((HtmlComponent)caption);
                HtmlList list = new HtmlList();
                if (this.isOldDepartmentMessageShown()) {
                    item = list.createItem();
                    messageLine = new HtmlInlineContainer();
                    message = new HtmlText(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"current.department", (String[])new String[0]) + ":");
                    message.setFace(Face.EMPHASIS);
                    messageLine.addChild((HtmlComponent)message);
                    messageLine.addChild((HtmlComponent)new HtmlText(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"current.department.caption", (String[])new String[0])));
                    item.addChild((HtmlComponent)messageLine);
                }
                if (this.isFutureDepartmentMessageShown()) {
                    item = list.createItem();
                    messageLine = new HtmlInlineContainer();
                    message = new HtmlText(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"future.department", (String[])new String[0]) + ":");
                    message.setFace(Face.EMPHASIS);
                    messageLine.addChild((HtmlComponent)message);
                    messageLine.addChild((HtmlComponent)new HtmlText(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"future.department.caption", (String[])new String[0])));
                    item.addChild((HtmlComponent)messageLine);
                }
                if (this.isFutureGroupMessageShown()) {
                    item = list.createItem();
                    messageLine = new HtmlInlineContainer();
                    message = new HtmlText(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"future.group", (String[])new String[0]) + ":");
                    message.setFace(Face.EMPHASIS);
                    messageLine.addChild((HtmlComponent)message);
                    messageLine.addChild((HtmlComponent)new HtmlText(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"future.group.caption", (String[])new String[0])));
                    item.addChild((HtmlComponent)messageLine);
                }
                if (this.isFutureTransferMessageShown()) {
                    item = list.createItem();
                    messageLine = new HtmlInlineContainer();
                    message = new HtmlText(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"future.transfer", (String[])new String[0]) + ":");
                    message.setFace(Face.EMPHASIS);
                    messageLine.addChild((HtmlComponent)message);
                    messageLine.addChild((HtmlComponent)new HtmlText(BundleUtil.getString((String)"resources.BolonhaManagerResources", (String)"future.transfer.caption", (String[])new String[0])));
                    item.addChild((HtmlComponent)messageLine);
                }
                container.addChild((HtmlComponent)list);
            }
            return container;
        }

        private HtmlComponent getStage(CurricularStage curricularStage) {
            HtmlText text = new HtmlText(RenderUtils.getEnumString((Enum)curricularStage));
            switch (curricularStage) {
                case DRAFT: {
                    text.setClasses(CompetenceCourseVersionList.this.getDraftClass());
                    break;
                }
                case PUBLISHED: {
                    text.setClasses(CompetenceCourseVersionList.this.getPublishedClass());
                    break;
                }
                case APPROVED: {
                    text.setClasses(CompetenceCourseVersionList.this.getApprovedClass());
                }
            }
            return text;
        }
    }
}

