/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.teacher;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Summary;
import org.fenixedu.academic.dto.SummariesManagementBean;
import org.fenixedu.academic.service.ServiceMonitoring;
import org.fenixedu.academic.service.filter.ExecutionCourseLecturingTeacherAuthorizationFilter;
import org.fenixedu.academic.service.filter.SummaryManagementToTeacherAuthorizationFilter;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.academic.service.services.teacher.CreateSummary$callable$runCreateSummary;
import org.fenixedu.academic.service.services.teacher.CreateSummary$callable$runEditSummary;
import org.fenixedu.bennu.signals.DomainObjectEvent;
import org.fenixedu.bennu.signals.Signal;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CreateSummary {
    private static final CreateSummary serviceInstance;
    public static final Advice advice$runCreateSummary;
    public static final Advice advice$runEditSummary;

    protected void run(SummariesManagementBean bean) {
        ServiceMonitoring.logService(this.getClass(), bean);
        if (bean.isNewSummary()) {
            Summary summary = new Summary(bean.getTitle(), bean.getSummaryText(), bean.getStudentsNumber(), bean.getSummaryType().equals((Object)SummariesManagementBean.SummaryType.EXTRA_SUMMARY), bean.getProfessorship(), bean.getTeacherName(), bean.getTeacher(), bean.getShift(), bean.getLesson(), bean.getSummaryDate(), bean.getSummaryRoom(), bean.getSummaryTime(), bean.getLessonType(), bean.getTaught());
            Signal.emit((String)"academic.summary.create.signal", (Object)new DomainObjectEvent((DomainObject)summary));
        } else {
            bean.getSummary().edit(bean.getTitle(), bean.getSummaryText(), bean.getStudentsNumber(), bean.getSummaryType().equals((Object)SummariesManagementBean.SummaryType.EXTRA_SUMMARY), bean.getProfessorship(), bean.getTeacherName(), bean.getTeacher(), bean.getShift(), bean.getLesson(), bean.getSummaryDate(), bean.getSummaryRoom(), bean.getSummaryTime(), bean.getLessonType(), bean.getTaught());
        }
    }

    public static void runCreateSummary(SummariesManagementBean summariesManagementBean) throws NotAuthorizedException {
        Object object = advice$runCreateSummary.perform((Callable)new CreateSummary$callable$runCreateSummary(summariesManagementBean));
    }

    static /* synthetic */ void advised$runCreateSummary(SummariesManagementBean bean) throws NotAuthorizedException {
        ExecutionCourseLecturingTeacherAuthorizationFilter.instance.execute(bean);
        serviceInstance.run(bean);
    }

    public static void runEditSummary(SummariesManagementBean summariesManagementBean) throws NotAuthorizedException {
        Object object = advice$runEditSummary.perform((Callable)new CreateSummary$callable$runEditSummary(summariesManagementBean));
    }

    static /* synthetic */ void advised$runEditSummary(SummariesManagementBean bean) throws NotAuthorizedException {
        SummaryManagementToTeacherAuthorizationFilter.instance.execute(bean.getSummary(), bean.getProfessorshipLogged());
        serviceInstance.run(bean);
    }

    static {
        advice$runCreateSummary = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$runEditSummary = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        serviceInstance = new CreateSummary();
    }
}

