/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.report.academicAdministrativeOffice;

import java.text.MessageFormat;
import java.util.Locale;
import org.apache.commons.lang.WordUtils;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.UniversityUnit;
import org.fenixedu.academic.domain.phd.serviceRequests.documentRequests.PhdDiplomaRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IDocumentRequest;
import org.fenixedu.academic.report.academicAdministrativeOffice.AdministrativeOfficeDocument;
import org.fenixedu.academic.util.StringFormatter;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.LocalDate;

public class PhdDiploma
extends AdministrativeOfficeDocument {
    private static final long serialVersionUID = 1L;

    protected PhdDiploma(IDocumentRequest documentRequest) {
        super(documentRequest);
    }

    @Override
    protected PhdDiplomaRequest getDocumentRequest() {
        return (PhdDiplomaRequest)super.getDocumentRequest();
    }

    @Override
    protected void fillReport() {
        this.addInstitutionParameters();
        this.addPersonParameters();
        UniversityUnit university = this.getUniversity(this.getDocumentRequest().getRequestDate());
        String universityName = university.getPartyName().getPreferedContent();
        PhdDiplomaRequest diplomaRequest = this.getDocumentRequest();
        String phdProgramConclusion = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.diploma.pdhProgramConclusion", (String[])new String[0]);
        ExecutionYear conclusionYear = ExecutionYear.readByDateTime(diplomaRequest.getConclusionDate());
        String phdProgramDescription = this.getDocumentRequest().getPhdIndividualProgramProcess().getPhdProgram().getDegree().getNameI18N(conclusionYear).getContent(this.getLanguage());
        String phdConclusionDate = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.diploma.pdhConclusionDate", (String[])new String[0]);
        this.addParameter("conclusionMessage", phdProgramConclusion);
        this.addParameter("phdProgram", phdProgramDescription);
        this.addParameter("conclusionDate", MessageFormat.format(phdConclusionDate, diplomaRequest.getConclusionDate().toString(this.getDatePattern(), this.getLocale()).toLowerCase()));
        this.addParameter("documentNumber", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.diploma.documentNumber", (String[])new String[0]));
        this.addParameter("registryCode", diplomaRequest.hasRegistryCode() ? diplomaRequest.getRegistryCode().getCode() : null);
        this.addParameter("institutionName", Bennu.getInstance().getInstitutionUnit().getName());
        this.addParameter("day", MessageFormat.format(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.diploma.university.actualDate", (String[])new String[0]), universityName, this.getFormatedCurrentDate()));
        this.addParameter("classificationResult", MessageFormat.format(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.Diploma.classificationResult", (String[])new String[0]), diplomaRequest.getThesisFinalGrade().getLocalizedName(this.getLocale())));
        this.addParameter("dissertationTitle", diplomaRequest.getDissertationThesisTitle());
        this.addParameter("graduateTitle", diplomaRequest.getGraduateTitle(this.getLocale()));
        if (this.getUniversity(this.getDocumentRequest().getRequestDate()) != this.getUniversity(this.getDocumentRequest().getConclusionDate().toDateTimeAtCurrentTime())) {
            this.addParameter("UTLDescription", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.diploma.UTLDescription", (String[])new String[0]));
            this.addParameter("certification", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.diploma.phd.certification.UTL", (String[])new String[0]));
        } else {
            this.addParameter("UTLDescription", "");
            this.addParameter("certification", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.diploma.phd.certification.UL", (String[])new String[0]));
        }
        this.addParameter("message1", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.diploma.message1", (String[])new String[0]));
        this.addParameter("message3", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.diploma.message3", (String[])new String[0]));
        this.addParameter("phdmessage1", BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.diploma.message1", (String[])new String[0]));
    }

    private String getFormatedCurrentDate() {
        return new LocalDate().toString(this.getDatePattern(), this.getLocale()).toLowerCase();
    }

    private String getDatePattern() {
        StringBuilder result = new StringBuilder();
        result.append("dd '");
        result.append(BundleUtil.getString((String)"resources.ApplicationResources", (Locale)this.getLocale(), (String)"label.of", (String[])new String[0]));
        result.append("' MMMM '");
        result.append(BundleUtil.getString((String)"resources.ApplicationResources", (Locale)this.getLocale(), (String)"label.of", (String[])new String[0]));
        result.append("' yyyy");
        return result.toString();
    }

    private void addPersonParameters() {
        Person person = this.getDocumentRequest().getPerson();
        this.addParameter("name", StringFormatter.prettyPrint(person.getName()));
        this.addParameter("nameOfFather", StringFormatter.prettyPrint(person.getNameOfFather()));
        this.addParameter("nameOfMother", StringFormatter.prettyPrint(person.getNameOfMother()));
        if (person.getCountry() == null) {
            throw new DomainException("error.personWithoutParishOfBirth", new String[0]);
        }
        String countryUpperCase = person.getCountry().getCountryNationality().getContent(this.getLanguage()).toLowerCase();
        String country = WordUtils.capitalize((String)countryUpperCase);
        String nationality = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"diploma.nationality", (String[])new String[0]);
        this.addParameter("birthLocale", MessageFormat.format(nationality, country));
    }

    private void addInstitutionParameters() {
        String rectorGrant;
        String rectorGender;
        this.addParameter("universityName", this.getUniversity(this.getDocumentRequest().getRequestDate()).getName());
        this.addParameter("universityPrincipal", (Object)this.getUniversity(this.getDocumentRequest().getRequestDate()).getCurrentPrincipal());
        String institutionUnitName = this.getInstitutionName();
        Person principal = this.getUniversity(this.getDocumentRequest().getRequestDate()).getCurrentPrincipal();
        Person president = this.getUniversity(this.getDocumentRequest().getRequestDate()).getCurrentPresident();
        UniversityUnit university = this.getUniversity(this.getDocumentRequest().getRequestDate());
        String universityName = university.getPartyName().getPreferedContent();
        String presidentGender = president.isMale() ? BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.presidentMale", (String[])new String[0]) : BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.presidentFemale", (String[])new String[0]);
        if (principal.isMale()) {
            rectorGender = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.rectorMale", (String[])new String[0]);
            rectorGrant = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.presidentGrantMale", (String[])new String[0]);
        } else {
            rectorGender = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.rectorFemale", (String[])new String[0]);
            rectorGrant = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.phd.registryDiploma.presidentGrantFemale", (String[])new String[0]);
        }
        this.addParameter("theRector", rectorGender);
        this.addParameter("president", MessageFormat.format(presidentGender, institutionUnitName));
        String firstParagraph = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)this.getLocale(), (String)"label.diploma.universityPrincipal", (String[])new String[0]);
        this.addParameter("firstParagraph", MessageFormat.format(firstParagraph, rectorGender, universityName, rectorGrant, principal.getValidatedName()));
    }
}

